var g_drag = {
    list: {},
    init() {
        g_style.addStyle('drag', `
            .darg_actived {

            }
        `)
    },
    register(name, opts) {
        this.list[name] = Object.assign({
            board: false,
        }, opts)
        this.bind(name)
        return this
    },
    get(name) {
        return this.list[name]
    },
    show(name) {},
    bind(name) {
        let self = this
        let opts = this.get(name)
        let {html, board, badge, image, selector, target, parentDiv} = opts

        let current
        $(document).
        on('dragstart', selector, e => {
            e = e.originalEvent
            if(image){
                let {width, height, url} = image
                e.dataTransfer.setDragImage(((new Image()).src(url)), width, height);
            }
            e.dataTransfer.effectAllowed = "all";
            // e.dataTransfer.types = ['test'];
            opts.onDragStart(e)
        }).
        on('dragend', selector, e => {
            self.hide(name)
            opts.onDargEnd && opts.onDargEnd(e)
            insertEl(badge, {remove: true})
        }).
        on('drop', target, e => {
            opts.onDrop(e.originalEvent)
            insertEl(badge, {remove: true})
        }).
        on('dragenter', target, e => e.preventDefault()).
        on('dragover', target, function(e){
            let {accept , tip} = opts.onUpdateTarget(e) || {}
            if(accept){
                let {target, clientX, clientY} = e
                tip.length && insertEl(badge).css({
                    left: clientX + 20,
                    top: clientY + 20,
                }).html(tip).show()
    
                let div = self.getElement(name)
                if (!div.length && !isEmpty(html)) div = $(`<div class="w-max h-max" id="_drag_${name}" style="z-index: 9999;position:fixed;pointer-events: none;">${html}</div>`).appendTo('body')
                // 绘制边框
                if (board) {
                    $('.darg_actived').removeClass('darg_actived')
                    target.classList.add('darg_actived')
                }
            }
            clearEventBubble(e)
        }).
        on('dragleave', target, function(e){
            if(!isEmpty(parentDiv) && g_cache.mouse){
                let parent = $(this).parents(parentDiv)
                if(parent.length && !inArea({ x: g_cache.mouse.pageX, y: g_cache.mouse.pageY }, parent)){
                    insertEl(badge, {remove: true})
                    clearEventBubble(e)
                    return false
                }
            }
        })
    },

    getElement(name) {
        return $('#_drag_' + name)
    },

    hide(name) {
        this.getElement(name).remove()
    },

}

$()
g_drag.init()