/*
此对象用于监听dom切换可视状态
也可以获取最后一个可视的dom
起初是用于实现：按ctrl+1-9可以对当前显示的tablist进行标签切换
*/
class domObserver {

    constructor(opts){
        this.opts = Object.assign({
            onShown: () => {},
        }, opts)
        this.mutation = new MutationObserver((mutations) => {
              mutations.forEach((mutation) => {
                mutation.addedNodes.forEach(dom => opts.checkUpdate(dom, 'add') === true && this.bind());
                mutation.removedNodes.forEach(dom => opts.checkUpdate(dom, 'remove') === true && this.bind());
              });
        }).observe(opts.parent || document.body, { childList: true, subtree: true });
        this.bind()
    }

    bind(){
        this.unbind()
        let observer = this.observer = new IntersectionObserver((entries) => {
          let showing = entries.filter(entry => {
            return entry.isIntersecting && entry.target.offsetParent !== null
          })
            if(showing.length){
                if(this.visibleContainer != undefined) this.last = this.visibleContainer
                this.visibleContainer = $(showing[0].target) // 生成新的对象
            }else{
                this.visibleContainer = undefined
            }
            this.current = this.visibleContainer || this.last
            this.opts.onShown(this.current)
        });
        $(this.opts.selector).each((i, dom) => observer.observe(dom))
    }

    unbind(){
        delete this.last
        delete this.current
        delete this.visibleContainer
        this.observer && this.observer.disconnect()
    }
    
}