const db_deepFolder = function (opts) {
    var _type = opts.name
    var _icon = opts.icon
    var _table = _type + '_meta'
    const isBrowser = typeof(window) != 'undefined'
    var _g_plugin = typeof(g_plugin) == 'undefined' ? opts.g_plugin : g_plugin
    var _g_data = typeof(g_data) == 'undefined' ? opts.g_data : g_data
    var _g_rule = typeof(g_rule) == 'undefined' ? opts.g_rule : g_rule
    _g_rule.register(_type, {
        title: _type,
        sqlite(data) {
            return {
                method: 'select',
                search: 'id,md5',
                table: 'files',
                args: {
                    [_type]: `JOIN ${_table} ON files.id = ${_table}.fid`
                },
                where: {
                    [_type]: `${_table}.ids like '%${_g_data.arr_join(data.ids)}%'`
                }
            }
        },
        sidebar: opts.sidebar,
        update: false,
    })


    var _g_detail = typeof(g_detail) == 'undefined' ? opts.g_detail : g_detail

    if(!isBrowser){
        eval(`var {toArr, isEmpty} = require('./until_server.js')`)
        var {SQL_builder} = require('./sqlite_builer.js')({g_data: _g_data})
    }

    var self = new basedata(Object.assign({
        name: _type,
        primarykey: 'id',
        icon: _icon,
        defaultList: opts.defaultList,
        title: opts.title,
        insertDefault(id) {
            return {
                id,
                meta: {},
                parent: '',
                icon: _icon,
                title: opts.defaultTitle,
                ctime: new Date().getTime()
            }
        },
        event: {
            set: ({ vals }) => self.data_set(vals.id, vals),
            remove: ({ vals }) => self.data_remove(vals.id),
            reset: () => self.refresh('reset')
        },
        data_set(id, data) {
            // TODO 移除meta空值..
            data.icon ??= _icon
            if (data.parent == 0) data.parent = '' // 默认文件夹不能有子目录
            data.meta = JSON.stringify(data.meta)
            return _g_data.data_set2({
                table: _type,
                key: 'id',
                value: id,
                data,
            }).then(ret => ret.changes > 0 && self.refresh('data_set'))
        },
        data_remove(id) {
            return _g_data.data_remove2({
                table: _type,
                key: 'id',
                value: id,
            }).then(ret => ret.changes > 0 && self.refresh('data_remove'))
        },
        setMetaData(id, vals) {
            let data = this.get(id)
            let meta = Object.assign(data.meta, vals)
            this.set(id, data)
            return { ...meta }
        },
        removeItemFolder(fid) {
            return _g_data.data_remove2({ table: _table, key: 'fid', value: fid })
        },
        async setItemFolder(fid, ids, update = true) {
            ids = toArr(ids)
            fid = await _g_data.data_getID(fid)
            // TODO 如果ids为空则删除...
            // if(fid.length == 32) 
            ids = _g_data.arr_join(ids)
            _g_data.data_set2({ table: _table, key: 'fid', value: fid, data: { fid, ids } }).then(() => {
                if (_g_detail.getSelected && _g_detail.getSelected('id').includes(fid)) { // 正在侧边展示信息
                    g_pp.setTimeout(_type + '_update', () => _g_detail.updateColumns(_type), 100)
                }
            })
        },
        async getItemFolder(d) {
            let ids = obj_From_key(await _g_data.getMetaInfo(d, _type), 'ids').ids
            return typeof (ids) == 'string' ? _g_data.arr_split(ids).map(id => parseInt(id)) : toArr(ids)
        },
        getSqlite(ids, opts = {}) {
            return new window.SQL_builder({ ..._g_rule.list[this.name].sqlite({ ids }), ...opts })
        },
        getFoldersItem(ids, limit = 1) {
            let ret = {}
            ids ??= this.list.map(({ id }) => id)
            return new Promise(reslove => {
                Promise.all(ids.map(async id => {
                    let sqlite = this.getSqlite([id], { limit })
                    ret[id] = await sqlite.all()
                })).then(() => reslove(ret))
            })
        },
        inited: false,
        async getList() {
            let list = await _g_data.all('SELECT * FROM ' + _type)
            // return [...this.defaultList, ...list]
            return list
        },
        folder_toIds(list) {
            return toArr(list).map((id, i) => {
                if (!isNaN(Number(id)) && this.exists(id)) {
                    return id
                }
                let title = id
                let fid = this.folder_getIdByTitle(title)
                if (fid == -1) fid = this.folder_add({ title })
                return fid
            })
        },
        refresh(source) {
            if (isEmpty(source)) return
            self.getList().then(list => {
                self.list = list.map(item => {
                    // 修复错误
                    if (item.parent == item.id) item.parent = ''

                    if (typeof (item.meta) == 'string') {
                        try {
                            item.meta = JSON.parse(item.meta)
                        } catch (err) {
                            item.meta = {}
                        }
                    }
                    return item
                })
                if (!self.inited) {
                    self.inited = true
                    // 保证默认列表存在数据库内
                    self.defaultList.forEach(item => this.set(item.id, item, false))
                }
                self.update()
            })
        },

        folder_setValue(id, key, v) {
            let item = this.get(id)
            if (item) {
                this.set(id, Object.assign(item, { [key]: v }))
            }
            return item
        },

        folder_getValue(id, key, defV) {
            let item = this.get(id) || {}
            return item[key] || defV
        },

        // 添加目录
        folder_add(vals) {
            if (typeof (vals) != 'object') {
                vals = {
                    title: vals
                }
            }
            if (isEmpty(vals.title))
                return

            let id = this.folder_getIdByTitle(vals.title)
            if (id == -1) id = this.getNextId()
            this.set(id, vals)
            return id
        },

        folder_getIdByTitle(title) {
            let id = this.search('title', title)
            return id != undefined ? parseInt(id) : -1
        },

        // 获取父目录
        folder_getParent(id) {
            return (this.get(id) || { parent: '' }).parent
        },

        // 获取所有父目录
        folder_getParents(id) {
            let r = []
            const next = pid => this.folder_getParent(pid, 'parent')
            let p = next(id)
            while (!isEmpty(p)) {
                r.unshift(p)
                p = next(p)
            }
            return r
        },

        // 获取同级目录
        folder_getSibilings(id, retObj) {
            let pid = this.folder_getParent(id)
            if (pid != undefined) {
                return this.folder_getChildren(pid, retObj)
            }
        },

        // 获取子目录
        folder_getChildren(id, obj = false) {
            id = String(id)
            let r = obj ? {} : []
            this.entries((k, v) => {
                if (String(v.parent) === id && v.id !== id) {
                    k = this.getIndex(v, k)
                    obj ? r[k] = v : r.push(k)
                }
            })
            return r
        },

        // 查询数据库
        folder_queryItems(ids, cnt = false) {
            ids = toArr(ids)
            let sqlite = new SQL_builder(_g_rule.list[this.name].sqlite({ ids }))
            return sqlite.all(cnt)
        },

        // 删除目录
        folder_remove(id, remove = true) {
            // TODO: 提示是否删除所有获取子目录
            let parent = this.folder_getParent(id)
            this.folder_getChildren(id).forEach(child => {
                let index = this.find(child) // 目录id转所在下标
                if (remove) {
                    this.remove(index)
                } else {
                    this.merge(index, { parent }) // 更改子目录到同级目录
                }
            })
            // 删除素材属性
            this.folder_queryItems(id).then(items => {
                items.forEach(async ({ id }) => {
                    // TODO 封装成函数
                    let ids = await this.getItemFolder(id)
                    ids.splice(ids.indexOf(id), 1)
                    this.setItemFolder(id, ids)
                })
            })
            // TODO: 关闭tab
            // _g_datalist.tabs.data.entries((k, v) =>{
            //     if(v.data.type == this.name && v.data?.params?.include(id)){
            //         _g_datalist.tabs.close(v.id)
            //     }
            // });
            this.remove(id)
        },

        // 获取下个ID
        getNextId() {
            let len = this.count()
            if (len > 0) {
                len = this.getChild(len - 1).id + 1
            }
            return len
        },

        folder_sort(type, list) {
            if (!type) type = g_filter.getOpts(`filter.${_type}.type`, 'sz')
            if (!list) list = this.getIndexs()
            return g_sort.sort(type, list)
        },

        folder_edit(fid, parent = '') {
            let d = Object.assign({
                icon: _icon,
                title: '',
                parent,
            }, fid ? this.get(fid) : {})

            let id = _type + '_edit'
            g_form.confirm(id, {
                elements: {
                    title: {
                        title: '名称',
                        required: true,
                        value: d.title,
                    },
                    parent: {
                        title: '上级',
                        type: _type,
                        value: d.parent,
                        otps: {
                            multi: false,
                        }
                    },
                    icon: {
                        title: '图标',
                        type: 'icon',
                        value: d.icon,
                        placeholder: '输入网址使用网络图片',
                    }
                },
                autoFocus: 'title',
            }, {
                id,
                title: '编辑',
                btn_ok: '保存',
                onBtnClick: (btn, modal) => {
                    if (btn.id == 'btn_ok') {
                        let vals = g_form.getVals(id)
                        vals.parent = vals.parent[0] || ''
                        if (fid == undefined || fid < 0) fid = this.getNextId()
                        vals.id = fid
                        this.set(fid, vals)
                    }
                }
            })
        },
    }, isBrowser ? {
        update() {
            let list = this.folder_getChildren('', true)
            Object.values(list).forEach(item => {
                item.icon_color = item.meta.color || ''
            })
            g_category.set(_type, {
                list,
                action: 'category_' + _type,
            })
            // setTimeout(() => $(`[data-list="${_type}"]`).prop('draggable', true), 500)
        },

        init() {
            if (typeof (window) == 'undefined') return

            const self = this
            g_sort.set(_type + '_py', id => PinYinTranslate.sz(self.folder_getValue(id, 'title', '0').substr(0, 1)))
            g_sort.set(_type + '_group', id => self.folder_getValue(self.folder_getParent(id), 'title', '未分组'))

            let actions = ['edit', 'delete', 'new', 'newSub', 'clear', 'setItem', 'clone'].map(k => _type + '_' + k)
            g_action.
                registerAction(actions, (dom, action) => {
                    let id = g_menu.key
                    let data = id ? self.get(id) : {}
                    g_dropdown.hide('actions_' + _type)
                    g_menu.hideMenu('category_' + _type)
                    g_menu.hideMenu(_type + '_item')
                    switch (actions.indexOf(action[0])) {
                        case 4:
                            return self.reset()
                        case 3:
                            return self.folder_edit(-1, id)
                        case 0:
                        case 2:
                            return self.folder_edit(id || -1)
                        case 1:
                            // TODO 删除目录时更多选项(删除所有视频)
                            return confirm('确定要删除【' + self.folder_getValue(id, 'title') + '】吗？\n删除后素材不会消失', {
                                title: '删除' + self.title,
                                type: 'danger'
                            }).then(() => self.folder_remove(id))

                        case 5:
                            return doAction('detail_' + _type, dom) & setTimeout(() => g_menu.hideMenu('datalist_item'), 100)

                        case 6:
                            return self.folder_add(data.title + ' 副本')
                    }
                }).
                registerAction('detail_' + _type, (dom, action, e) => {
                    if (e && getParent(e.target, '.badge').length) return
                    self.showPrompt(obj => {
                        let selected = obj.getSelected()
                        let ids = selected.map((id, k) => {
                            if (obj.newst.includes(id)) { // 新目录
                                id = self.folder_add(id)
                            }
                            return id
                        })
                        g_detail.selected_keys.map(md5 => self.setItemFolder(md5, ids, false))
                    }, dom)
                    e && clearEventBubble(e)
                })

            _g_plugin.registerEvent('db_connected', ({ db }) => {
                db.exec(`
                        CREATE TABLE IF NOT EXISTS ${_type}(
                            id     INTEGER PRIMARY KEY AUTOINCREMENT,
                            title   VARCHAR(256),
                            icon   TEXT,
                            desc   TEXT,
                            meta   TEXT,
                            parent     INTEGER,
                            ctime     INTEGER
                        );
            
                        CREATE TABLE IF NOT EXISTS ${_table}(
                            fid    INTEGER PRIMARY KEY,
                            ids    TEXT
                        );
                    `)
                self.refresh('first')
            })

            _g_plugin.registerEvent('onBeforeShowingDetail', ({ columns, type }) => {
                if (type != 'sqlite') return

                columns[_type] = {
                    multi: true,
                    async html(items) {
                        let h = '';

                        let list = await Promise.all(items.map(item => self.getItemFolder(item.id)))
                        let ids = uniqueArr(flattenArray(list))
                        let titles = ids.map(folder => {
                            let title = self.folder_getValue(folder, 'title')
                            h += self.buildBadge({folder, title})
                            return title
                        })
                        this.data = { ids, titles }
                        return `
                        <div class="input-group input-group-sm mb-2" data-action="detail_${_type}" >
                            <span class="input-group-text" id="inputGroup-sizing-sm">${opts.detailPlaceholder}</span>
                            <div class="border-hover flex-fill cursor-text" style="max-height: 200px;overflow-y: auto;">${h}</div>
                        </div>`
                    }
                }
            })

            typeof(g_launch) != 'undefined' && g_launch.registerLaunchParam('show_'+_type, data => {
                if(data.id){
                   self.showFolder(data.id)
                }
            })

            g_action.registerAction({
                [`category_${_type}`]: dom => self.showFolder(dom.dataset.name),
                [`showFolder_${_type}`]: dom => self.showFolder(dom.dataset.folder)
            })

            g_menu.list['datalist_item'].items.unshift({
                text: '设置' + self.title,
                icon: _icon,
                action: _type + '_setItem'
            })

            g_category.registerAction(_type, (dom, action) => {
                g_menu.key = action[2] // TODO 设置dropdown的key
                g_dropdown.show('actions_' + _type, dom)
            })

            g_dropdown.register('actions_' + _type, {
                position: 'top-end',
                offsetLeft: 5,
                list: {
                    delete: {
                        title: '删除',
                        icon: 'trash',
                        class: 'text-danger',
                        action: _type + '_delete',
                    },
                }
            })

            g_input.bind(_type + '_color', ({ val }) => {
                self.setMetaData(g_menu.key, { color: val })
            })

            g_menu.registerMenu({
                name: _type + '_item',
                selector: `[data-action="category_${_type}"]`,
                dataKey: 'data-name',
                items: g_menu.parseItems([
                    ['edit', '编辑', 'pencil'], ['new', '新建目录', 'folder'], ['newSub', '新建子目录', 'folder-plus'], ['clone', '克隆', 'folders'], ['delete', '删除', 'trash text-danger'], 'divider',
                    ['color', g_tabler.build_colorSelect({ name: _type + '_color', props: 'style="max-width: 150px;"' })]
                ], _type)
            })

            g_menu.registerMenu({
                name: 'category_' + _type,
                selector: `[data-collapse="${_type}"]`,
                dataKey: 'data-name',
                items: [{
                    icon: 'plus',
                    text: '新建',
                    action: _type + '_new'
                }, {
                    icon: 'trash',
                    text: '清空',
                    class: 'text-danger',
                    action: _type + '_clear'
                }]
            })

            g_drag.register(_type, {
                selector: `[data-list="${_type}"]`,
                target: `[data-list="${_type}"]`,
                parentDiv: '#accordion-group-' + _type,
                board: true,
                data: {},
                badge: {
                    tag: 'span',
                    props: { id: 'badge_darging_' + _type, class: 'badge bg-primary position-absolute' },
                },
                onDragStart(e) {
                    let { name, list } = e.target.dataset
                    Object.assign(this.data, {
                        name,
                        type: list,
                    })
                },
                // TODO 支持由其他组件向该inst注册拖放协议（item的dragstart向datatransfer传输参数，contianer的dropover决定是否接受参数传递到drop
                onUpdateTarget({ currentTarget, originalEvent: e }) { // 接受拖拽事件，有可能是文件
                    let tip = ''
                    let { type } = this.data
                    let { action, list, name } = currentTarget.dataset
                    let to = this.data.to = e.ctrlKey ? self.folder_getParent(name) : name
                    if (action.startsWith('category_')) {
                        if (action == 'category_' + type && list == type) {
                            tip = `移动到 【${to == 0 ? '顶级目录' : self.folder_getValue(name, 'title')}】 `
                        }
                    }
                    return { tip, accept: true }
                },
                onDrop(e) {
                    let { type, name, to } = this.data
                    let { target, dataTransfer } = e
                    g_drag.hide(type)

                    let files = target.files || dataTransfer.files
                    if (files.length) { // 文件接收
                        let paths = Object.values(files).map(v => v.path)
                        if (arr_equal(g_cache.dragingFile, paths)) { // 从软件拖拽的文件
                            let cnt = 0
                            Promise.all(g_cache.dragingMD5s.map(async md5 => {
                                let item = await g_data.data_getData(md5)
                                let ids = e.shiftKey ? await self.getItemFolder(item) : []
                                if (!ids.includes(to)) {
                                    self.setItemFolder(item.id, [...ids, to])
                                    cnt++
                                }
                            })).then(() => cnt && toast('成功设置 ' + cnt + ' 个文件的目录'))
                        } else {
                            g_data.file_revice(paths.map(file => {
                                return {
                                    file,
                                    meta: { folders_ids: [to] }
                                }
                            })).then(({ added }) => toast('成功添加' + added.length + '个文件！', 'success'))
                        }
                        return
                    }
                    if (e.target.dataset.list == type && to != name) {
                        if (!isEmpty(name)) { // 目录之间的层级移动
                            return self.folder_setValue(name, 'parent', to) // 设置父目录
                        }
                    }
                }
            })
        },

        showPrompt(callback, dom) {
            var obj
            let id = _type + '_list'
            let dropdown = new _DropDown(id, {
                width: '350px',
                html: `<div id="${id}" class="p-2"></div>`,
                onShow: async () => {
                    let list = await Promise.all(g_detail.selected_keys.map(async md5 => {
                        let fid = await g_data.data_getID(md5)
                        return this.getItemFolder(fid)
                    }))
                    obj = this.buildSelector(id, {
                        selected: Array.from(new Set(list.flat())),
                        container: '#' + id,
                        autoFocus: true,
                    })
                    obj.show()
                },
                onHide: () => callback(obj)
            })
            if(dom) return dropdown.show(dom, 'start-top')
            g_dropdown.quickShow(id)
        },

        buildBadge({folder, title}){
            title ??= this.folder_getValue(folder, 'title')
            return `
                <a href='#' class="badge badge-pill d-inline-flex m-1" data-action="showFolder_${_type}" data-folder="${folder}">
                    <i class="ti ti-${_icon} me-1"></i>
                    <span>${title}</span>
                </a>
            `
        },

        buildSelector(id, opts) {
            if (!opts.sorts) opts.sorts = {}
            let sorts = opts.sorts
            if (sorts[_type + '_py'] == undefined) sorts[_type + '_py'] = { title: '拼音', icon: 'inbox' }
            if (sorts[_type + '_group'] == undefined) sorts[_type + '_group'] = { title: '群组', icon: 'folder' }
            return g_groupList.selector_build(id, Object.assign({
                defaultList: _type + '_py',
                onSelectedList: name => this.folder_sort(name),
                getName: fid => this.folder_getValue(fid, 'title', ''),
            }, opts))
        },

        async showFolder(name) {
            let h = ''
            let datas = Object.entries(this.folder_getChildren(name, true)).map(function ([k, v]) {
                return {
                    html: g_category.item_html(k, _type, v, 'category_' + _type),
                    group: name
                }
            })
            let par = getEle({ action: 'category_' + _type, list: _type, name }).parents('.collapse')
            if (datas.length) { // 有子目录
                let id = `category_${_type}_${name}`
                let div = $("#accordion-" + id)
                let remove = div.length > 0
                par.toggleClass('opened', !remove)

                if (remove) return div.remove(); // 隐藏
                let accordion = g_tabler.build_accordion({
                    id, datas,
                    default: true,
                    parent: false,
                    header: '<span class="badge bg-primary">{i}个目录</span>',
                    onOpen: () => { },
                    collapse_start: `<div class="list-group list-group-flush">`,
                    collapse_end: `</div>`,
                })
                accordion.find(`[data-list="${_type}"]`).prop('draggable', true)

                par.find('.row').append(accordion)
                if (await this.folder_queryItems(name, true) == 0) return // 没有项目则不打开窗口
            }
            // 新建标签页
            let tab = _g_rule.getTabParams(_type, { ids: [name], type: 'sqlite' })
            tab.value = name

            let item = self.get(name)
            tab.icon = item.icon || _icon
            tab.icon_color = item.icon_color
            tab.title = item.title
            g_datalist.tab_new(tab)
        },
    } : {}));

    _g_plugin.registerEvent('db_afterInsert', ({ opts, ret, method }) => {
        let fid = ret.lastInsertRowid
        let { table, data } = opts
        if (method == 'insert' && table == 'files') {
            let meta = data.meta

            var ids
            if ((ids = meta[_type + '_ids'])) {
                self.setItemFolder(fid, ids)
            } else
                if ((ids = meta[_type])) {
                    self.setItemFolder(fid, self.folder_toIds(ids))
                }
        } else
            if (table == _type + '_meta') {
                typeof (g_datalist) != 'undefined' && g_datalist.updateTabItems()
            }
    })


    _g_data.table_indexs[_type] = ['id', 'title', 'icon', 'desc', 'meta', 'parent', 'ctime']
    _g_data.table_indexs[_table] = ['fid', 'ids']

    _g_detail.inst[_type] = { set: self.setItemFolder, get: self.getItemFolder, remove: self.removeItemFolder, type: 'deepFolder', self }
    return self

}

if (typeof (window) == 'undefined') module.exports = db_deepFolder
