const DB_TYPE_DEFAULT = 1
const DB_TYPE_IMPORT = 2
const DB_TYPE_METADATA = 3

var g_db = {
    setConfig(k, v) {
        return setConfig(this.current + '_' + k, v)
    },
    getConfig(k, defV) {
        return getConfig(this.current + '_' + k, defV)
    },
    db_findVal(key, val) {
        let ret
        this.entries((k, v) => {
            if (v[key] == val) {
                ret = k
                return false
            }
        })
        return ret
    },
    db_readJSON(name, def, db) {
        let path = this.db_getVal(db || this.current, 'path')
        let file = path + '/' + name + '.json'
        let r
        try {
            if (nodejs.files.exists(file)) {
                r = JSON.parse(nodejs.files.read(file))
            }
        } catch (e) { }
        return r || def
    },
    db_saveJSON(name, data, db) {
        let path = this.db_getVal(db || this.current, 'path')
        let file = path + '/' + name + '.json'
        nodejs.files.write(file, JSON.stringify(data))
    },
    init() {
        const self = this
        self.list = local_readJson('dbs', {})
        g_action.registerAction({
            db_clear: dom => {
                confirm('你确定要清空当前数据库里的所有数据库嘛?', { type: 'danger' }).then(() => {
                    Promise.all(
                        Object.keys(g_data.table_indexs).filter(k => ![].includes(k))
                            .map(k => g_data.run(`DELETE FROM ` + k))
                    ).then(() => location.reload())
                })
            },
            db_menu: dom => g_dropdown.show('db_menu', dom),
            db_new: () => self.db_edit(),
            db_edit: dom => self.db_edit($(dom).parents('[data-db]').data('db')),
            db_open: () => self.db_open(),
            db_manager: () => self.db_manager(),
            db_location: () => ipc_send('openFolder', g_db.db.name),
            db_switch: (dom, action) => self.db_switch(action[1] || $(dom).parents('[data-db]').data('db'))
        })

        g_dropdown.register('db_menu', {
            position: 'end-top',
            offsetLeft: 5,
            autoClose: 'true',
            parent: ['menu', 'db'],
            list(dom) {
                let action = g_dropdown.getLastState('data-action')
                let list = action !== 'db_menu' ? {
                    new: {
                        title: '新建资源库',
                        action: 'db_new',
                    },
                    open: {
                        title: '打开资源库',
                        action: 'db_open',
                    },
                    manager: {
                        title: '管理资源库',
                        action: 'db_manager',
                    },
                    location: {
                        title: '打开资源库位置',
                        action: 'db_location',
                    },
                    drive: {
                        type: 'divider'
                    }
                } : {}
                return Object.assign(Object.assign(list, self.db_menu || {}), self.toDropdown()) // 素材库列表
            },
        })
    },

    toDropdown(action = 'db_switch') {
        let list = {}
        this.entries((name, item) => {
            list[name] = {
                title: item.title,
                class: name == g_db.current ? 'active' : '',
                icon: item.icon || 'box',
                action: action + ',' + name,
                attr: 'tabindex="0"'
            }
        })
        return list
    },

    entries(callback) {
        for (let [name, item] of Object.entries(this.list)) {
            if (callback(name, item) === false) return
        }
    },

    db_getPath() {

    },

    db_getCurrentVal(k) {
        return this.db_getVal(this.current, k)
    },

    db_getVal(id, k, def) {
        return (this.db_get(id) || {})[k] || def
    },

    async db_getTables() {
        return (await g_data.all(`SELECT * FROM sqlite_master WHERE type='table'`)).map(table => table.name).filter(table => !['sqlite_sequence'].includes(talbe))
    },

    // 素材库列表窗口
    db_manager() {
        let h = ''
        this.entries((k, v) => {
            h += `
                <div class="list-group-item" data-db="${k}">
                  <div class="row align-items-center">
                    <div class="col-auto"><span class="badge bg-${k == this.current ? 'success' : 'secondary'}"></span></div>
                    <div class="col-auto">
                     <span class="avatar"><i class="fs-1 ti ti-${v.icon || 'box'}"></i></span>
                    </div>
                    <div class="col text-truncate">
                      <a href="#" class="text-reset d-block" data-action="db_switch">${v.title}</a>
                      <div class="d-block text-muted text-truncate mt-n1">${v.desc || ''}</div>
                    </div>
                    <div class="col-auto">
                      <a href="#" class="list-group-item-actions" data-action="db_edit">
                        <i class="ti ti-dots"></i>
                      </a>
                    </div>
                  </div>
                </div>
            `
        })
        alert(h ? `
            <div class="card">
              <div class="list-group list-group-flush list-group-hoverable">${h}</div>
            </div>
            ` : '<h4 class="text-center">还没有任何资源库...</h4>', {
            title: '资源库列表',
            btn_ok: '新建',
            id: 'db_manager',
            scrollable: true,
        }).then(() => this.db_edit())
    },

    // 获取DB配置
    async db_getConfig(key, def) {
        return (await g_data.get('SELECT value FROM config WHERE key=?', key) || {}).value || def
    },

    // 写入DB配置
    async db_setConfig(key, value) {
        return g_data.data_set2({ table: 'config', key: 'key', value: key, data: { key, value } })
    },

    // 打开素材库
    db_open() {
        openFileDiaglog({
            title: '打开数据库',
            properties: ['openDirectory'],
        }, ([path]) => !isEmpty(path) && this.db_import(path))
    },

    // 导入素材库
    db_import(path, opts) {
        try {
            let json = JSON.parse(nodejs.files.read(path + '/db.json'))
            // 如果是云导入则把目录改成选中目录
            // TODO 怎么判断是云导入？
            // 因为本地素材库可能素材的位置会在别处
            json.path = path
            this.db_edit(json)
        } catch (e) {
            this.db_edit({ path: path })
        }
    },

    db_get(name) {
        return this.list[name]
    },
    db_remove(name, save = true) {
        delete this.list[name]
        save && this.save()
        if (name == this.current) setTimeout(() => location.reload(), 200)
    },
    set(name, vals, save = true) {
        this.list[name] = vals
        save && this.save()
        nodejs.files.write(vals.path + '/db.json', JSON.stringify(vals))
    },
    save() {
        local_saveJson('dbs', this.list)
    },
    db_dbs() {
        return Object.keys(this.list)
    },
    // 切换指定数据库
    db_switch(name) {
        g_modal.remove('db_manager')
        let opts = this.db_get(name)
        if (!opts) return this[this.db_dbs().length ? 'db_manager' : 'db_edit']()
        
        opts.path = opts.path.replaceAll('\\', '/')
        g_plugin.callEvent('db_switch', { name, opts: copyObj(opts) }).then(({ name, opts }) => {
            console.log('加载数据库 ' + name)
            setConfig('db', name)
            if (!isEmpty(this.current)) return setTimeout(() => location.reload(), 50) // 切换数据库

            this.current = name
            this.opts = opts
            g_border.setTitle(`
                <i class="ti ti-${opts.icon} me-1 fs-4"></i>${opts.title}
            `)

            if (!opts.file) opts.file = opts.path + '/items.db'
            let db = g_data.db = this.db = this.db_read({
                file: opts.file,
                type: DB_TYPE_DEFAULT
            })
            if (!db) {
                return confirm(`数据库${opts.title}加载失败!`, {
                    title: '加载数据库失败!',
                    type: 'danger',
                    btn_ok: '再次加载',
                    btn_cancel: '选择其他数据库'
                })
            }
            g_plugin.callEvent('db_read', { name, opts, db })
        }).catch(err => console.error(err))
    },
    // 创建新的数据库
    db_edit(key) {
        let d
        if (typeof (key) == 'object') {
            d = copyObj(key)
            key = new Date().getTime()
        } else {
            d = this.db_get(key)
        }

        d = Object.assign({
            title: '',
            path: '',
            icon: 'box',
            syncFolders: {},
        }, d)

        let title = (key ? '编辑' : '创建') + '数据库'
        g_form.confirm1({
            title, id: 'db_edit',
            elements: {
                guid: {
                    title: 'guid',
                    required: true,
                    value: d.guid || guid(),
                    class: 'hide',
                },
                title: {
                    title: '名称',
                    required: true,
                    class: 'col-6',
                    value: d.title || '',
                },
                icon: {
                    title: '图标',
                    type: 'icon',
                    class: 'col-6',
                    value: d.icon,
                    placeholder: '输入网址使用网络图片',
                },
                path: {
                    title: '储存目录',
                    type: 'file_chooser',
                    required: true,
                    opts: {
                        title: '选择数据库',
                        defaultPath: getConfig('db_lastPath', ''),
                        properties: ['openDirectory'],
                    },
                    value: d.path,
                    help: '请选择空目录，不会自动创建目录',
                    placeholder: '支持网络目录',
                },
                importType: {
                    title: '导入方式',
                    tip: '后面可更改',
                    type: 'select',
                    list: {copy: '拷贝', link: '链接', move: '移动'},
                    value: d.importType || 'copy',
                },
            },
            onBtnClick: btn => {
                switch (btn.id) {
                    case 'btn_delete':
                        // todo 显示数据库素材数量以及是否删除数据库文件夹
                        return confirm('确定删除数据库【' + d.title + '】吗?', {
                            title: '删除数据库',
                            type: 'danger'
                        }).then(() => {
                            this.db_remove(key)
                            this.db_manager() // 刷新显示列表
                        })
                    case 'btn_folder':
                        return d.path && ipc_send('openFolder', d.path)
                    case 'btn_open':
                        return this.db_manager()
                }
            },
            callback: ({ vals }) => {
                if (nodejs.files.exists(nodejs.path.join(vals.path, 'items.db')) && !key){
                    return toast('请选择空的目录!', 'danger')
                }
                
                setConfig('db_lastPath', nodejs.path.dirname(vals.path))
                key ??= new Date().getTime()
                this.set(key, vals)
                toast(title + '成功', 'success')
                // g_modal.remove('db_edit')
                if (isEmpty(this.current)){
                    this.db_switch(key)
                }else{
                    this.db_manager()
                }
            }
        }, {
            buttons: [{
                id: 'ok',
                text: '保存',
                class: 'btn-primary',
            }, {
                id: 'delete',
                text: '删除',
                class: 'btn-danger ' + (isEmpty(key) ? 'hide' : ''),
            }, {
                id: 'open',
                text: '打开',
                class: 'btn-warning ' + (!isEmpty(key) ? 'hide' : ''),
            }, {
                id: 'folder',
                text: '定位',
                class: 'btn-info ' + (isEmpty(key) ? 'hide' : ''),
            }],
        })
    },
    isFirst: true,
    dbs: {},
    // 加载数据库
    db_read(opts) {
        opts = Object.assign({
            table: this.table_sqlite,
            config: this.getOption ? this.getOption(opts) : {
                readonly: false,
                type: DB_TYPE_DEFAULT
            }
        }, opts)
        opts.config.readonly = false

        let { file, config } = opts
        let exists = nodejs.files.exists(file);
        if (!exists && config.readonly) return false;

        
        // db_class: , 
        //  db_class: nodejs.require('better-sqlite3'),
        let db = new Database(file, config)
        if (db) {
            // db.pragma('journal_mode = WAL');
            // db.unsafeMode(true);
            this.dbs[file] = db

            // TODO 创建一个DB_Manager,只初始化一个对象，管理db的加载与睡眠
            // 这里为了兼容server db模式
            db._prepare = db.prepare
            db.prepare = function (query, dbFile) {
                // if(true || dbFile == 'D:/billfish_librarys/test/billfish.db') console.log(query, dbFile)
                let inst
                if (!isEmpty(dbFile)) {
                    inst = g_db.dbs[dbFile]
                    if (!inst) {
                        // 动态加载db
                        inst = g_db.db_read({ file: dbFile })
                    }
                } else {
                    inst = this
                }
                return inst._prepare(query)
            }
            g_plugin.callEvent('db_connected', {
                db,file,
                opts: config,
                first: this.isFirst
            })
            this.isFirst = false
            db.exec(opts.table);
        }
        return db;
    },

    db_unload(db) {
        delete this.dbs[db]
    },

    // 根据md5获取储存路径
    getSaveTo(md5, path) {
        path ??= this.opts.path
        path += '/files/'
        if (!isEmpty(md5)) path += `${md5.substr(0, 2)}/${md5.substr(2, 2)}/${md5}/`

        return isWeb ? g_client.api+'/res?file='+path : path
    },
    

}

g_db.init()