class CacheManager {
    constructor(opts = {}) {
      this.opts = opts
      this.cache = new Map();
    }
  
    set(key, value) {
      this.cache.set(key, value);
    }
  
    get(key) {
      return this.cache.get(key);
    }
  
    update(key, val){
      val = {...(this.get(key) || {}), ...val}
      this.set(key, val)
      return val
    }
  
    delete(key) {
      this.cache.delete(key);
    }
  
    clear() {
      this.cache.clear();
    }
  
    has(key) {
      return this.cache.has(key);
    }
  }
(() => {
    const build = (opts) => {
        var _g_plugin = typeof (g_plugin) == 'undefined' ? opts.g_plugin : g_plugin
        return {
            useCache: true,
            // await g_data.all(`SELECT * FROM exif_meta WHERE json_extract(data, '$.type') = 'video';`)
            cache: new CacheManager(),
            updateCache(k, v) {
                this.cache.set(k, v)
                // g_datalist.tab_item_update(k, v)
            },
            removeCache(k) {
                this.cache.delete(k)
            },
            getCache(k) {
                let ret = this.cache.get(k)
                return ret ? {...ret} : undefined
            },
            table_indexs: {
                // 表格字段名，在插入数据的时候只提取以下数据，避免崩溃
                files: ['id', 'title', 'size', 'date', 'birthtime', 'link', 'md5'],
                config: ['key', 'value'],
                trash: ['id', 'title', 'size', 'date', 'birthtime', 'link', 'md5', 'meta', 'last'],
            },

            async getMd5List(table = 'files') {
                return (await this.all('SELECT md5 FROM ' + table)).map(({ md5 }) => md5)
            },

            // 取所有视频数
            async getLengths(query, table = 'files') {
                let r = await this.get(`SELECT COUNT(*) FROM ${table} ${query}`)
                return r ? r['COUNT(*)'] : 0;
            },
            // md5是否存在
            async data_exists(md5) {
                let i = await this.getLengths(`WHERE md5='${md5}'`)
                return i > 0
            },
            // 删除
            data_remove(md5, table = 'files') {
                this.removeCache(md5)
                return this.run(`DELETE FROM ${table} WHERE md5=?`, md5);
            },
            // 取结果
            get(query, ...args) {
                return this.db.prepare(query).get(args);
            },

            async get1(query, dbFile, args) {
                let data = await this.db.prepare(query, dbFile).get(args)
                return _g_plugin.callEvent('db_afterGetData', data)
            },

            // 取结果
            // TODO 没连接db之前禁止这些操作
            async all(query, ...args) {
                return this.db ? await this.db.prepare(query).all(args) : [];
            },

            // 执行操作
            async run(query, ...args) {
                return this.db.prepare(query).run(...args);
            },

            async run1(query, dbFile, args) {
                return this.db.prepare(query, dbFile).run(args)
            },

            // 指定md5保存数据
            data_set(md5, data, table = 'files') {
                return this.data_set2({ table, key: 'md5', value: md5, data })
            },

            // 设置数据
            data_set2(opts) {
                opts.meta ??= {}
                return new Promise(reslove => {
                    _g_plugin.callEvent('db_beforeInsert', opts).then(async opts => {
                        let data = opts.data
                        // this.updateCache(data.md5, data) // 更新缓存
                        let ret = await this.data_update(opts)
                        if (ret.changes === 0) {
                            ret = await this.data_insert1(opts)
                        }
                        reslove(ret)
                    })
                })
            },

            // 删除数据
            data_remove2(opts) {
                return new Promise(reslove => {
                    _g_plugin.callEvent('db_beforeDelete', opts).then(async opts => {
                        reslove(this.run(`DELETE FROM ${opts.table} WHERE ${opts.key} = ?`, opts.value).finally(() => {
                            typeof(g_rule) != 'undefined' && g_rule.update()
                        }))
                    })
                })
            },

            // 更新数据
            data_update(opts) {
                let { data, dbFile, table, key, value, meta } = opts
                return new Promise(reslove => {
                    this.run1(`UPDATE ${table} SET ${this.format_keys(data, key, table)} WHERE ${key}=?`, dbFile, this.format_values(data, key, table).concat(value)).then(ret => {
                        ret.changes > 0 && _g_plugin.callEvent('db_afterInsert', { opts, ret, method: 'update', meta })
                        typeof(g_rule) != 'undefined' && g_rule.update()
                        reslove(ret)
                    })
                })
            },

            data_getMd5(id) {
                return this.data_getData
            },

            // 根据md5取id
            async data_getID(md5) {
                if (typeof (md5) == 'string' && md5.length == 32) {
                    return (await this.data_get(md5) || {}).id
                }
                return md5
            },

            // 插入数据
            data_insert1(opts) {
                let { data, dbFile, table, meta } = opts
                let indexs = this.table_getIndexs(table)
                let keys = Object.keys(data).filter(k => indexs.includes(k))
                return new Promise(reslove => {
                    this.run1(`INSERT INTO ${table} (${keys.join(',')}) VALUES (${keys.map(_k => '@' + _k).join(',')})`, dbFile, data).then(ret => {
                        ret.changes > 0 && opts.broadcast !== false && _g_plugin.callEvent('db_afterInsert', { opts, ret, meta, method: 'insert' })
                        reslove(ret)
                    })
                })
            },


            format_values(data, primaryKey, indexs) {
                indexs = this.table_getIndexs(indexs)

                let vals = []
                for (let [k, v] of Object.entries(data)) {
                    if (k != primaryKey && indexs.includes(k)) {
                        vals.push(v)
                    }
                }
                return vals
            },

            table_getIndexs(key) {
                return Array.isArray(key) ? key : this.table_indexs[key] || []
            },

            // 拼接sqlite参数
            format_keys(data, primaryKey, indexs) {
                indexs = this.table_getIndexs(indexs)

                let join = ' = ?'
                return Object.keys(data).filter(k => indexs.includes(k) && k != primaryKey).join(join + ',') + join;
            },

            // 适用于改一次值
            async date_setVal(d, k, v) {
                d = await this.data_getData(d)
                setObjVal(d, k, v)
                return this.data_setData(d)
            },

            async data_getVal(d, k, defV) {
                d = await this.data_getData(d)
                return getObjVal(d, k, defV)
            },

            // 保证设置数据
            async data_set1(md5, data) {
                return await this.data_set(md5, data).changes || await this.data_add(data).changes
            },

            // 保存数据
            data_setData(data) {
                if (data.md5) {
                    return this.data_set(data.md5, data)
                }
            },

            async data_getData(md5, table) {
                return typeof (md5) == 'object' ? md5 : await this.data_get(md5, table)
            },

            async data_getFullData(...args) {
                let data = await this.data_getData.apply(this, args)
                return Object.assign(data, await g_item.item_getVal(['file', 'cover'], data))
            },

            data_getData1(md5, callback) {
                if (typeof (md5) == 'object') return callback(md5)
                this.data_get(md5).then(data => callback(data))
            },

            // 数组增减多个
            async data_arr_changes(data, key, added, removed) {
                data = await this.data_getData(data)
                added.forEach(add => {
                    if (!data[key].includes(add)) data[key].push(add)
                })
                removed.forEach(remove => {
                    let i = data[key].indexOf(remove)
                    if (i != -1) data[key].splice(i, 1)
                })
                this.data_setData(data)
            },

            // 数组增减单个
            async data_arr_toggle(data, key, folder, add = true) {
                data = await this.data_getData(data)
                let i = data[key].indexOf(folder)
                let exists = i == -1
                if (add == undefined) add = !exists
                if (add) {
                    data[key].push(folder)
                } else {
                    data[key].splice(i, 1)
                }
                await this.data_setData(data)
                // TODO 更新当前过滤 ()
                return add
            },


            data_getDataByID(id, table = 'files') {
                return this.data_get1({ table, key: 'id', value: id })
            },

            // 获取视频数据
            async data_get(md5, table = 'files') {
                debug('get', md5, table)
                let ret = this.getCache(md5)
                if (ret) return ret // 缓存

                ret = this.data_get1({ table, key: 'md5', value: md5 })
                ret.then(data => {
                    if (data) {
                        data.table = table
                        if (table == 'trash') data.meta = JSON.parse(data.meta) // 垃圾箱物品属性
                        // this.updateCache(md5, data)
                    }
                })
                return ret
            },

            async data_get1(opts) {
                return _g_plugin.callEvent('db_beforeGetData', opts).then(async opts => {
                    let { dbFile, table, key, value } = opts
                    return this.get1(`select * from ${table} where ${key}=?`, dbFile, value);
                })
            },

            // 对象格式化至可以插入SQL
            data_format(data) {
                let d = copyObj(data)
                delete d.id // id会跟sql主键起冲突

                d.title = safePath(d.title)
                if (d.tags != undefined) d.tags = this.arr_join(d.tags)
                if (d.folders != undefined) d.folders = this.arr_join(d.folders)
                if (d.json != undefined) d.json = JSON.stringify(d.json)
                return d
            },

            getMetaInfo(data, table, cache = true) {
                if (!data) return
                // // meta 缓存
                // if (cache && data.meta && data.meta[table]) {
                //     return data.meta[table]
                // }

                table += '_meta'
                let id = typeof (data) == 'object' ? data.id : data
                if (id != undefined && this.table_indexs[table]) return this.get(`SELECT * FROM ${table} WHERE fid=${id}`)
            },

            arr_join(arr, join = '|') {
                let s = arr.sort().join(join)
                return s == '' ? s : join + s + join
            },

            arr_split(str, split = '|') {
                return str.split(split).filter(s => s != '')
            }
        }
    }

    if (typeof (window) != 'undefined') {
        window.g_data = build()
    } else {
        module.exports = build
    }
})()

