// TODO : 把pageheader，pagefooter 隐藏，但能获取它的offset属性
var _toggleing
class Container {
    hide_pages = {}
    page_display = {}
    constructor(opts) {
        opts = this.opts = Object.assign({
            name: 'container_' + guid(), // 名称
            itemClass: '', // 子物品附加class
            items: [],  // 子物品
            page_info: {}, // 翻页信息
            onePage: true, // 总是展示单页面
            scrollToNextPage: 1000, // 滚动到上下页面距离
            onInit: () => { }, // 初始化事件
            onPageChanged: ({ page, to_page }) => { }, // 页面改变事件
        }, opts)

        this.page_info = Object.assign({
            page: 0,
            pagePre: 50,
        }, opts.page_info)
        g_container.list[opts.name] = this

        //  let fill = 3000
        // let items = this.opts.items
        // let len = items.length
        // for (let i = 0; i < fill - len; i++) this.opts.items.push(items[randNum(0, len - 1)])

        this.init()
        this.show()
    }

    // 初始化
    init() {
        let container = this.getContainer()
        this.callEvent('onInit')
    }

    // 触发事件
    callEvent(eventName, ...args) {
        let cb = this.opts[eventName]
        if (typeof (cb) == 'function') return cb.apply(this, args)
    }

    // 获取当前展示的所有页面
    getShowingPages(sibling = 1) {
        let ret = []
        let { scrollTop, offsetHeight } = this.getContainer()[0]
        let pages = this.getPagesPosition()
        Object.entries(pages).forEach(([page, { top, bottom }]) => {
            if (scrollTop + offsetHeight >= top && scrollTop <= bottom) {
                ret.push(parseInt(page))
            }
        })
        if (sibling > 0) {
            let start = ret[0]
            if (start > 0) ret.unshift(start - 1)
            let end = ret.at(-1) + 1
            if (pages[end]) ret.push(end)
        }
        return ret
    }

    // 获取所有页面的top和bottom
    getPagesPosition() {
        let ret = {}
        this.getPageHeader().each((i, el) => {
            let page = el.dataset.page
            let footer = this.getPageFooter(page)[0]
            ret[page] = { top: el.offsetTop, bottom: footer.offsetTop + footer.offsetHeight }
        })
        return ret
    }

    // 切换需要隐藏和显示的页面
    togglePageDisplay(page, hide) {
        let elements
        let header = this.getPageHeader(page)
        if (hide) {
            elements = this.getPageItemElements(page)
            this.hide_pages[page] = elements
            if (elements.length) {
                // 隐藏页面内容并用等高的div占位填充滚动条
                let footer = this.getPageFooter(page)
                let height = footer[0].offsetTop - (header[0].offsetTop + header[0].offsetHeight)
                elements.remove()
                $(`<div class="d-block container-test container-item-full position-relative" style="height: ${height}px;">
                    <div class="card placeholder-glow position-absolute bottom-10 w-full">
                        <div class="ratio ratio-21x9 card-img-top placeholder"></div>
                        <div class="card-body">
                            <div class="placeholder col-9 mb-3"></div>
                            <div class="placeholder placeholder-xs col-10"></div>
                            <div class="placeholder placeholder-xs col-11"></div>
                            <div class="mt-3">
                                <a href="#" tabindex="-1" class="btn btn-primary disabled placeholder col-4" aria-hidden="true"></a>
                            </div>
                        </div>
                    </div>
                </div>`).insertAfter(header)
            }
        } else
            if ((elements = this.hide_pages[page])) {
                // 还原
                header.next('.container-test').remove()
                elements.length && elements.insertAfter(header)
                // 滚动到底部
                delete this.hide_pages[page]
            }
    }

    // 排序
    sort(type) {
        switch (type) {
            case 'random':
                return this.opts.items = arrayShuffle(this.opts.items)
        }
    }

    // 获取加载过的所有页面
    getLoadedPages() {
        return getElementsValues(this.getPageHeader(), el => parseInt(el.dataset.page)).sort((a, b) => a - b)
    }

    scrollB = 0
    scrollT = 0
    clearScrollHistory() {
        this.scrollB = 0
        this.scrollT = 0
    }
    // 初始化内容
    initContent() {
        let last = []
        let lastGo
        let { onePage, scrollToNextPage } = this.opts
        let container = this.getContainer()
        let content = this.getContent()
            .on('mousewheel', ({ originalEvent: e }) => {
                if (this.isLoading) return clearEventBubble(e)

                let { ctrlKey, deltaY } = e
                if (ctrlKey) {
                    let val
                    let { itemWidth, onSetWidth, maxWidth, minWidth, maxHeight, minHeight } = this.opts
                    if (!isNaN(maxWidth)) {
                        val = Math.min(maxWidth, Math.max(minWidth, itemWidth + (deltaY < 0 ? 20 : -20)))
                    } else
                        if (!isNaN(maxHeight)) {
                            val = Math.min(maxHeight, Math.max(minHeight, itemWidth + (deltaY < 0 ? 20 : -20)))
                        } else return
                    if (onSetWidth.call(this, val) !== false) {
                        this.opts.itemWidth = val
                    }
                    return
                }

                // 滚动方向改变
                let goDown = deltaY > 0
                if (goDown != lastGo) {
                    lastGo = goDown
                    if (scrollToNextPage) {
                        this.clearScrollHistory()
                        $('#container_progress').remove()
                    }
                    return
                }

                let pages
                let { scrollHeight, scrollTop, offsetHeight } = container[0]
                let getPages = () => pages ??= this.getLoadedPages()
                let firstPage = getPages().at(0)
                let lastPage = getPages().at(-1)
                const checkScroll = isTop => {
                    if (!onePage || scrollToNextPage <= 0) return

                    let page
                    if (isTop) {
                        if ((page = firstPage) == 0) return
                    } else
                        if ((page = lastPage) == this.getMaxPage() - 1) return

                    let dist = Math.abs(deltaY)
                    let i = goDown ? this.scrollB += dist : this.scrollT += dist
                    let progress = parseInt(i / scrollToNextPage * 100)
                    if (progress >= 100) this[isTop ? 'prevPage' : 'nextPage']()

                    insertEl({
                        tag: 'div', text: '', props: {
                            id: 'container_progress',
                            class: `container-item-full w-full`
                        }
                    }, { target: content, method: isTop ? 'prependTo' : 'appendTo' })
                        .html(`
                <div class="progressbg cursor-pointer ${isTop ? 'mb-2' : 'mt-2'}" data-action="container,toPage,${isTop ? page - 1 : page + 1}">
                    <div class="progress progressbg-progress">
                        <div class="progress-bar bg-primary-lt" style="width: ${progress}%"></div>
                    </div>
                    <div class="progressbg-text text-center"><b>继续滚动或者点击这里前往${isTop ? '上一页' : '下一页'}</b></div>
                    <div class="progressbg-value">${progress}%</div>
                </div>
                `)
                    // <button data-action="container,toPage,${isTop ? page - 1 : page + 1 }" class="btn btn-primary w-full p-1">${isTop ? '上一页' : '下一页'}</button>
                    return true
                }
                if (deltaY < 0 && scrollTop == 0) {
                    if (checkScroll(true)) return
                    this.page_info.page = firstPage
                    this.prevPage()
                } else
                    if (scrollHeight - (scrollTop + offsetHeight) <= 50) {
                        if (checkScroll(false)) return
                        this.page_info.page = lastPage
                        this.nextPage()
                    }
            })
        if (!onePage) container.on('scroll', ev => {
            !_toggleing && g_pp.setTimeout('container-scroll', () => {
                let newst = this.getShowingPages()
                let { added, removed } = arr_compare(last, newst)
                if (added.length || removed.length) {
                    _toggleing = true

                    let height = content[0].scrollHeight
                    content.css('height', height + 'px') // 设置高度防止删减内容时滚动条变化
                    removed.forEach(page => this.togglePageDisplay(page, true))
                    added.forEach(page => this.togglePageDisplay(page, false))
                    content.css('height', 'unset')
                }
                last = newst
                _toggleing = false
            }, 50)
        })

        this.loadPage({ to_page: 0 })
        // this.toItemIndex(300)
    }

    static getSelector({ type }) {
        let s = '[data-container]'
        if (!isEmpty(type)) s += `[data-type="${type}"]`
        return s
    }

    // 展示
    show() {
        this.toggle(true)
    }

    // 隐藏
    hide() {
        this.toggle(false)
    }

    // 切换选中
    toggle(show) {
        show ??= !show
        if (show && !this.content) this.initContent()
        this.getContainer().toggleClass('hide', !show)
    }

    // 上一页
    prevPage() {
        return this.offsetPage(-1, 'prependTo')
    }

    // 下一页
    nextPage() {
        return this.offsetPage(1, 'appendTo')
    }

    // 偏移到指定页面
    offsetPage(offset, insertMethod) {
        return this.loadPage({
            to_page: this.page_info.page + offset,
            insertMethod,
        })
    }

    // 获取所有数据
    method(method, args, cb) {
        return new Promise(async reslove => {
            let hook = this.opts[method]
            if (hook) {
                let ret = await hook.call(this, args)
                return reslove(ret !== false && cb ? cb.call(this, args) : ret)
            }
            cb && reslove(cb.call(this, args))
        })
    }

    getItem(index) {
        return typeof (index) == 'function' ? this.opts.items.find(index) : this.opts.items[index]
    }

    // 跳转到指定物品位置
    toItemIndex(index) {
        let { pagePre, page } = this.page_info
        let targetPage = parseInt(index / pagePre)
        if (!this.isPageLoaded(targetPage)) { // 页面还未加载
            return this.loadPage({ to_page: targetPage, cb: ret => ret && setTimeout(() => this.toItemIndex(index), 200) })
        }
        let el = this.getItemElement(index)
        if (el.length) {
            el[0].scrollIntoViewIfNeeded()
            return el
        }
    }

    // 获取元素
    getItemElement(index) {
        return getEle({ index }, '.container-item', this.getContent())
    }

    // 跳到指定页
    toPage(page) {
        let header = this.getPageHeader(page)
        header.length && header[0].scrollIntoViewIfNeeded()
    }

    // 获取指定页面内的所有子元素
    getPageItemElements(page) {
        let header = this.getPageHeader(page)
        return header.length ? header.nextUntil(':not(.container-item)') : {}
    }

    // 获取页面标头
    getPageHeader(page) {
        return getEle({ page }, '.container-pageheader', this.getContent())
    }

    // 获取页面页尾
    getPageFooter(page) {
        return getEle({ page }, '.container-pagefooter', this.getContent())
    }

    // 页面是否加载
    isPageLoaded(page) {
        return this.getPageHeader(page).length > 0
    }

    // 移除页面
    removePage(page) {

    }

    // 获取页面信息
    getPageInfo() {
        let { pagePre, page } = this.page_info
        return { pagePre, page, max: this.getMaxPage() }
    }

    // 获取最多页面
    getMaxPage() {
        return this.opts.maxPage ?? Math.ceil(this.opts.items.length / this.page_info.pagePre)
    }

    // 加载指定页
    async loadPage(opts) {
        this.clearScrollHistory()

        let { to_page, cb, insertMethod } = Object.assign({
            insertMethod: 'appendTo',
            cb: () => { }
        }, opts)
        if (this.isLoading) return cb()


        let { pagePre, page, max } = this.getPageInfo()
        to_page = this.page_info.page = Math.min(Math.max(to_page, 0), max > 0 ? max - 1 : max)
        if (this.isPageLoaded(to_page)) { // 页面已经加载过了
            this.toPage(to_page)
            return cb()
        }

        let data = this.opts.items
        if (data.length == 0) {
            if (this.method('onInitItems') === true) { // 成功初始化了物品列表，直接返回
                return cb()
            }
        }

        let start = to_page * pagePre
        let end = start + pagePre
        let args = { to_page, start, pagePre, data }
        this.method('before_getPage', args, () => { // 一些需要实时获取的网络请求
            end = Math.min(end, args.data.length) // 新数据放在data里
            return end - start > 0
        }).then(ok => {
            let container = this.getContainer()
            if (!ok) {
                this.noMore = true
                return cb()
            }

            let content = this.getContent()
            const insertEl = elements => $(elements)[insertMethod](content)
            if (Math.abs(to_page - page) != 1 && to_page > 0) { // 跨页

            }

            if (this.opts.onePage) { // 单页显示
                content.html('')
                container.scrollTop(0)
            }

            insertEl(`
            <div class="w-full p-2 text-center container-item-full container-loading">
                ${this.opts.loadingHTML ?? `<div class="spinner-grow text-blue" role="status"></div>`}
            </div>`) // 加载条

            this.isLoading = true
            this.method('getPage', { start, end, page: to_page }, () => this.opts.items.slice(start, end)).then(async list => {

                cb(list)
                this.isLoading = false
                this.callEvent('onPageChanged', { page, to_page, max })
                // 插入表示页面开头的header（可切换显示，主要起一个快速定位的功能）
                let last_page = to_page - 1
                let header = insertEl(`
                    <div class="container-item-full container-pageheader ${this.opts.hideHeader ? 'hide1' : ''}" data-page=${to_page}>
                        <div class="me-auto">
                            <h4 class="text-start">page: ${to_page}</h4>
                        </div>
                        ${to_page > 0 && !this.isPageLoaded(last_page) ? `
                        <div class="ms-auto">
                            <a href="#" data-action="container,loadPrevPage" class="btn btn-primary btn-sm">
                                加载上一页
                            </a>
                        </div>
                        ` : ''}
                    </div>
                `)
                let len = list.length
                if (len) {
                    let target = toVal(this.opts.insertTarget, header) ?? header
                    let elements = $()
                    for (let i = 0; i < len; i++) {
                        // TODO 用背景色代替loading.gif
                        elements.push((await this.parseItem(list[i], i + start))[0])
                    }
                    elements.insertAfter(target).find('.lazyload').lazyload()

                    !this.opts.onePage && setTimeout(() => (content.hasClass('scroll-x') ? hasScrollX : hasScrollY)(container[0]) === false && this.nextPage(), 500)
                    this.callEvent('onInsertedItems', { elements, list })
                }
                content.find('.container-loading').remove()

                let footer = insertEl(`
                    <div class="container-item-full container-pagefooter ${this.opts.hideFooter ? 'hide1' : ''}" data-page=${to_page}></div>
                `)
            })
        })


    }

    // 解析item
    async parseItem(item, index) {
        await this.opts.initItemData.call(this, item, index)

        var { width, height } = item
        width ||= 200
        height ||= 200
        let { getPreviewSize, itemWidth, maxWidth, maxHeight, onSetWidth, itemClass } = this.opts
        var newWidth, newHeight
        if (maxWidth) newWidth = itemWidth
        if (maxHeight) newHeight = itemWidth
        var { newWidth, newHeight } = (getPreviewSize ?? (() => adjustSize(width, height, { newWidth, newHeight }))).call(this, width, height)

        let html = await this.opts.parseItem.call(this, { item, newWidth, newHeight }, index)
        let div = $((this.opts.itemContainer || `<div class="{class}">{html}</div>`)
            .replace('{class}', 'container-item ' + itemClass)
            .replace('{html}', html))
            .attr({ 'data-index': index, 'data-width': width, 'data-height': height })
        onSetWidth.call(this, itemWidth, div) // 动态调整宽高
        return div
    }

    appendItems() {

    }

    countItems() {
        return this.opts.items.length
    }

    // 设置物品列表
    setItems(items, load) {
        this.getContent().html('')
        let old = this.opts.items.length
        this.opts.items = items
        this.noMore = false

        let len = items.length
        if (!len) this.method('onClearItems')
        load && this.loadPage({ to_page: 0 })
    }

    resetContainer(){
        this.removeContainer()
        this.getContainer()
    }

    removeContainer() {
        if (this.container) {
            this.container.remove()
            delete this.container
        }
        return this
    }

    // 获取内容
    getContainer() {
        if (!this.container) {
            let { name, html, target, type, containerHTML, style } = this.opts
            let preset = g_container.presets[type]
            this.container = $((containerHTML ?? `<div class="{class}" style="{style}" {props}>{html}</div>`)
                .replace('{class}', 'overflow-y _container')
                .replace('{style}', style || '') // TODO 去除底边高度
                .replace('{props}', `data-container="${name}" data-type="${type}"`)
                .replace('{html}', toVal(html || preset.html, this.opts))).appendTo(target)
        }
        return this.container
    }

    // 获取滚动div
    getContent() {
        return this.getContainer().find('.container-content')
    }

    update() {

    }

    destory(){
        this.removeContainer()
    }
}

var g_container = {
    list: {},
    presets: {},
    reigsterPreset(name, opts) {
        let { style } = this.presets[name] = opts
        if (!isEmpty(style)) {
            g_style.addStyle('container_type_' + name, call(opts, style, Container.getSelector({ type: name })))
        }
        return this
    },
    hasPreset(name) {
        return this.presets[name] != undefined
    },
    init() {
        let selector = '._container'
        g_style.addStyle('container', `
            ${selector} {}
            ${selector} > .overflow-container {
                overflow: hidden !important;
                padding-bottom: 70px;
            }
            ${selector} > .container-content {
            }
            .container-pageheader,.container-pagefooter {
                display: grid;
            }
            ${selector} > .container-item {
            }
        `)
        g_action.registerAction('container', (dom, action, ev) => {
            let name = getParentData(dom, 'container')
            let page = getParentData(dom, 'page')
            const toPage = (to_page, insertMethod) => g_container.method(name, 'loadPage', { to_page, insertMethod })
            switch (action[1]) {
                case 'toPage':
                    return toPage(action[2] * 1, 'prependTo')
                case 'loadPrevPage':
                    if (dom.classList.contains('btn')) dom.classList.add('btn-loading')
                    return toPage(page - 1, 'prependTo')
            }
        })
        Object.getOwnPropertyNames(Container.prototype).forEach(method => {
            if (!['constructor', 'method'].includes(method) && !method.startsWith('_')) {
                g_container[method] = (id, ...args) => this.method(id, method, ...args)
            }
        })
    },
    get(id) {
        return this.list[id]
    },
    remove(id){
        let container = this.get(id)
        if(container){
            container.destory()
            delete this.list[id]
        }
    },
    // 执行方法
    method(id, method, ...args) {
        let inst = this.get(id)
        if (inst) {
            return inst[method].apply(inst, args)
        }
    },
    // 是否存在
    exists(id) {
        return this.get(id) != undefined
    },
    build(id, opts) {
        opts.name = id
        return new Container(opts)
    },
    views: {},
    registerView(type, opts){
        this.views[type] = opts
        return this
    },
    runViewMethod({inst, type, method, args}){
        if(this.views[type]) return call(inst, this.views[type][method], args)
    },


}

g_container.init()
g_container
    .reigsterPreset('default', {
        html: `<div class="d-flex flex-wrap w-full overflow-container container-content justify-content-around"></div>`
    })
    .reigsterPreset('html', {
        html: opts => {
            return opts.html || ''
        }
    })
    .reigsterPreset('columns', {
        html: opts => `
        <div class="w-full overflow-container container-content mx-auto" style="
            column-gap: 10px;
            columns: 3;
        "></div>`,
        style: container => `
            .container-item-full {
                column-span: all;
            }
            ${container} .container-item {
                break-inside: avoid;
            }
            ${container} .container-item img {
                width: 100%;
                height: auto;
            }
        `,
    })
    .reigsterPreset('table', {
        html: opts => g_tabler.build_table({
            tableClass: 'w-full overflow-container table-responsive table-hover',
            headerClass: 'sticky-top',
            bodyClass: 'container-content',
            headers: opts.tableHeaders,
        }),
        style(container) {
            return `
                .container-item-full {
                    column-span: all;
                }
                ${container} .container-item {
                    break-inside: avoid;
                }
                ${container} .container-item img {
                    width: 100%;
                    height: auto;
                }
            `
        }
    })

g_container.
registerView('default', {
    onInit(opts){
        Object.assign(opts, {
            maxHeight: 300,
            minHeight: 50,
        })
    },
    parseItem: ({item, props, desc, r, newWidth, newHeight }) => {
        let { duration, title, cover, file} = item
        let leftTop = getExtName(file)
        return `
        <div ${props} >
            <div class="card bg-unset border-0 h-full position-relative justify-content-center container-sizer ">
            ${OR(r[2] && !isEmpty(leftTop) , `<span class="badge top-5 start-5 position-absolute w-fit" style="z-index: 2">${leftTop}</span>`)}
            
            <a class="position-relative card-preview text-center">
                <img style="width: ${newWidth}px;height: ${newHeight}px" data-src="${cover}" class="thumb lazyload container-sizer bg-${g_tabler.color_random()}-lt" data-lazyload="datalist_coverLoaded" {preview}>
                ${OR(r[1] && duration > 0, ` <span class="badge badge-primary position-absolute end-0 bottom-0">${getTime(duration)}</span>`)}
            </a>
            
            ${r[0] || r[3] ? `
                <div class="card-body p-2 text-center" style="height: 50px;">
                    ${OR(r[0], `<span class="text-wrap-2">${title}</span>`)}
                    ${OR(r[3], `<small class="text-wrap-2">${desc || ''}</small>`)}
                </div>
                ` : ''}
            </div>
        </div>
        `
    },
    onSetWidth({val, div}){
        (div ?? this.getItemElement()).each((i, el) => {
            el = $(el)
            let { width, height } = el.data()
            let { newWidth, newHeight } = adjustSize(width, height, { newHeight: val })
            el.find('.container-sizer').css({ width: newWidth, height: newHeight })
            el.find('.badge').toggleClass('hide', newWidth < 100)
        })
    }
}).
registerView('html', {
    onInit(opts){
        
    },
    parseItem(){
       
    },
    onSetWidth(){

    }
}).
registerView('columns', {
    onInit(opts){
        Object.assign(opts, {
            maxWidth: 300,
            minWidth: 50,
        })
    },
    parseItem({item, props, desc, r, newWidth, newHeight }){
        let { duration, title, cover} = item
        return `
        <div ${props}>
            <div class="position-relative card-preview text-center">
                ${OR(r[2], `<span class="badge bg-secondary position-absolute start-5 top-5">${getExtName(title)}</span>`)}
                <img style="width: ${newWidth}px;height: ${newHeight}px" data-src="${cover}" class="thumb lazyload rounded w-full bg-${g_tabler.color_random()}-lt" data-lazyload="datalist_coverLoaded" {preview}>
                ${OR(r[1] && duration > 0, ` <span class="badge badge-secondary position-absolute end-5 bottom-5">${getTime(duration)}</span>`)}
            </div>
            ${OR(r[0], `<p class="text-muted p-2 text-nowrap text-center">${title}</p>`)}
            ${OR(r[3] && !isEmpty(desc), `<p class="text-muted p-2 text-nowrap text-center"><small>${desc}</small></p>`)}
        </div>
        `
    },
    onSetWidth({val}){
        this.getContent().css('columnCount', Math.round(this.getContainer().width() / val))
        .find('.thumb').css({width: 'unset', height: 'unset'}) // 去除首次设置的固定宽高
    }
}).
registerView('list', {
    onInit(opts){
        Object.assign(opts, {
            maxWidth: 300,
            minWidth: 50,
        })
    },
    parseItem: ({item, props, desc, width, height, r }) => {
        let { duration, title, cover, file} = item
        return `
        <div ${props}>
            <div class="position-relative card-preview text-center ">
                ${OR(r[2], `<span class="badge bg-secondary position-absolute start-5 top-5">${getExtName(title)}</span>`)}
                <img src="./res/loading.gif" data-src="${cover}" class="thumb lazyload rounded w-full" data-lazyload="datalist_coverLoaded" {preview}>
                ${OR(r[1] && duration > 0, ` <span class="badge badge-secondary position-absolute end-5 bottom-5">${getTime(duration)}</span>`)}
            </div>
            ${OR(r[0], `<p class="text-muted p-2 text-nowrap">${title}</p>`)}
        </div>
        `
    },
    onSetWidth({val}){
        this.getContent().css('columnCount', Math.round(this.getContainer().width() / val))
    }
}).
registerView('table', {
    onInit(opts){
        let tableHeaders = [];
        let r = Object.values(getConfig(replaceArr(['%name', '%duration', '%ext', '%desc'], 'detail,'), true));
        ['名称', '时长', '格式', '注释'].forEach((title, i) => {
            if (r[i]) tableHeaders.push({ title })
        })
        Object.assign(opts, {
            itemContainer: `<tr class="{class}">{html}</tr>`,
            tableHeaders: [{ title: '封面' }, ...tableHeaders],
            maxWidth: 300,
            minWidth: 50,
        })
    },
    parseItem: ({item, props, desc, newWidth, newHeight, r }) => {
        let { duration, title, cover, file} = item
        return  `
            <th class="position-relative card-preview text-center" ${props}>
                <img style="width:${newWidth}px;height:${newHeight}px;" src="${cover}" class="thumb container-sizer bg-${g_tabler.color_random()}-lt" data-lazyload="datalist_coverLoaded" {preview}>
            </th>
            ${OR(r[0], `<td class="text-muted">${title}</td>`)}
            ${OR(r[1], `<td class="text-muted">${duration ? getTime(duration) : ''}</td>`)}
            ${OR(r[2], `<td class="text-muted">${getExtName(file)}</td>`)}
            ${OR(r[3], `<td class="text-muted">${desc || ''}</td>`)}
            `
    },
    onSetWidth({val, div}){
        (div ?? this.getItemElement()).each((i, el) => {
            el = $(el)
            let { width, height } = el.data()
            let { newWidth, newHeight } = adjustSize(width, height, { newWidth: val })
            el.find('.container-sizer').css({ width: newWidth, height: newHeight })
        })
    }
})