
var g_launch = {
    list: {},
    id: process.pid,
    init(){
        //$.getJSON('http://127.0.0.1:40001/api/method')
        this.startTimer()
        this.connect()
    },
    startTimer(){
        g_pp.setInterval('online_timer', () => this.sendOnline(true), 1000 * 30, true)
    },
    sendOnline(online){
        let data = {app: getFileName(nodejs.dir), id: this.id, online}
        if(!this.send('heart', data)){
            this.start()
        }
        // $.getJSON('http://127.0.0.1:40001/api/online', data, ({responseJSON}) => {}).fail(() => this.start())
    },
    send(type, data = {}) {
        if(this.connection?.readyState == 1){
           this.connection.send(JSON.stringify({type, data}))
           return true
        }
    },
    connect() {
        let url = 'ws://127.0.0.1:40000'
        if (this.connection) this.connection.close();
        let socket = this.connection = new WebSocket(url);
        socket.onopen = () => {
            // this.send('connected', {})
            this.startTimer()
            g_pp.clearTimeout('background_recon')
        }
        socket.onmessage = e => this.onRevice(JSON.parse(e.data)),
        socket.onclose = () => g_pp.setTimeout('background_recon', () => this.connect(), 3000)
    },
    onRevice({type, data}){
        // console.log({type, data})
        switch(type){
            case 'doMethod':
                let opts = JSON.parse(data.data)
                return this.doMethod(opts.method, opts.data)
        }
        
    },
    start(){
        nodejs.cli.run(_dataPath + '/node/node', `"${_dataPath}public/server/server.js"`)
    },
    getLaunchParam(key, remove = true){
        let args = process.argv
        let index = args.indexOf(key)
        if(index != -1 && index < args.length - 1){
            // if(remove) return args.splice(index, 2)[1]
            return args[index + 1]
        }
    },
    registerLaunchParam(key, callback){
        this.list[key] = callback
        var method = this.getLaunchParam('method')
        switch(method){
            case 'doMethod':
                try {
                    var {method, data} = JSON.parse(this.getLaunchParam('data') || '{}')
                    if(!isEmpty(method) && !process.env['method']){
                        this.doMethod(method, data)
                    }
                } catch(err){}
                return
               
        }
    },

    doMethod(method, data){
        let cb = this.list[method]
        if(cb){
            Object.assign(process.env, {method, data})
            cb(data)
        }
    },
}
g_launch.init()