var g_action = {
    list: {
        openFile: dom => nodejs.files.openFile(dom.dataset.file),
        openFolder: dom => ipc_send('openFolder', dom.dataset.file),
        toggleClass: (dom, action) => {
            let active = dom.classList.toggle(action[1])
            !isEmpty(action[2]) && dom.classList[active ? 'remove' : 'add'](action[2])
        },
        activeClass: (dom, action) => {
            let classes = action[1]
            let name = dom.dataset.name 
            getEle({name, action: action.join(',')}).each((i, el) => el.classList.remove(el.dataset.action.split(',')[1]))
            dom.classList.add(classes)
        },
        badge_toggleSelected: dom => {
            let classes = dom.classList.value
            let color = cutString(classes + ' ', 'text-', ' ')
            if(!isEmpty(color)){
                dom.classList.toggle('text-'+color, false)
                dom.classList.toggle('bg-'+color, true)
                return
            }
            color = cutString(classes + ' ', 'bg-', ' ')
            if(!isEmpty(color)){
                dom.classList.toggle('text-'+color, true)
                dom.classList.toggle('bg-'+color, false)
            }
        }
    },
    hover: {},
    clearTimeout(action){
        if(this.hover[action]){
            clearTimeout(this.hover[action])
            delete this.hover[action]
        }
    },
    init: function() {
        const self = this
        let doAction = (dom, action, ev) => {
            if (dom.classList.contains('disabled')) return;
            self.do(dom, action, ev)
        }

        $(document)
            .on('mousewheel', '.scroll-x', function(e){
                this.scrollLeft += e.originalEvent.deltaY
                $(this).trigger('scroll')
            })
            
            .on('show.bs.dropdown', function(ev) {
                let dom = ev.target
                doAction(dom, dom.dataset.dropdown_show, ev)
            })
            .on('hide.bs.dropdown', function(ev) {
                let dom = ev.target
                doAction(dom, dom.dataset.dropdown_hide, ev)
            })
            .on('mouseenter', '[data-hover]', function(ev) {
                let action = this.dataset.hover
                self.clearTimeout(action)
                self.hover[action] = this.hoverTimer = setTimeout(() => doAction(this, action, ev), this.dataset.hovertime || 0)
            })
            .on('mouseleave', '[data-out]', function(ev) {
                self.clearTimeout(this.dataset.hover || this.dataset.outfor)
                doAction(this, this.dataset.out, ev);
            })
            .on('click', '[data-url]', function(ev) {
                ipc_send('url', this.dataset.url)
            })
            .on('click', '[data-action]', function(ev) {
                doAction(this, this.dataset.action, ev);
            })
            .on('mousedown', '[data-mousedown]', function(ev) {
                if(ev.which == 1){ // 左键
                    doAction(this, this.dataset.mousedown, ev);
                }
            })
            .on('mouseup', '[data-mouseup]', function(ev) {
                if(ev.which == 1){ // 左键
                    doAction(this, this.dataset.mouseup, ev);
                }
            })
            .on('dblclick', '[data-dbclick]', function(ev) {
                doAction(this, this.dataset.dbclick, ev);
                clearEventBubble(ev);
            })
            .on('change', '[data-change]', function(ev) {
                doAction(this, this.dataset.change, ev);
            })
            .on('input', '[data-input]', function(ev) {
                g_pp.setTimeout('input', () => { // fix 输入结束事件前触发
                    if(ev.target.isComposing) return
                    doAction(this, this.dataset.input, ev);
                }, 50)
            })
            .on('compositionstart', '[data-input]', ({target}) => target.isComposing = true)
            .on('compositionend', '[data-input]', ({target}) => target.isComposing = false)
            .on('focus', '[data-focus]', function(ev) {
                doAction(this, this.dataset.focus, ev);
            })
            .on('blur', '[data-blur]', function(ev) {
                doAction(this, this.dataset.blur, ev);
            })
            .on('keydown', '[data-keydown]', function(ev) {
                doAction(this, this.dataset.keydown, ev);
            })
            .on('keyup', '[data-keyup]', function(ev) {
                doAction(this, this.dataset.keyup, ev);
            })
            .on('contextmenu', '[data-contenx]', function(ev) {
                doAction(this, this.dataset.contenx, ev);
                clearEventBubble(ev);
            })
            .on('keydown',  e => { // 回车键会触发焦点的action
                if (e.keyCode == 13) {
                    let active = document.activeElement
                    let action = active.dataset.action
                    if (!isEmpty(action)) {
                        active.click()
                        clearEventBubble(e);
                    }
                }
            })

    },
    registerAction: function(name, callback) {
        let isArr = Array.isArray(name)
        if (typeof(name) == 'object' && !isArr) {
            Object.assign(this.list, name)
            return this
        }

        if (!isArr) name = [name];
        for (var alisa of name) this.list[alisa] = callback;
        return this
    },

    do(dom, action, ev) {
        // input 不关闭
        var action = (action || '').split(',');
        if (this.list[action[0]]) {
            let cb = () => this.list[action[0]](dom, action, ev);
            if(typeof(g_plugin) == 'undefined') return cb()
            g_plugin.callEvent('doAction,'+action[0]).then(() => cb())
        }
    }

}

g_action.init()


const doAction = (action, dom, e) => g_action.do(dom, action, e)
const triggerAction = (dom, e) => doAction(dom.dataset.action, dom, e)