const fs = require("fs-extra");
 fs.rmSync ??=  fs.rmdirSync
var { shell } = require('electron');
const crypto = require('crypto')
const {spawn, exec} = require("child_process");

function replaceAll_once(str, search, replace, start = 0) {
    if (typeof(str) != 'string') return ''
    while (true) {
        var i = str.indexOf(search, start);
        if (i == -1) break;
        start = i + search.length;
        str = str.substr(0, i) + replace + str.substr(start, str.length - start);
        start += replace.length - search.length;
    }
    return str;
}

const path = require("path");

function mkdirsSync(dirname) {
    if (fs.existsSync(dirname)) {
        return true;
    }
    if (mkdirsSync(path.dirname(dirname))) {
        fs.mkdirSync(dirname);
        return true;
    }
}
const files = {
    readJson: (file, defV) => {
        if(fs.existsSync(file)){
            return fs.readJSONSync(file)
        }
        return defV
    },
    safePath: str => {
        str = str.replaceAll('\\', '＼')
        str = str.replaceAll('/', '／')
        str = str.replaceAll(':', '：')
        str = str.replaceAll('*', '＊')
        str = str.replaceAll('?', '？')
        str = str.replaceAll('"', '＂')
        str = str.replaceAll('<', '＜')
        str = str.replaceAll('>', '＞')
        str = str.replaceAll("|", "｜")
        return str
    },
    safeSql: str => {
        str = str.replaceAll('/', '//')
        str = str.replaceAll('[', '/[')
        str = str.replaceAll(']', '/]')
        str = str.replaceAll('%', '/%')
        str = str.replaceAll('&', '/&')
        str = str.replaceAll('_', '/_')
        str = str.replaceAll('(', '/(')
        str = str.replaceAll(')', '/)')
        str = str.replaceAll("'", "''")
        return str
    },
    renderSize: value => {
        if (null == value || value == '') {
            return "0 Bytes";
        }
        var unitArr = new Array("Bytes", "KB", "MB", "GB", "TB", "PB", "EB", "ZB", "YB");
        var index = 0;
        var srcsize = parseFloat(value);
        index = Math.floor(Math.log(srcsize) / Math.log(1024));
        var size = srcsize / Math.pow(1024, index);
        size = size.toFixed(2); //保留的小数位数
        return size + unitArr[index];
    },
    getAppData: () => process.env.APPDATA || (process.platform == 'darwin' ? process.env.HOME + '/Library/Preferences' : process.env.HOME + "/.local/share"),
    getFileMd5: (file, type = 'md5') => {
        const buffer = fs.readFileSync(file);
        const hash = crypto.createHash(type);
        hash.update(buffer, 'utf8');
        return hash.digest('hex');
    },
    // MACOS
    getRealPath: file => {
        if(fs.existsSync(file) && fs.lstatSync(file).isSymbolicLink()){
           return fs.realpathSync(file)
        }
        return ''
    },
    getDrives: () => {
        if (process.platform === 'win32') {
          return new Promise(resolve => {
            exec('wmic logicaldisk get caption', (error, stdout) => {
                resolve(error ? [] : stdout.trim().split('\r\r\n').slice(1).map(s => s.trim()));
            });
          });
        } else {
          return Promise.resolve(['/']);
        }
    },
   
    getMD5Hash: (filePath, callback) => {
        return new Promise(resolve => {
            if(fs.existsSync(filePath)){
                const hash = crypto.createHash('md5');
                const stream = fs.createReadStream(filePath);
                stream.on('error', (err) => {
                    console.error(err);
                    callback && callback(null);
                    resolve('');
                });
                stream.on('end', function() {
                    const result = hash.digest('hex');
                    callback && callback(result);
                    resolve(result);
                });
                stream.pipe(hash);
            }else{
               resolve('');
            }
        });
    },
    randomMd5(){
        return this.getMd5(new Date().getTime())
    },
    getMd5: (s) => {
        return crypto.createHash('md5').update(s.toString()).digest("hex")
    },
    getFileName: (file, ext = true) => {
        let name = path.basename(file, '')
        if (!ext) {
            name = name.split('.')
            name.pop()
            return name.join('.')
    }
        return name
    },
    getProxy(){
        return new Promise(reslove => {
            let output = ''
            let platform = process.platform
            if(platform == 'darwin'){
                this.runCmd('networksetup -getwebproxy Wi-Fi', str => output += str, () => {
                    let ret = []
                    output.split('\n').forEach(str => {
                        let [k, v] = str.split(': ')
                        if(k == 'Server'){
                            ret[0] = v
                        }else
                        if(k == 'Port'){
                            ret[1] = v
                        }
                    })
                    reslove(ret.filter(s => s != '').join(':'))
                })
            }else
            if(platform == 'win32'){
                this.runCmd('reg query "HKCU\\Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings" /v ProxyServer', str => output += str, () => {
                    reslove(output.split(' ').filter(str => str.indexOf('.') != -1).join().trim())
                })
            }
        })
    },
    runCmd: (cmd, callback, onClose) => {
        const iconv = require("iconv-lite");
        const platform = process.platform
        if(platform == 'win32'){
            return new Promise(resolve => {
                var result = spawn('cmd.exe ', ['/s', '/c', cmd], { shell: true });
                result.on('close', function(code) {
                    if (typeof(onClose) == 'function') onClose(code);
                });
                result.stdout.on('data', function(data) {
                    callback(iconv.decode(data, 'cp936'));
                });
                resolve();
            });
        }else
        if(platform == 'darwin'){
            exec('networksetup -getwebproxy Wi-Fi', (error, stdout, stderr) => callback(stdout) & onClose(stderr));
        }
    },
    openFile: (path) => {
        if (!fs.existsSync(path)) return false
        shell.openPath(path)
        return true
    },
    openFileInFolder: (path) => {
        if (!fs.existsSync(path)) return false
        shell.showItemInFolder(path)
        return true
    },
    readFile: (file) => {
        if (fs.existsSync(file)) {
            return fs.readFileSync(file)
        }
    },
    read: (file, def) => {
        return fs.existsSync(file) ? fs.readFileSync(file).toString() : def
    },
    exists: (path) => {
        // console.log(path)
        // if(path.startsWith('Y:')) return true
        return fs.existsSync(path)
    },
    isFile: (path) => fs.existsSync(path) && fs.statSync(path).isFile(),
    isDir: (path) => fs.existsSync(path) && fs.statSync(path).isDirectory(),
    mkdir: (dir) => {
        return mkdirsSync(dir)
    },
    makeSureDir: (file) => {
        mkdirsSync(path.dirname(file))
    },
    write: (file, content, option) => {
        if(files.mkdir(path.dirname(file))) return fs.writeFileSync(file, content, option)
    },
    searchDirFiles: (dir, list, fileExts, C) => {
        fs.readdirSync(dir).forEach(fileName => {
            var path = files.join(dir, fileName);
            if (files.isDir(path) && ((!C && C != 0) || C > 0)) {
                // if (files.isEmptyDir(path)) return; // files.removeDir(path);
                return files.searchDirFiles(path, list, fileExts, C - 1);
            }
            if(!fileExts.length || fileExts.findIndex(ext => fileName.endsWith(ext)) != -1){
                list.push(path);
            }
        });
    },
    dirFiles(dirs, fileExts = [], callback) {
        return new Promise(reslove => {
            let list = [];
            if (!Array.isArray(dirs)) dirs = [dirs]
            dirs.forEach(dir => {
                if (files.isDir(dir)) files.searchDirFiles(dir, list, fileExts)
            });
            (callback || reslove)(list)
        })
    },
    items: (dir) => {
        var r = {
            base: dir,
            paths: [],
            files: [],
        }
        fs.readdirSync(dir).forEach(fileName => {
            var path = files.join(dir, fileName);
            if (files.isDir(path)) {
                r.paths.push(fileName);
            } else {
                r.files.push(fileName);
            }
        });
        return r;

    },
    getExtension: (file) => path.extname(file).replace('.', ''),
    remove: (file) => {
        fs.existsSync(file) && fs.unlinkSync(file)
    },
    copySync: (oldFile, newFile, mode = 2) => {
        files.mkdir(path.dirname(newFile));
        fs.copyFileSync(oldFile, newFile, mode);
        return fs.existsSync(newFile);
    },
    copy: (oldFile, newFile, data, callback) => {
        files.mkdir(path.dirname(newFile));
        fs.promises.copyFile(oldFile, newFile).then(err => {
            callback && callback(err, data);
        });
    },
    move(oldFile, newFile, data, callback) {
        if (fs.existsSync(oldFile)) {
            this.makeSureDir(newFile)
            let is = fs.createReadStream(oldFile);
            let os = fs.createWriteStream(newFile);
            is.pipe(os);
            is.on('end', function() {
                fs.unlinkSync(oldFile);
                callback && callback(undefined, data);
            });
        }
    },
    copyMove: (oldFile, newFile) => {
        fs.copyFileSync(oldFile, newFile);
        fs.unlinkSync(oldFile);
        // fs.renameSync(oldFile, newFile);
        return fs.existsSync(newFile);
    },
    join: (dir, file) => path.join(dir, file),
    listDir: (dir) => {
        var res = [];
        fs.readdirSync(dir).forEach(function(name) {
            var filePath = path.join(dir, name);
            var stat = fs.statSync(filePath);
            if (stat.isDirectory()) {
                res.push(filePath);
            }
        });
        return res;
    },
    filterFiles: (dir, cb) => {
        let res = [];
        fs.readdirSync(dir).forEach(function(name) {
            let file = path.join(dir, name);
            let stat = fs.statSync(file);
            if(cb({file, stat}) === true){
                res.push(file);
            }
        });
        return res;
    },
    getImageBase64(file) {
        return 'data: image/' + getImageType(file) + ';base64,' + Buffer.from(fs.readFileSync(file), 'binary').toString('base64');
    },
    isEmptyDir: (dir) => fs.readdirSync(dir).length == 0,
    removeDir: (dir) => fs.rmSync(dir, { recursive: true, force: true }),
    stat: (file) => files.exists(file) && fs.statSync(file),
    guid() {
        return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function(c) {
            var r = Math.random() * 16 | 0,
                v = c == 'x' ? r : (r & 0x3 | 0x8);
            return v.toString(16);
        });
    }
}

function getImageType(str) {
    var reg = /\.(png|jpg|gif|jpeg|webp)$/;
    return str.match(reg)[1];
}


module.exports = files;