const fs = require("fs-extra")
const isEmpty = (s, trim = false) => {
    if (s === null || typeof s === 'undefined') return true;
    if (typeof s === 'string') return (trim ? s.trim() : s).length === 0;
    return false;
}

const setObjVal = (obj, k, v) => {
    if (typeof(v) == 'object') {
        v = JSON.stringify(v)
    } else
    if (typeof(v) == 'string') {
        v = '"' + v + '"'
    }
    eval(`obj.${k} = ${v};`)
}
const getObjVal = (obj, k, def) => {
    if (!isEmpty(k)) k = '.' + k
    try {
        let v = eval("obj" + k)
        return isEmpty(v) ? def : v
    } catch (e) {
        return def
    }
}

function construcotr(file, data = {}){
    if(!fs.existsSync(file)){
        fs.writeFileSync(file, JSON.stringify(data))
    }else{
        data = fs.readJSONSync(file)
    }

    return {
        data,
        set(k, v){
            setObjVal(this.data, k, v)
            this.save()
        },
        get(k, def, cb){
            return getObjVal(this.data, k, def)
        },
        save(data){
            fs.writeFileSync(file, JSON.stringify(data || this.data))
        },
        test(k, cb){
            cb(this.get(k))
        }
    }

}
module.exports = construcotr
