const child_process = require('child_process');
const iconv = require("iconv-lite");
const files = require('./file');
const BINARY = __dirname+'/bin/'
const MAGICK_HOME = BINARY + 'imagemagick/7.0.5-5/'
const DYLD_LIBRARY_PATH = MAGICK_HOME + 'lib/'

function run(exe, cmds, opts = {}, events = {}, callback) {
    // if(typeof(g_tasks) !== 'undefined') return g_tasker.worker.send(['run', exe, cmds, opts, events], console.log)
    if (!Array.isArray(cmds)) cmds = cmds.split(' ');
    // console.log({exe, cmds})
    opts = Object.assign({
        // cwd: '',
        shell: true,
        windowsHide: true,
        maxBuffer: 1024 * 3000,
    }, opts || {})
    if(exe.indexOf(' ') != -1) exe = `"${exe}"`
    let child = child_process.spawn(exe, cmds, opts);
    // 中文要用iconv 英文就不能用
    if (events.onOutput) {
        let output = d => events.onOutput(opts.iconv ? iconv.decode(Buffer.from(d, 'binary'), 'cp936').trim() : d.toString())
        child.stdout.on('data', output)
        child.stderr.on('data', output)
    }

    if (events.onError) {
        child.on('error', function() {
            events.onError.apply(this, arguments);
        })
        // child.on('exit', function() {
        //     events.onError.apply(this, arguments);
        // })
    }
    events.onExit && child.on('close', function() {
        events.onExit.apply(this, arguments);
    })
    events.onRestart && child.on('restart', function() {
        events.onRestart.apply(this, arguments);
    })

    return child;
}

var g_tasks = {};

function task_killAll() {
    for (let id in g_tasks) {
        g_tasks[id].kill();
    }
    g_tasks = {};
}

function task_add(key, task) {
    g_tasks[key] = task;
}

function getBinary(name){
    return getExecName(BINARY + name)
}

function runFFmpeg(cmd, opts, events) {
    let opts1 = {};
    if (opts.progress) {
        delete opts.progress;
        const getValue = (key1, key2, str) => {
            let m = str.match(new RegExp(key1 + '(.*?)' + key2));
            return m ? m[1] : '';
        }

        opts1.onOutput = function(msg) {
            // console.log(msg)
            let r = getValue('time=', ' bitrate=', msg.toString());
            if (r != '') events.onTimeupdate(r);
        }
    }
    let child = run(getBinary('ffmpeg'), cmd, opts.spawn, Object.assign(events, opts1))
    task_add(new Date().getTime(), child);
}


const getColors = (img, opts = {}) => {
    opts.count ??= 9
    return new Promise(reslove => {
        imageMagick([
            `"${img}"`,
            '-define', 'histogram:unique-colors=true',
            '-colors', opts.count, '-format', '%c', 'histogram:info:-'
        ], str => {
            // TODO 同时保存颜色占比
            let colors = str.trim().split('\n').map(color => {
                let arr = color.split(': ')
                return [parseInt(arr[0].trim()), arr[1].split(' ')[0].replace('(', '').replace(')', '')]
            }).sort((a, b) => b[0] - a[0]).map(([cnt, color]) => color)
            reslove(colors)
        }).start()
    })
}

function getExecName(path){
    if(process.platform == 'win32'){
        path += '.exe'
    }
    return path
}

function imageMagick(args, callback, runner = 'convert'){
    let s = ''
    if(nodejs.platform == 'win32'){
        let cmd = args.join(' ')
        return {
            start: () => run(getExecName(MAGICK_HOME + 'bin/'+runner), cmd, {
                env: {MAGICK_HOME,DYLD_LIBRARY_PATH}
            }, {
                onOutput: msg => s += msg,
                onExit: () => callback(s)
            })
        }
    } else{
        // MACOS 执行控制台脚本
        let sh = getExecName(MAGICK_HOME + 'bin/'+runner+'.sh')
        if(!nodejs.files.exists(sh)){
            nodejs.files.write(sh, `
                #!/bin/bash
                export DYLD_LIBRARY_PATH=${DYLD_LIBRARY_PATH}
                export MAGICK_CONFIGURE_PATH=${MAGICK_HOME}etc/ImageMagick-7
                args="$*"
                ${MAGICK_HOME+'bin/'+runner} $args > /dev/console
            `)
            child_process.execSync('chmod +x '+sh)
        }
        return {
            start: () => {
                let sudo = run(sh, args, {}, {
                    onOutput: msg => s += msg,
                    onExit: () => callback(s)
                })
            }
        }
    }
}

// function imageMagick(args, callback){
//     let s = ''
//     let sh = getExecName(MAGICK_HOME + 'bin/convert.sh')
//     if(!nodejs.files.exists(sh)){
//         nodejs.files.write(sh, `
//             #!/bin/bash
//             export DYLD_LIBRARY_PATH=${DYLD_LIBRARY_PATH}
//             export MAGICK_CONFIGURE_PATH=${MAGICK_HOME}etc/ImageMagick-7
//             args="$*"
//             ${MAGICK_HOME+'bin/convert'} $args > /dev/console
//         `)
//         child_process.execSync('chmod +x '+sh)
//     }
//     return {
//         start: () => {
//             let sudo = run(sh, args, {}, {
//                 onOutput: msg => s += msg,
//                 onExit: () => console.log(s) & callback(s)
//             })
//         }
//     }
// }

function ffprobe(file, opts = {}, events) {
    return new Promise(reslove => {
        var s = '';
        var child = run(getBinary('ffprobe'), `-v quiet -show_streams -show_format -print_format json "${file}"`, opts, Object.assign(events || {}, {
            onOutput: function(msg) {
                s += msg;
            },
            onExit: () => {
                reslove(JSON.parse(s));
            }
        }))
    })
}

function toTime(s) {
    var a = s.split(':');
    if (a.length == 1) return s;
    if (a.length == 1) return Number(s);
    if (a.length == 2) {
        a.unshift(0);
    }
    return a[0] * 3600 + a[1] * 60 + a[2] * 1;
}

class ffmpeg {
    events = {}
    output = ''
    constructor(input, opts = {}) {
        //  '-hwaccel cuda'
        this.args = [ '-y', `-i "${input}"`, ...(opts.args || [])]
        delete opts.args
        this.opts = opts;
        return this;
    }
    outputOptions(args, keeps = []) {
        if (keeps.length) {
            let arr = [];
            keeps.forEach(k => {
                let s = this.getParam(k);
                if (s != undefined) arr.push(k + (s != '' ? ' ' + s : ''));
            })
            this.args = arr;
        }
        this.args = Array.from(new Set([...args, ...this.args]))
        return this;
    }
    getInput() {
        return this.getParam('-i', '');
    }
    setParam(key, val) {
        val = key + ' ' + val;
        if (!this.args.some((arg, i) => {
                if (arg.toString().startsWith(key)) {
                    this.args[i] = val;
                    return true
                }
            })){
            this.args.push(val);
        }
        return this;
    }
    getParamIndex(key) {
        return this.args.findIndex(arg => arg.toString().startsWith(key));
    }
    getParam(key, defV) {
        let index = this.getParamIndex(key);
        if (index < 0) return defV;
        let arr = this.args[index].split(' ');
        arr.shift();
        var val = arr.join(' ');
        if (val.substr(0, 1) == '"' && val.substr(-1) == '"') {
            val = val.substr(1, val.length - 2);
        }
        return val;
    }
    videoCodec(codec) {
        return this.setParam('-vcodec', codec);
    }
    audioCodec(codec) {
        return this.setParam('-acodec', codec);
    }
    setInput(file) {
        return this.setParam('-i', `"${file}"`);
    }
    save(saveTo) {
        this.output = `"${saveTo}"`;
        return this.start();
    }
    getCmd() {
        let args = [...this.args];
        args.push(this.output);
        // 听说把-ss放在最前面可以提高速度
        let i = this.getParamIndex('-ss')
        if (i > 0) {
            args.unshift(args.splice(i, 1))
        }
        return args.join(' ')
    }
     start() {
        (async () => {
            if (this.opts.meta) { // 将保存媒体信息
                this.meta = await ffprobe(this.getInput());
            }
            // .replace(/ /g,"\\\ ");
            // todo kill process
            let cmd = this.getCmd();
            this.emit('start', cmd);
            this.process = runFFmpeg(cmd, this.opts, {
                onTimeupdate: time => {
                    this.emit('progress', this.meta ? Math.min(parseInt(toTime(time) / parseInt(this.meta.format.duration) * 100), 100) : time);
                },
                onError: err => {
                    console.error(err);
                    this.emit('error', err);
                },
                onExit: _process => {
                    this.emit('end', _process);
                }
            });
        })()
        return this
    }

    on(eventName, callback) {
        this.events[eventName] = callback;
        return this;
    }

    emit(eventName, ...args) {
        this.events[eventName] && this.events[eventName].apply(this, args);
        return this;
    }

    kill() {
        this.process.kill();
    }

    getAvailableCodecs(callback) {
        let r = { V: {}, A: {} };
        let s = '';
        runFFmpeg('-encoders', {}, {
            onOutput: msg => s += msg,
            onExit: code => {
                for (let line of s.split('\n')) {
                    line = line.trim();
                    let key = line.substr(0, 1);
                    if (r[key]) {
                        let arr = line.replaceAll('  ', ' ').split(' ');
                        let name = arr[1];
                        if (name == '=') continue;
                        let val = '';
                        arr.reverse().some(s1 => {
                            val = s1 + ' ' + val;
                            return s1 == '';
                        });
                        r[key][name] = val.trim();
                    }
                }
                callback(r);
            }
        });
        return this;
    }


    vf(output, fps = 1) {
        return this
            .setParam('-vf', 'fps=' + fps)
            .save(output);
    }

    screenshots1(opts) {
        let {quality, level, scale, output, time, frame} = Object.assign({
            quality: 40,
            level: 4,
            scale: '-1:225'
        }, opts)
        files.makeSureDir(output)
        let vf = [`scale=${scale}`]
        if(frame != undefined) vf.push('select=gte(n\\,'+frame+')')
        let args = ['-vf', `"${vf.join(',')}"`, '-vframes', '1', '-an', '-pix_fmt', 'yuv420p', '-c:v', 'libwebp', '-quality', quality, '-compression_level', level, '-y', `"${output}"`]
        if(time != undefined) args.unshift('-ss', time)
        return this
        .outputOptions(args)
    }

    screenshots(opts) {
        // TODO 单张的不需要获取时长
        let file = this.getParam('-i').trim('');
        let out = [`-i "${file}"`, '-y', ] // -i 必须在最前面
        if (this.meta) {
            //let duration = this.meta.format.duration;
            let video = this.meta.streams[0];
            if (opts.size) {
                let size = opts.size.split('x');
                let r = video.width / video.height;
                if (size[0] == '?') {
                    size[1] = parseInt(size[1]);
                    size[0] = parseInt(r ? size[1] * r : size[1] / r);
                } else
                if (size[1] == '?') {
                    size[0] = parseInt(size[0]);
                    size[1] = parseInt(r ? size[0] / r : size[0] * r);
                }
                out.push(`-s ${size[0]}x${size[1]}`)
            }
            if (typeof(opts.count) == 'number') { // 生成指定数量
                let count = parseInt(opts.count); // 会有偏差
                out = out.concat('-vsync 0', `-vf select="not(mod(n\\,${parseInt(video.nb_frames / count)}))"`);
                return this
                    .outputOptions(out)
                    .save(opts.folder + '/' + opts.filename);
            }
        }

        if (!Array.isArray(opts.timestamps)) {
            opts.timestamps = [opts.timestamps];
        }

        let cnt = 0;
        opts.timestamps.forEach((time, i) => {
            let args = [...out];
            // , '-r 1'
            args.unshift(`-ss ${time}`);
            // -vframes 1', 
            args.push(`"${opts.folder}/${opts.filename.replace('{i}', i)}"`);
            runFFmpeg(args.join(' '), this.opts || {}, {
                onOutput: msg => {
                    if (msg.indexOf('global headers:') != -1) {
                        this.emit('progress', ++cnt / opts.timestamps.length);
                    }
                },
                onError: err => {
                    this.emit('error', err);
                },
                onExit: code => {
                    this.emit('end', code);
                }
            });
        })

        return this;
    }
}

// var command = new ffmpeg('K:\\movies\\aa.mp4', {
//     progress: true,
//     meta: true,
//     env: { proxy: 'http://127.0.0.1:1080', http_proxy: 'http://127.0.0.1:1080', https_proxy: 'http://127.0.0.1:1080' },
// }).outputOptions([]);
// command
//     // .setInput()
//     // .videoCodec('copy')
//     // .audioCodec('copy')
//     .on('start', function(cmd) {
//         console.log('ffmpeg '+ cmd);
//     })
//     .on('progress', function(progress) {
//         console.log('progress', progress);
//     })
//      .on('output', function(progress) {
//         console.log('output', progress);
//     })
//     .on('error', function(e) {
//         console.log('error', e);
//     })
//     .on('end', function(str) {
//         console.log('end');
//     })
//     .screenshots({
//         count: 20,
//         // timestamps: [1, 2],
//         folder: 'C:/Users/liaoyanjie/Desktop/a',
//         filename: 'screenshot%03d.jpg',
//         // filename: 'screenshot{i}.jpg',
//         size: '160x?'
//     })
// .save('C:/Users/liaoyanjie/Desktop/out.mp4');



// runFFmpeg(`-i "C:\\Users\\liaoyanjie\\Desktop\\[1655487765727]标签1 , 标签2_我是备注.mp4" -y -acodec copy -vcodec libx264 -y -ss 0 -t 2 "C:\\Users\\liaoyanjie\\Desktop\\b.avi"`, {
//     progress: true,
//      env: { proxy: 'http://127.0.0.1:1080', http_proxy: 'http://127.0.0.1:1080', https_proxy: 'http://127.0.0.1:1080' },
// }, {
//     onTimeupdate: s => {
//         console.log(s);
//     },
// });
// task_killAll();

// ffprobe('C:\\Users\\liaoyanjie\\Desktop\\[1655487765727]标签1 , 标签2_我是备注.mp4').then(meta => {
//     console.log(meta);
// })

module.exports = {
    ffmpeg,
    run,
    ffprobe,
    getColors,
    imageMagick,
    task_killAll,
    getBinary,
    getExecName,
}