module.exports = function ({dialog, win, session, sendEvent, registerMethod, isEmpty, BrowserView, remote, currentOpts}) {
    const platform = process.platform
    const isWin7 = win.isWin7 = process.versions.electron.replaceAll('.', '') * 1 <= 1100
    const initViewSize = () => {
        let [width, height] = win.getSize()
        if(win.isMaximized() && platform != 'darwin') width -= 8 // 最大化溢出问题
        win.getCurrentView().setBounds({ x: 0, y: 0, width, height })
    }
    
    win.setTopBrowserView1 = win.setTopBrowserView
    win.setTopBrowserView = function(view){
        if(isWin7){
            let last = this.getCurrentView()
            if(last) last.setBounds({ x: 0, y: 0, width: 0, height: 0 }) // win7 只能改大小
        }

        win.currentView = view.id
        if(!view.inited || isWin7){ // 不初始化不显示？
            initViewSize()
            view.setBackgroundColor('white')
            view.inited = true
          }
        view.webContents.focus()
        if(win.setTopBrowserView1) return win.setTopBrowserView1(view)
    }

    win.getCurrentWebcontents = function(){
        return this.getCurrentView().webContents
    }

    win.findViewByWebContents = function(contents){
        return this.getBrowserViews().find(view => view.webContents === contents)
      }

    win.setBrowserView1 = win.setBrowserView
    win.setBrowserView = function(view){
      win.currentView = view.id
      return this.setBrowserView1(view)
    }

    win.setBrowserView1 = win.setBrowserView
    win.setBrowserView = function(view){
      win.currentView = view.id
      return this.setBrowserView1(view)
    }

    win.on('maximize', () => initViewSize())
    win.on('unmaximize', () => initViewSize())

    win.getCurrentView = function(){
        let views = this.getBrowserViews()
        if(views.length == 1) return views[0]
        if(this.currentView) return findView(this.currentView).view
    }
    
    registerMethod({
        setViewAttr(data){
            let {id, props} = data
            let { view } = findView(id)
            if(view) Object.assign(view, props)
        },
        addView: data => addView(data),
        removeView: ({id, next}) => removeView(id, next),
        switchView: ({id}) => switchView(id),
        prevView: () => nextView(-1),
        nextView: () => nextView(1),
    })

    function addView(opts) {
        opts = Object.assign({ url: '%url%', active: true }, opts)
        let { id, url, partition } = opts
        let { view } = findView(id)
        if (!view) {
            let webPreferences = Object.assign({
                enableRemoteModule: true,
                nodeIntegrationInWorker: true,
                nodeIntegration: true,
                contextIsolation: false,
            }, opts.webPreferences || {})
            view = new BrowserView({ webPreferences: { ...webPreferences, ...(isEmpty(partition) ? { session: session.defaultSession } : { partition }) } })

            let active = opts.active 
            delete opts.active
            Object.assign(view, opts)

            view.setBackgroundColor('white')
            view.setAutoResize({ width: true, height: true, horizontal: true, vertical: true })
            win.addBrowserView(view)
            active && win.setTopBrowserView(view)
            remote.enable(view.webContents)
            view.webContents.loadURL(url.replace('%url%', currentOpts.url), { userAgent: 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.134 Safari/537.36 Edg/103.0.1264.71' })
            sendEvent('onViewAdded', opts)
        }
        return view
    }

    function findView(id) {
        let views = win.getBrowserViews()
        let max = views.length;
        let ret = { views, max, index: -1 }
        !isEmpty(id) && views.forEach((view, index) => {
            if (view.id == id) {
                ret.index = index
                ret.view = view
                return
            }
        })
        return ret
    }

    function removeView(id, next = true) {
        let { view } = findView(id)
        if (view) {
            win.removeBrowserView(view)
            if(!isWin7 && !view.webContents.isDestroyed()) view.webContents.destroy()
            next && nextView()
            return true
        }
    }
    win.removeView = removeView

    function switchView(id) {
        let { view } = findView(id)
        if (view) {
            win.setTopBrowserView(view)
            return true
        }
    }

    function nextView(offset = 1) {
        let currentView = win.getCurrentView()
        if(!currentView || offset == 0) return
        let { index, max, views } = findView(currentView.id)

        index += offset
        if(offset > 0){
            if( index >= max) index = 0
        }else{
            if( index < 0) index = max - 1
        }
        win.setTopBrowserView(views[index])
    }

    return {addView, nextView}
}