var g_apps = new basedata({
    name: 'apps',
    list: {},
    defaultList: {
        main: { title: '应用启动器', description: '启动中心', path: './main/', updateURL: 'https://neysummer2000.fun/mLauncher/', icon: 'favicon.ico' },
        public: { title: '公共库', description: '底层框架', path: './public/', updateURL: 'https://neysummer2000.fun/public/', icon: '../public/public.ico' }
    },
    worker: new Worker_IPC('worker.js'),
    saveData: data => nodejs.fs.writeJSON(_dataPath + 'apps.json', data),
    init() {
        let cfg = _dataPath + 'apps.json'
        this.list = { ...this.defaultList, ...(nodejs.files.exists(cfg) ? nodejs.fs.readJsonSync(cfg) : {}) }
        let actions = ['launch', 'checkUpdate', 'edit', 'new', 'openFolder', 'delete', 'pack', 'import', 'shortcut'].map(k => 'app_' + k)
        g_action.registerAction(actions, (dom, action, ev) => {
            let key = getParentAttr(dom, 'data-app')
            let data = this.get(key)
            switch (actions.indexOf(action[0])) {
                case 0:
                    if (dom.classList.contains('card-btn')) dom.classList.add('btn-loading')
                    return this.app_launch({ key, blank: ev.ctrlKey })
                case 1:
                    return this.app_update(key)
                case 2:
                    return this.app_edit(Object.assign(data, { id: key }))
                case 3:
                    return this.app_edit()
                case 4:
                    return ipc_send('openFolder', _dataPath + key + '/index.html')
                case 5:
                    return confirm('确定要删除应用吗？此操作只会从列表中移除，而不会删除代码文件，请自行删除!', { type: 'danger' }).then(ok => ok && this.remove(key))
                case 6:
                    let skip = data.ingones || []
                    skip.push(...['/.git/', '/_gsdata_/', '/node_modules/'])
                    return this.app_pack({ path: _dataPath + key, skip: skip.join('\n') })
                case 7:
                    return this.app_import()
                case 8:
                    if(nodejs.platform == 'win32'){
                        let saveTo = nodejs.remote.app.getPath('desktop') + '/' + data.title + '.lnk'
                        if(shell.writeShortcutLink(saveTo, nodejs.files.exists(saveTo) ? 'update' : 'create', {
                            target: process.execPath,
                            args: '. ' + key,
                            description: data.description,
                            icon: _dataPath + key +'/favicon.ico',
                            iconIndex: 0,
                        })) toast('成功在桌面创建了快捷方式!', 'success')
                    }else{
                        let {execSync} = nodejs.require('child_process')
                        let source = _dataPath+'public/bin/Script-sh.app'
                        execSync(`sips -s format icns /Applications/mLauncher.app/Contents/Resources/app/${key}/favicon.ico --out ${source}/Contents/Resources/cmd.icns`)

                        let target = `${nodejs.remote.app.getPath('desktop')}/${data.title}.app`
                        execSync(`cp -R ${source} ${target}`)
                        nodejs.files.write(`${target}/Contents/MacOS/main.command`, `#!/bin/sh\nopen -n /Applications/mLauncher.app/ --args . ${key}\nexit 0`)
                        toast('成功在桌面创建了快捷方式!', 'success')
                    }
                    return
            }
        })
        .registerAction({
            setLayout: (d, a) => setConfig('layoutMode', a[1]) & setTimeout(() => location.reload(), 500),
            app_setEnv: (dom, action) => {
                nodejs.platform = action[1]
                toast('成功设置临时环境为【'+action[1]+'】,现在可以进行打包操作!', 'success')
            },
        })
        g_ui.register('apps', {
            target: '#content',
            html: `<div id="app_list" class="d-flex flex-wrap align-content-start w-full m-0 overflow-y" style="padding: 20px;height: calc(100vh - 0px);"></div>`,
            onShow: () => this.refresh(),
        }).show('apps')
        this.app_checkAllUpdates()
        // this.app_update('test')
        // this.app_pack({path: _dataPath+'mCollection', skip: `/scripts/\n/bin/\n/package-lock.json\n/test/\n/mCollection.zip`})
        
    },
    app_checkAllUpdates(){
        Object.keys(this.list).forEach(app => {
            this.app_update(app, files => {
                let hasNew = Array.isArray(files) && files.length > 0
                 $(`<span class="badge bg-${hasNew ? 'danger' : 'success'}-lt ms-2 updateBadge">${hasNew ? 'News' : 'Lasted'}</span>`).appendTo(getEle('app_checkUpdate', 'a.btn', this.app_getEle(app)).removeClass('btn-loading'))
            })
        })
    },
    app_import() {
        openFileDiaglog({
            title: '选择压缩包',
            properties: ['openFile'],
            filters: [{ name: '压缩包文件', extensions: ['zip'] }]
        }, ([input]) => {
            if (isEmpty(input)) return
            let output = _dataPath + '_temp/'
            nodejs.files.removeDir(output)

            unZip({
                input, output,
                check: entry => entry.type == 'File' && getFileName(entry.path) == 'app.json' && entry.vars.uncompressedSize > 0
            }, () => {
                let config = nodejs.fs.readJsonSync(output + 'app.json')
                config.source = output

                if (this.list[config.id]) config.id += '_' + new Date().getTime()
                this.app_edit(config)
            }, err => toast(err, 'danger'))
        })
    },

    app_launch(opts) {
        let { key, blank } = opts
        if (['main', 'public'].includes(key)) return toast('此应用只能更新，不适合在这里启动', 'danger')
        let d = this.get(key)
        if (d) {
            // TODO 判断是否正在运行
            if(nodejs.platform == 'darwin'){
                nodejs.cli.run('open', ['-n', `"${nodejs.path.resolve(_dataPath, '../../..')}/"`, '--args', '.', key])
            }else{
                nodejs.cli.run(nodejs.path.resolve(_dataPath, '../../mLauncher.exe'), ['.', key])
            }
            setTimeout(() => !blank && ipc_send('exit'), 2000)
        }
    },
    app_edit(d = {}) {
        g_form.confirm1({
            id: 'app_edit',
            elements: {
                id: {
                    title: '应用ID',
                    required: true,
                    value: d.id || '',
                    help: '软件resource/app/下的应用程序目录名称',
                },
                title: {
                    title: '应用名称',
                    required: true,
                    value: d.title || '',
                },
                description: {
                    title: '注释',
                    value: d.description || ''
                },
                updateURL: {
                    title: '更新地址',
                    value: d.updateURL || ''
                },
                dataPath: {
                    title: '目录位置',
                    type: 'file_chooser',
                    help: '不填默认,根目录/cache/应用名称',
                    opts: {
                        title: '选择数据保存目录',
                        properties: ['openDirectory'],
                    },
                    value: d.path || ''
                },
                bg: {
                    title: '启动背景图',
                    value: d.bg || '',
                    type: 'file_chooser',
                    opts: {
                        title: '选择背景图片',
                        properties: ['openFile'],
                        filters: [{ name: 'Images', extensions: ['jpg', 'jpeg', 'png', 'gif'] }],
                    },
                },
                pin: {
                    title: '固定到任务栏右键启动列表',
                    type: 'switch',
                    value: d.pin || false
                },
            },
            title: '编辑应用',
            callback: ({ vals }) => {
                let { source } = d
                let { id, title, description, updateURL, dataPath, bg, pin, ingones, rules } = vals
                let targetPath = _dataPath + id + '/'
                if (nodejs.files.exists(targetPath) && source) {
                    ipc_send('openFolder', targetPath)
                    toast('目标目录 ' + targetPath + ' 已经存在,请手动删除！', 'danger')
                    return false
                }

                source && nodejs.fs.renameSync(source, targetPath)
                if (!nodejs.files.exists(targetPath)) {
                    toast(`根目录/resources/app/${id} 不存在，请先讲应用放到此处`, 'danger')
                    return false
                }

                this.set(id, { id, title, description, updateURL, ingones, dataPath, bg, pin, rules, path: './' + id + '/' })
                toast('保存成功', 'success')
            }
        }, { scrollable: true })
    },
    app_pack(opts) {
        g_form.confirm1({
            id: 'app_pack',
            elements: {
                dir: {
                    title: '目录',
                    type: 'file_chooser',
                    required: true,
                    value: opts.path || '',
                    opts: {
                        title: '选择要上传更新的目录',
                        properties: ['openDirectory'],
                    }
                },
                skip: {
                    title: '排除列表',
                    type: 'textarea',
                    rows: 8,
                    value: opts.skip || '',
                },
                assignBin: {
                    title: 'bin目录无改动',
                    type: 'checkbox',
                }
            },
            title: '生成listFile.json',
            callback: ({ vals }) => {
                let { dir, skip, assignBin } = vals
                if (!nodejs.files.exists(dir)) return toast('目标目录不存在', 'danger')

                let data = {}
                let saveTo = dir + '/listFile-'+nodejs.platform+'.json'
                let skips = ['/listFile-', ...skip.split('\n')]
                if(assignBin){
                    skips.push('/bin/')
                    try {
                        Object.entries(nodejs.fs.readJsonSync(saveTo)).forEach(([k, v]) => {
                            if(k.startsWith('//bin/')) data[k] = v
                        })
                    } catch(err){
                        return toast('读取josn错误', 'danger')
                    }
                }
                this.worker.send(['generateFileList', dir, skips], files => {
                    confirm(Object.keys(files).join('</br>'), { title: '是以下这些文件吗？', scrollable: true }).then(ok => {
                        if(ok){
                            nodejs.fs.writeJSON(saveTo, Object.assign(files, data))
                            toast('生成成功!', 'success')
                        }
                    })
                })
            }
        })
    },

    app_update(name, cb) {
        let names, app
        if (!(app = this.get(name))) return
        
        let showMsg = (...args) => !cb && toast.apply(this, args)
        let { title, path, updateURL, rules } = app
        if (isEmpty(updateURL)) return showMsg(name + ' 无可用更新地址') & cb()

        rules = Object.entries(rules ?? {})
        if (!updateURL.endsWith('/')) updateURL += '/'
        showMsg('开始检测更新['+title+']...')
        $.ajax({
            url: updateURL + 'listFile-'+nodejs.platform+'.json',
            headers: {'Cache-Control': 'no-cache'},
            success: json => {
                let {join, basename} = nodejs.path
                let {getRealPath, write, getFileMd5, exists} = nodejs.files

                let dir = join(_dataPath, path)
                // json = nodejs.fs.readJsonSync(dir+'listFile-darwin.json')
                this.worker.send(['generateFileList', dir, app.ingones], files => {
                    let news = Object.entries(json).filter(([k, v]) =>  {
                        if(['.DS_Store'].includes(basename(k))) return false
                        if(!files[k]) return true
                        if(typeof(v) == 'object'){
                            let {type, value} = v
                            if(type == 'link') return getRealPath(join(dir+k)) !== join(dir+value)
                        }
                        return files[k] !== v
                    })
                    names = news.map(([k]) => k)
                    if (names.length == 0) return showMsg('已经是最新版本!', 'success') & cb()
                    if(cb) return cb(names)

                    let id = 'progress_update'
                    confirm(names.join('</br>'), { 
                        id, scrollable: true, title: '共发现了' + names.length + '个文件有更新!是否更新?'
                    }).then(ok => {
                        if(!ok) return

                        var req, progress
                        const cancelDownload = () => {
                            g_modal.remove(id)
                            progress.destroy()
                            req && req.abort()
                            if(progress.val >= 100){
                                location.reload()
                            }else{
                                this.app_getEle(name).find('.updateBadge').remove()
                            }
                        }
                        progress = new Progress(id, {
                            datas: names,
                            onProgress: i => i >= 100 && g_modal.modal_get(id).find('#btn_ok').html('完成'),
                            onClose: cancelDownload
                        })

                        progress.build(html => {
                            alert(html, {
                                id,
                                title: '更新文件',
                                btn_ok: '取消',
                                scrollable: true,
                                onShow: modal => {
                                    let next = () => {
                                        let item = news.shift()
                                        if (item == undefined) return
                                        let [name, md5] = item

                                        const done = success => {
                                            progress.setSloved(name, 1, `<p class="text-${success ? 'success' : 'danger'}">${success ? '√ 成功下载' : 'X 下载失败'}: %%s%%</p>`)
                                            next()
                                        }
                                        if(typeof(md5) == 'object'){
                                            let {type, value} = md5
                                            if(type == 'link'){
                                                let saveTo = join(dir+name)
                                                exists(saveTo) && fs.unlinkSync(saveTo)
                                                fs.symlinkSync(join(dir+value), saveTo)
                                                done(true)
                                            }
                                        }else{
                                            let url = name = name.replaceAll('\\', '/').replaceAll('//', '/')
                                            let rule = rules.find(([prefix]) => name.startsWith(prefix))
                                            if(rule && !isEmpty(rule[1])){
                                                url = rule[1].replace('%platform%', nodejs.platform).replace('%filename%', name.substring(rule[0].length)) // 替换网络位置  
                                            }
                                            url = new URL('.'+url, updateURL).href
                                            let saveTo = join(dir + (name.startsWith('.') ? '.'+name : name))
                                            
                                            progress.addLog('<p>开始下载：'+name+ '</p>')
                                            req = downloadFile({
                                                md5, name, url,
                                                saveTo: join(dir + (name.startsWith('.') ? '.'+name : name)),
                                                progress: val =>modal.find('.modal-title').html('文件下载进度:'+val+'%'),
                                                complete(saveTo) {
                                                    done(typeof (saveTo) == 'string' && exists(saveTo) === true && getFileMd5(saveTo) == this.md5)
                                                },
                                            })
                                        }
                                    }
                                    next()
                                }
                            }).then(cancelDownload)
                        })
                    })
                })
            },
            error: () => showMsg('错误响应!', 'danger'),
            dataType: 'json'
        })
    },
    app_getEle(app){
        return getEle({app})
    },
    refresh() {
        let h = ''
        let isList = getConfig('layoutMode') == 'list'
        this.entries((k, v) => {
            let b = ['main', 'public'].includes(k)
            let avatar = `<span data-action="app_launch" class="avatar avatar-xl rounded" style="background-image: url(${v.icon || '../' + v.path + 'favicon.svg'})"></span>`
            let btns = `${!b ? `<a class="btn card-btn" data-action="app_launch">启动</a>` : ''}
            <a class="btn card-btn btn-loading" data-action="app_checkUpdate">检查更新</a>`
            let dropdown = `
            <div class="dropdown">
                <a class="dropdown-toggle position-absolute end-0 top-0 p-2" style="z-index:1" data-bs-toggle="dropdown"><i class="ti ti-dots"></i></a>
                <div class="dropdown-menu">
                    ${!b ? `<a class="dropdown-item" data-action="app_edit">编辑</a>` : ''}
                    <a class="dropdown-item" data-action="app_pack">打包</a>
                    ${!b ? `<a class="dropdown-item" data-action="app_shortcut">创建快捷方式</a>` : ''}
                    <a class="dropdown-item" data-action="app_checkUpdate">检查更新</a>
                    <a class="dropdown-item" data-action="app_openFolder">定位</a>
                    ${!b ? `<div class="dropdown-divider"></div>
                    <a class="dropdown-item text-danger" data-action="app_delete">删除</a>` : ''}
                </div>
            </div>`

            h += isList ? `
            <div class="col-12 col-lg-6 col-xxl-4 "  data-app="${k}">
                ${dropdown}
                <div class="row p-2 align-items-center">
                    <a href="#" class="col-auto">${avatar}</a>
                    <div class="col text-truncate ">
                        <a href="#" class="text-reset d-block text-truncate">${v.title}</a>
                        <span class="text-muted text-truncate mt-n1">${v.description}</span>
                    </div>
                    <div class="col">${btns}</div>
                </div>
            </div>
            ` : `
            <div class="col-12 col-sm-6 col-md-4 col-lg-3 p-2" data-app="${k}">
                <div class="card position-relative">
                    ${dropdown}
                    <div class="card-body text-center ">
                        <div class="mb-3">${avatar}</div>
                        <div class="card-title mb-1 text-truncate">${v.title}</div>
                        <div class="text-muted text-truncate">${v.description}</div>
                    </div>
                    <div class="d-flex">${btns}</div>
                </div>
            </div>`
        })
        $('#app_list').html(isList ? `
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">应用列表</h3>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        ${h}
                    </div>
                </div>
            </div>
        ` : h)
    },
    getItem(app) {
        return getEle({ app })
    }
})