var files = require('../../public/file.js');
const child_process = require('child_process');
const iconv = require("iconv-lite");

function run(exe, cmds, opts = {}, events = {}, callback) {
    if (!Array.isArray(cmds)) cmds = cmds.split(' ');
    
    opts = Object.assign({
        // cwd: '',
        shell: true,
        windowsHide: true,
        maxBuffer: 1024 * 3000,
    }, opts || {})
    if(exe.indexOf(' ') != -1) exe = `"${exe}"`
    let ret = ''
    let child = child_process.spawn(exe, cmds, opts);
    // 中文要用iconv 英文就不能用
    if (events.onOutput || callback) {
        let output = d => {
            let msg = opts.iconv ? iconv.decode(Buffer.from(d, 'binary'), 'cp936').trim() : d.toString()
            ret += msg
            typeof(events.onOutput) == 'function' && events.onOutput(msg)
        }
        child.stdout.on('data', output)
        child.stderr.on('data', output)
    }

    if (events.onError) {
        child.on('error', err => events.onError.apply(this, err))
    }
    child.on('close', function() {
        events.onExit && events.onExit.call(this, ret);
        console.log(ret)
        callback && callback(ret)
    })
    events.onRestart && child.on('restart', function() {
        events.onRestart.call(this, ret);
    })

    return child.pid;
}

addEventListener('message', async e => {
    let { id, data, includeFun } = e.data
    let [method, ...args] = data
    if(includeFun) args = parseFunctions(args) // 函数文本转函数
    postMessage({ ret: await this[method].apply(this, args), id });
})

function createThumbnailFromPath(file, opts, parser = 'toDataURL'){
    return new Promise(reslove => {
        // TODO  win7无法使用
        let {nativeImage} = require('electron')
        if(process.platform != 'darwin') file = file.replaceAll('/', '\\')
         nativeImage.createThumbnailFromPath(file, opts).then(ret => {
            reslove({
                size: ret.getSize(),
                data: ret[parser]()
            })
         })
    })
}

function revice(d) {
    return new Promise(reslove => {
        let { type, file, saveTo } = d
        files[type](file, saveTo, d, err => reslove(err));
    })
}

function getMD5Hash(filePath) {
    return files.getMD5Hash(filePath)
}

function parseFunctions(obj) {
    if (typeof obj === 'string' && (obj.startsWith('function(') || obj.indexOf('=>') != -1)) {
      return new Function(`return ${obj}`)();
    }
    if (Array.isArray(obj)) {
      return obj.map(item => parseFunctions(item));
    }
    if (typeof obj === 'object' && obj !== null) {
      const newObj = {};
      Object.keys(obj).forEach(key => {
        newObj[key] = parseFunctions(obj[key]);
      });
      return newObj;
    }
    return obj;
}
