const path = require('path')
const url = require('url')
const fs = require('fs-extra')
// const files = require('../../public/file.js')
const WebSocketServer = require('ws').Server;
const config_file = __dirname + '/config.json'

if (!fs.existsSync(config_file)) fs.writeJSONSync(config_file, {
    websocket_port: 41594,
    http_port: 41597
})
const g_revices = {}
const config = fs.readJSONSync(config_file)
const saveConfig = () => fs.writeJSONSync(config_file, config)
const wss = new WebSocketServer({ port: parseInt(config.websocket_port) });

wss.on('connection', ws => {
    ws.on('message', msg => onMessage(JSON.parse(msg), ws))
});

function unregisterRevice(name) {
    delete g_revices[name]
}

function registerRevice(name, callback) {
    let isArr = Array.isArray(name)
    if (typeof (name) == 'object' && !isArr) {
        Object.assign(g_revices, name)
        return this
    }

    if (!isArr) name = [name];
    for (var alisa of name) g_revices[alisa] = callback;
    return this
}

const express = require('express');
const app = express();
app.use(express.static(__dirname));
// app.use((req, res, next) => {
//     console.log(
//       `请求的ip地址是：${req.ip}, 请求的路径是：${
//         req.url
//       }`);
//     next();
//   });
app.use(express.json({ limit: '50mb' }));
app.use(express.urlencoded({ extended: true, limit: '50mb' }));
// app.use(require('body-parser').urlencoded({ extended: false }));
app.listen(parseInt(config.http_port));

var _lastDB
let db_manager = require('./db.js')({ registerRevice, sendMsg, registerApi, echoJson });
// (async () => {
//     let db = _lastDB = "I:/software/library/test/items.db"
//     let { type, data: { inst } } = onMessage({
//         type: 'db_load', data: {
//             file: db, opts: {
//                 type: 'library'
//             }
//         }
//     })
//     if (type == 'db_loaded') {
//         let { g_tags, g_folders, g_data } = db_manager.getInstance(db, ['tags', 'data', 'folders'])
//         // console.log({tags: await g_tags.getList(), folders: await g_folders.getList()})
//         // let { data } = onMessage({ type: 'db_fetch', data: { db, type: 'all', query: 'SELECT id FROM files', args: [] } })
//         // console.log(data)
//     }

// })()

function onMessage({ type, data }, ws) {
    // console.log({type, data})
    // console.log(JSON.stringify(data,null, 2))
    if (g_revices[type]) return g_revices[type](data, ws);
    switch (type) {
        case 'list_db':
            return db_manager.do_method('db_list', {}, ws)
        case 'exit':
            return process.exit()
        case 'connected':
            ws._type = data.type
            // ws._name = d.name
            return sendMsg(ws, 'config', config);
    }
}



// http://127.0.0.1:41597/api/tag/list?db=I:/software/library/test/items.db
['tag', 'folder'].forEach(type => {
    ['create', 'rename', 'update', 'list', 'listRecent'].forEach(method => {
        registerApi(`/api/${type}/${method}`, ['create'].includes(method) ? 'post' : 'get', async (res, req) => {
            let query = req.body || req.query
            let { id, db } = query
            if(!db) db = (await waitFor('current_db')).file
            // db ??= 'I:/software/library/test/items.db'
            console.log({query, db})

            if (isEmpty(db)) return
            let inst = db_manager.getInstance(db, type + 's')['g_' + type + 's']
            switch (method) {
                case 'create':
                    let {folderName} = query
                    echoJson(res,{"status":"success","data":{"id": folderName,"name": folderName,"images":[],"folders":[],"modificationTime":1699181576363,"imagesMappings":{},"tags":[],"children":[],"isExpand":true}}) // 返回名字让主程序根据名字创建文件夹
                    // {"status":"success","data":{"id":"LOLCU7CB886TV","name":"画风 hf","images":[],"folders":[],"modificationTime":1699181576363,"imagesMappings":{},"tags":[],"children":[],"isExpand":true}}
                    break;
                case 'rename':
                case 'update':
                    // 判断文件夹是否存在
                    break

                case 'list':
                case 'listRecent':
                    return inst.getList().then(data => {
                        echoJson(res, {
                            status: 'success',
                            data: data.map(item => {
                                let { id, title, desc, ctime, icon, meta, parent } = item
                                let children = inst.folder_getChildren(id, false)
                                return {
                                    id, children,
                                    "name": title,
                                    "description": desc,
                                    "modificationTime": ctime,
                                    "tags": [],
                                    "imageCount": inst.folder_queryItems(id, true),

                                    password: '',
                                    passwordTips: '',
                                    images: [],
                                    "isExpand":true,
                                    "imagesMappings":{},
                                    "imageCount":0,
                                    "depth":0,
                                    "descendantImageCount":0,
                                    "pinyin":"",
                                    "extendTags":[],
                                    "covers":[/*"<img class=\"sub-folder-cover \" src=\"file:///I:/eagle.library/images/LOL6I54DRJJNA.info/5%20Pinterest.jpg\" style=\"aspect-ratio: 0.7235294117647059;\">"*/],
                                    "size":27,
                                    "vstype":"folder",
                                    "guidelines":[],
                                    "styles":{"depth":0,"first":false,"last":false},
                                    "isVisible":true,
                                    "index":11,
                                    "$$hashKey":"object:504",
                                    "newFolderName":"New Folder"
                                }
                            })
                        })
                    })

            }
        })
    })
})

registerApi([
    ['/api/library/list', 'get', res => {
        // TODO 合并客户端加载的数据库
        echoJson(res, db_manager.listDB())
    }],
    ['/api/library/history', 'get', (res, req) => {
        echoJson(res, {
            status: 'success',
            data: Object.keys(db_manager.listDB())
        })
    }],
    ['/res', 'get', (res, req) => {
        let { file } = req.query
        if (fs.existsSync(file)) {
            let stream = fs.createReadStream(file);
            stream.pipe(res);
        }
    }],
    ['/', 'get', res => {
        echoJson(res, {
            "status": "success",
        });
    }],
    ['/waitFor', 'get', (res, req) => {
        let {name, data} = req
        if(name && data){
            return waitFor(name, JSON.parse(data)).then(ret => echoJson(res, ret))
        }
        echoJson(res, {"status": "error", "msg": "非法参数"});
    }],
    ['/exit', 'get', () => process.exit()],
    ['/clients', 'get', res => echoJson(res, getClients().map(({ _type, _name }) => {
        return { type: _type, name: _name }
    }))],
    ['/config', 'get', res => echoJson(res, config)],
    ['/config', 'post', (res, req) => {
        echoJson(res, Object.assign(config, req.body))
        saveConfig()
    }],
    ['/api/item/addFromPaths', 'post', (res, req) => {
        // path 必填，本地文件路径
        // name 必填，欲添加图片名
        // website 图片来源网址
        // annotation 图片注释
        // tags 图片标签
        // folderId 如果带有此参数，图片将会添加到指定文件夹
        let clients = getClients()
        if (!clients.length) return echoJson(res, { status: "error", msg: '客户端不在运行中...' });
        let data = req.body
        let items = [...(data.items || [data])].map(item => {
            item.file ??= item.path
            item.title ??= item.name
            item.desc ??= item.annotation
            delete item.path
            return item
        })
        console.log({items})
        let id = guid()
        sendMsg(clients, 'data_import', { items, id })
        echoJson(res, {
            status: "success",
            msg: '成功添加' + items.length + '个文件...',
            id
        });
    }],

    ['/importResult', 'get', (res, req) => {
        let { id } = req.query
        if (importResults[id] != undefined) {
            echoJson(res, {
                msg: '导入完成',
                added: importResults[id]
            });
        } else {
            echoJson(res, {
                msg: '任务查询中...',
            });
        }
    }],
    
    ...(() => ['tags', 'folders', 'tag_list', 'folder_list', 'client_dbs'].map(name => ['/'+name, 'get', res => waitFor(name).then(data => echoJson(res, data))]))()
])

// 等待客户端响应
function waitFor(name, data) {
    if (!data) data = { type: name }
    return new Promise(reslove => {
        let clients = getClients()
        if (!clients.length) return reslove({ status: 'error', msg: '客户端不在后台运行!' })

        // TODO 选择不同的客户端（多开库的情况下）
        sendMsg(clients[0], name, data)
        registerRevice(name, ret => {
            unregisterRevice(name)
            reslove(ret)
        })
    })
}

const importResults = {}
registerRevice('importResult', ({ id, added }) => {
    importResults[id] = added
})

console.log('服务器启动成功')

function guid() {
    return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
        var r = Math.random() * 16 | 0,
            v = c == 'x' ? r : (r & 0x3 | 0x8);
        return v.toString(16);
    });
}

function registerApi(...args) {
    const register = ([url, type, callback]) => {
        app[type](url, (req, res) => callback(res, req))
    }
    if (Array.isArray(args[0])) {
        args[0].forEach(register)
    } else {
        register(args)
    }
    return registerApi
}

function echoJson(res, data) {
    res.setHeader("Access-Control-Allow-Origin", "*");
    res.setHeader("Access-Control-Allow-Headers", "Origin, X-Requested-With, Content-Type, Accept");
    res.writeHead(200, { 'Content-Type': 'application/json' });
    res.end(JSON.stringify(data));
}

// 给ws发送消息
function sendMsg(client, type, data) {
    data = JSON.stringify({ type, data })
    toArr(client).forEach(ws => ws.send(data))
}

function toArr(arr) {
    return Array.isArray(arr) ? arr : [arr]
}


function getClients(type = 'client') {
    let ret = []
    for (let ws of wss.clients) {
        if (ws => ws._type = type) ret.push(ws)
    }
    return ret
}

function isEmpty(s, trim = false) {
    if (s === null || typeof s === 'undefined')  return true;
    if (typeof s === 'string') return (trim ? s.trim() : s).length === 0;
    return false;
}