
const fs = require('fs');
const WebSocket = require('ws');
const { spawn } = require('child_process');
 
var procs = []
const closeAll = () => {
    procs.forEach(proc => proc.kill("SIGKILL"))
    procs = []
    console.log('closeAll')
}
const formats = {
    video: {
        header: 'video/mp4',
        args: [
            // "-s", "1280x720",
            "-vcodec", "h264",
            "-acodec", "aac",
            "-movflags", "frag_keyframe+empty_moov",
            "-f", "mp4",
        ]
    },
    audio: {
        header: 'audio/mpeg',
        args: [
            "-acodec", "mp3",
            "-f", "mp3",
        ]
    },
}

const onHandle = (ws) => {
    // let type = req.route.path.replace('/', '')
    let type = 'video'
    let opts = formats[type]
    if(!opts) return
    let {file} = ''
    if(!file) file = 'I:/software/mLauncher/resources/app/bin/test.avi'
    if(!fs.existsSync(file)) return

    let args = [
        "-i", file,
        ...opts.args,
        "-preset", "fast",
        "pipe:1"
    ]
    let proc = spawn('ffmpeg', args);
    proc.stdout.on('data', (data) => {
        ws.send(data, { binary: true });
    });
    proc.stderr.on('data', (data) => {
        console.error(data.toString());
    });
    proc.on("close", () => {
        ws.close()
        closeAll()
    });
    procs.push(proc)
}

const wss = new WebSocket.Server({ port: 3000 });

wss.on('connection', function connection(ws) {
    onHandle(ws)
});
