
const fs = require('fs');
const path = require('path');
const express = require('express');
const { spawn } = require('child_process');
 
var app = express();
var procs = []

const closeAll = () => {
    procs.forEach(proc => proc.kill("SIGKILL"))
    procs = []
}
const formats = {
    video: {
        header: 'video/mp4',
        args: [
            // "-s", "1280x720",
            "-vcodec", "h264",
            "-acodec", "aac",
            "-movflags", "frag_keyframe+empty_moov",
            "-f", "mp4",
        ]
    },
    audio: {
        header: 'audio/mpeg',
        args: [
            "-acodec", "mp3",
            "-f", "mp3",
        ]
    },

}
const onHandle = (req, res) => {
    let type = req.route.path.replace('/', '')
    let opts = formats[type]
    if(!opts) return
    
    let {file} = req.query
    if(!file) file = 'I:/software/mLauncher/resources/app/bin/test.avi'
    if(!fs.existsSync(file)) return

    res.writeHead(200, {
        'Content-Type': opts.header,
        'Transfer-Encoding': 'chunked',
        'Cache-Control': 'no-cache',
        'Access-Control-Allow-Origin': '*'
    });

    let args = [
        "-i", file,
        ...opts.args,
        "-preset", "fast",
        "pipe:1"
    ]
    let proc = spawn(path.resolve(__dirname, '../../bin/ffmpeg.exe'), args);
    proc.stdout.pipe(res);
    proc.stderr.on('data', (data) => {
        // console.error(data.toString());
    });
 
    res.on("close", () => closeAll());
    procs.push(proc)
}

const echoJson = (res, data) => {
    res.setHeader("Access-Control-Allow-Origin", "*");
    res.setHeader("Access-Control-Allow-Headers", "Origin, X-Requested-With, Content-Type, Accept");
    res.writeHead(200, { 'Content-Type': 'application/json' });
    res.end(JSON.stringify(data));
}

app.get('/', (req, res) => echoJson(res, {code: 200}));
app.get('/audio', onHandle);
app.get('/video', onHandle);
 
app.listen(3001);
console.log('media server open at : http://127.0.0.1:3001')
 
