const path = require('path')
const fs = require('fs-extra')

const readJson = (file, defV = {}) => fs.existsSync(file) ? fs.readJSONSync(file) : defV

module.exports = function (inst) {
    let obj = {
        all: (db, query, args = []) => db.prepare(query).all(...args),
        config_file: __dirname + '/db.json',
        do_method(){

        },
                
        initInstances(db){
            const g_detail = {inst: {}}
            const g_plugin = require('../../public/js/plugins.js')
            const g_data = require('../../public/js/data.js')({g_plugin})
            const g_rule = require('../js/app/rule.js')
            g_data.db = db

            const g_tags = require('../../public/js/db_deepFolder.js')({
                g_plugin,g_data,g_detail,g_rule,
                name: 'tags',
                icon: 'tag',
                title: '标签',
                defaultTitle: '未命名标签',
                defaultList: [{
                    id: 0,
                    title: '默认标签',
                    icon: 'tag',
                    primary: 9999,
                    parent: '',
                    ctime: new Date().getTime()
                }],
            })
            g_tags.refresh('first')
            
            const g_folders = require('../../public/js/db_deepFolder.js')({
                g_plugin,g_data,g_detail,g_rule,
                name: 'folders',
                icon: 'folder',
                title: '目录',
                defaultTitle: '未命名文件夹',
                detailPlaceholder: '目录',
                defaultList: [{
                    id: 0,
                    title: '浏览器导入',
                    icon: 'folder',
                    primary: 9999,
                    parent: '',
                    ctime: new Date().getTime()
                }],
            })
            g_folders.refresh('first')

            g_rule.register('noFolder', {
                title: '无分组',
                sqlite: {
                    method: 'select',
                    search: 'md5',
                    table: 'files',
                    args: {noFolder: `LEFT JOIN folders_meta ON files.id=folders_meta.fid`},
                    where: {noFolder: 'folders_meta.fid IS NULL'}
                }
            })

            return {g_detail, g_plugin, g_data, g_tags, g_folders}
        },

        init() {
            // http://127.0.0.1:41597/db_fetch?db=I:/software/library/test/items.db&type=all&query=SELECT%20id%20FROM%20files
            this.methods = {
                // 请求加载db
                db_load: ({ file, opts }) => {
                    let db = this.getDB(file, opts) || this.loadDB(file, opts)
                    return ['db_load' + (db ? 'ed' : '_error'), { file, opts, inst: db }]
                },
    
                // 查询db
                db_fetch: ({ db, id, type, query, args }) => {
                    let obj = this.getDB(db)
                    if (!obj) return
                    try {
                        let ret = obj.prepare(query)[type](...args)
                        return ['db_resp', { id, ret }]
                    } catch (err) {
                        console.error(err)
                    }
                },
    
                // 执行sqlite语句
                db_exec: ({ db, id, query }) => {
                    let obj = this.getDB(db)
                    if (!obj) return
                    try {
                        let ret = obj.exec(query)
                        return ['db_resp', { id, ret }]
                    } catch (err) {
                        console.error(err)
                    }
                },
    
                // 关闭db
                db_close: ({ db }, ws) => {
                    return ['db_close', { db, ret: this.closeDB(db) }]
                },
    
                db_list: () => {
                    // TODO 返回图标icon和颜色
                    return ['db_list', this.config.db_paths]
                },
            }
            Object.entries(this.methods).forEach(([method, cb]) => {
                inst.registerApi('/'+method, 'get', (res, req) => {
                    req.query.args = JSON.parse(req.query.args || '[]')
                    let [type, data] = cb(req.query) || []
                    data && inst.echoJson(res, data)
                })
                inst.registerRevice(method, (args, ws) => {
                    let [type, data] = cb(args, ws) || []// cb
                    if(type && ws) inst.sendMsg(ws, type, data)
                    return {type, data}
                })
            })
            this.loadConfig()
            return this
        },
        // 加载配置文件
        loadConfig() {
            let config = this.config = Object.assign({
                db_paths: [],
            }, readJson(this.config_file))

            // 检查是否有过期的数据库&更新数据库信息
            Object.keys(config.db_paths).forEach(path => {
                if (fs.pathExists(path)) {
                    try {
                        return config.db_paths[path].db = readJson(path + '/db.json')
                    } catch (err) {
                        console.error(err)
                    }
                }
                delete config.db_paths[path]
            })
            this.saveConfig(config)
            return config
        },
        // 保存配置文件
        saveConfig(data) {
            return fs.writeJSONSync(this.config_file, data || this.config)
        },
        listDB() {
            return this.config.db_paths
        },
        dbs: {}, opts: {},
        // 关闭db
        closeDB(file) {
            let db = this.getDB(file)
            if (db) {
                db.close()
                delete this.dbs[file] & delete this.opts[file]
                return true
            }
        },

        instances: {}, // 其他库的接口
        getInstance(db_file, instance_names){
            let ret = {}
            let inst = this.instances[db_file]
            if(!inst) {
                this.loadDB(db_file, {type: 'library'})
                inst = this.instances[db_file]
                if(!inst) return
            }
            toArr(instance_names).forEach(name => {
                name = 'g_'+name
                if(inst[name]) ret[name] = inst[name]
            })
            return ret
        },

        getDBFile(key){
            

        },

        // 加载db文件或创建db文件
        loadDB(file, opts = {}) {
            let { base, ext, dir } = path.parse(file)
            if (ext !== '.db') return

            // let err = fs.accessSync(file, fs.constants.F_OK | fs.constants.W_OK)
            let db = require('better-sqlite3')(file, opts)
            // if (opts.type == 'library') {
                // 保存加载过的数据库信息
                this.config.db_paths[dir] = {file: base, opts}
                this.saveConfig()
                this.instances[file] = this.initInstances(db)
            // }
            this.dbs[file] = db
            this.opts[file] = opts
            return db
        },

        // 获取db
        get(file) {
            return this.dbs[file]
        },

        // 获取或创建db对象
        getDB(file, opts = {}) {
            let db = this.get(file)
            if (!db){
                if(opts) db = this.loadDB(file, opts)
            }
            return db
        },

    }
    return obj.init()
}

function toArr(v) {
    return Array.isArray(v) ? v : [v]
}


/*
        columns: {},

        // 获取db内的所有table
        async getTables(db) {
            return (await this.all(db, `SELECT * FROM sqlite_master WHERE type='table'`)).map(table => table.name).filter(table => ['sqlite_sequence'].includes(table) === false)
        },

        // 获取table的字段
        async getColumns(db) {
            let list = {};
            await Promise.all((await this.getTables(db)).map(async table => {
                list[table] = {};
                (await this.all(db, `PRAGMA table_info(${table})`)).forEach(({ name, type, notnull }) => {
                    list[table][name] = { type, notnull }
                })
            }))
            return list
        },

        db_test(){
            // 检查sqlite语句避免报错
            // let tables = self.columns[db]
            // if(tables){
            //     let [method, a, b] = query.split(' ')
            //     method = method.toLowerCase()
            //     if (['update', 'insert'].includes(method)) {
            //         let columns = tables[method == 'update' ? a : b]
            //         for(let i=0;i<args.length;i++){
            //             let item = args[i]
            //             for(let k in item){
            //                 if (!columns[k]) {
            //                     console.log('删除'+k)
            //                     delete item[k]
            //                 }
            //             }
            //         }
            //     }
            // }
        },

    */