var g_client = {
    url: 'ws://127.0.0.1:41594',
    api: 'http://127.0.0.1:41597',
    reconable: true,
    init() {
        g_client.registerRevice({
            config: data => {
                g_client.api = 'http://127.0.0.1:'+data.http_port

                g_setting.tabs.server = {
                    title: '服务器',
                    icon: 'server',
                    elements: {
                        http_port: {
                            title: '后台API端口',
                            value: data.http_port,
                        },
                        restart: {
                            title: '重启服务器',
                            type: 'html',
                            value: `<button class="btn btn-danger" onclick="g_client.reloadServer()">重启服务器</button>`
                        },
                    },
                    callback: ({vals}) => {
                        let {http_port} = vals
                        this.api_send({
                            type: 'POST',
                            url: '/config',
                            data: {http_port},
                            success: () => toast('保存成功,但可能需要重启服务器才能生效！'),
                            fail: () => toast('设置失败！', 'danger')
                        })
                    }
                }
            }
        })
        this.connect() // 先尝试链接
        this.tryStartServer()
    },
    api_send(opts){
        let {type, url, data, success, fail} = opts
        return $.ajax({
            type,
            url: this.api + url,
            data,
            dataType: "json",
            success,
            fail,
            always: console.log
        });
    },
    setConnected(b) {
        // TODO 如果是远程服务器则显示连接状态与延迟
        // getEle('channel_startServer').toggleClass('hide', b);

        // let div = removeClass($('#badge_team_status'), 'bg-')
        //     .addClass('bg-' + (b ? 'success' : 'danger'))
        //     .find('b').html(b ? '连接成功' : '连接失败');
    },
    reloadServer(){
        if(this.isConnected()) this.send('exit')
        // TODO SOCKET回调函数
    },
    tryStartServer() {
        // return;
        g_pp.setTimeout('start_server', () => {
            fetch('http://127.0.0.1:41597').then(response => response.json()).then(data => {
                if (data.status != 'success') {
                    this.startSever()
                }else{
                    this.connect()
                }
            }).catch(error => {
                this.startSever()
            });
        }, 1000)
       
    },
    startSever() {
        // return;
        // if(this.child) require('tree-kill')(this.child.pid, 'SIGKILL', () => console.log('已退出服务...'))
        this.child = nodejs.cli.run(_dataPath + '/node/node', `"${__dirname}/server/server.js"`, {
            // detached: true
        }, {
            onOutput: (msg) => {
                console.log(msg)
                if(msg == '服务器启动成功'){
                    g_client.recon()
                }
            },
            onExit: () => {
                console.log('exit')
            }
        })
    },
    recon(recon = true) {
        let self = this;
        self.reconnect && clearTimeout(self.reconnect);
        if (recon && this.reconable) {
            this.tryStartServer()
            self.reconnect = setTimeout(() => self.connect(), 1000)
        }
    },
    disconnect() {
        if (this.isConnected()) {
            this.reconable = false;
            this.connection.close();
        }
    },
    connect(url) {
        let self = this;
        if (self.connection) self.connection.close();
        let socket = self.connection = new WebSocket(url || this.url);
        socket.onopen = () => {
            g_pp.clearTimeout('start_server')
            if (!this.lastConnect) { // 初次连接

            }
            this.lastConnect = new Date().getTime()
            self.reconable = true;
            self.setConnected(true);
            self.recon(false);

            self.sendList.forEach(s => socket.send(s))
            self.sendList = []

            // 发送文件夹同步事务
            self.send('connected', {type: 'client'});
            self.ping && clearInterval(self.ping);
            self.ping = setInterval(() => self.send('ping'), 1000 * 30);
        }

        socket.onmessage = e => {
            self.onRevice(JSON.parse(e.data));
        }

        const onError = e => {
            self.setConnected(false);
            self.recon();
        }

        socket.onclose = e => onError(e);
    },

    revices: {

    },
    registerRevice(name, callback) {
        let isArr = Array.isArray(name)
        if (typeof(name) == 'object' && !isArr) {
            Object.assign(this.revices, name)
            return this
        }

        if (!isArr) name = [name];
        for (var alisa of name) this.revices[alisa] = callback;
        return this
    },
    // once(type, data, callback){
    //     this.send(type, data)
    //     this.registerRevice()
    // },
    onRevice(raw) {
        let {data, type} = raw
        this.revices[type](data);
    },

    isConnected() {
        return this.connection && this.connection.readyState == 1;
    },

    sendList: [],
    // TODO batch合并发送
    send(type, data = {}) {
        if (typeof(type) == 'object') {
            data = type;
            type = data.type;
            delete data.type;
        }
        let r = {type, data}
        // debug('send', r);
        // if(type == 'db_fetch' && data.type == 'all'){
        //     console.log(data.query)
        // }
        let s = JSON.stringify(r)
        if (!this.isConnected()) {
            this.sendList.push(s)
        } else {
            this.connection.send(s);
        }


    },



}

g_client.init();