const remote = require('@electron/remote')
const { getCurrentWindow, getCurrentWebContents } = remote;
const { contextBridge, ipcRenderer, shell, clipboard, nativeImage } = require('electron')
const fs = require('fs')
const path = require('path')
const _app = getCurrentWindow();
const _webContent = getCurrentWebContents();
const clipboardEx = require('electron-clipboard-ex')
const platform = process.platform
const dataPath = path.resolve(__dirname, '../../../').replaceAll('\\', '/') + '/'
contextBridge.exposeInMainWorld('nodejs', {
    dataPath,
    method(data) {
        let {type, msg} = data
        switch (type) {
            case 'min':
                return _app.minimize()
            case 'max':
                return _app.isMaximized() ? _app.unmaximize() : _app.maximize()
            case 'close':
                return _app.close()
            case 'openFile':
                return shell.openPath(msg.replaceAll('/', '\\'))
            case 'url':
                return shell.openExternal(msg);
            case 'reload':
                return location.reload()
            case 'copy':
                clipboard.writeText(msg)
                return toast && toast('复制成功', 'success')
            case 'toggleFullscreen':
                return _app.setFullScreen(!_app.fullScreen);
            case 'openFolder':
                return shell.showItemInFolder(msg.replaceAll('/', '\\'))
            case 'devtool':
                return _webContent.toggleDevTools()
            case 'ondragstart':
                let files = msg.files.filter(file => fs.existsSync(file))
                let icon = dataPath + 'public/files.png'
                if (files.length > 0) _webContent.startDrag({ files, icon })
                return
            default:
                return send(data);
        }
    },
    path, clipboard, remote,
    files: require('../../../public/file'),
    dir: __dirname,
    registerIPC(...args) {
        const register = ([name, cb]) => ipcRenderer.on(name, (event, args) => cb(args, event))
        if (typeof (args[0]) == 'object') {
            Object.entries(args[0]).forEach(register)
        } else {
            register(...args)
        }
    },
    writeClipboardImage(file){
        return platform == 'darwin' ? clipboardEx.putImageSync(file) : clipboard.writeHTML(`<DIV>\r\n<IMG src="file:///${file}" >\r\n</DIV>`)
    }
    
})

function send(channel, args = {}) {
    ipcRenderer.send(channel, args)
}