g_fileDrop.init()

var g_emoji = {
    toPage(to_page){
        return this.containerMethod('loadPage', {to_page})
    },
    nextPage(){
        return this.containerMethod('nextPage')
    },
    prevPage(){
        return this.containerMethod('prevPage')
    },
    containerMethod(method, ...args){
        return this.container[method].apply(this.container, args)
    },

    init() {
        nodejs.registerIPC({
            addURL: ({url}) => {

            }
        })
        
        g_hotkey.register({
            'ctrl+arrowup': {
                title: '上一页',
                content: "doAction('datalist_prevPage')",
                type: 1,
            },
            'ctrl+arrowdown': {
                title: '下一页',
                content: "doAction('datalist_nextPage')",
                type: 1,
            },
        })

        const onSelectedFolder = (dom, action, ev) => {
            if(!ev.ctrlKey && !dom.classList.contains('active')){
                getEle(action[0], '.active').removeClass('active')
            }
            dom.classList.toggle('active')

            let tags = getElementsValues(getEle('tags', '.active'), el => el.dataset.value)
            let folders =  getElementsValues(getEle('folders', '.active'), el => el.dataset.value)
            if(tags.length || folders.length){
                this.search({ tags, folders })
            }else{
                g_ui.show('homepage')
                g_ui.getElement('datalist').html('')
            }
        }

        g_action.registerAction({
            datalist_toPage: dom => this.toPage(dom.dataset.page - 1),
            datalist_nextPage: dom => this.nextPage(),
            datalist_prevPage: dom => this.prevPage(),
            datalist_listPages: () => prompt('', {title: '输入页面(1-'+ this.containerMethod(null, 'getMaxPage') +')'}).then(page => {
                if(isNaN(page *= 1) || page <= 0) return toast('错误页面', 'danger')
                this.toPage(page - 1)
            }),

            tags: onSelectedFolder,
            folders: onSelectedFolder,
            item_click: dom => nodejs.writeClipboardImage( dom.dataset.file),
            item_dbclick: dom => ipc_send('openFile', dom.dataset.file),

            dbs: () => this.listDB(),
        })

        g_style.addStyle('datalist', `
            .datalist-item img {
                padding: 20px;
            }
        `)

        g_ui.register('homepage', {
            target: '#content',
            html: `
            <div class="empty">
                <div class="empty-icon">
                    <i class="ti ti-mood-smile" style="font-size: 3rem"></i>
                </div>
                <p class="empty-title">选择标签,文件夹来查看素材</p>
                <p class="empty-subtitle text-secondary">
                可以按住ctrl进行多选操作
                </p>
            </div>
            `,
        })
        g_ui.show('homepage')

        g_ui.register('datalist', {
            target: '#content',
            html: ``,
        })
       
        this.initTags()
        this.initFolders()
        this.initDB()
        this.initDeepFolders('tags')
        this.initDeepFolders('folders')
        // this.search({folders: [5], tags: [46]})
    },

    listDB(){
        this.request('client_dbs', ret => {
            let list = {}
            Object.entries(ret).forEach(([id, {title, path}]) => list[path] = title)
            g_form.confirm1({
                id: 'dbs',
                title: '选择素材库',
                elements: {
                    db: {
                        title: '素材库列表',
                        type: 'radios',
                        list,
                        value: this.path
                    }
                },
                callback: ({vals: {db}}) => {
                   setConfig('last_db', db)
                   setTimeout(() => location.reload(), 500)
                }
            })
        })
    },

    initDeepFolders(type){
        this.request(`db_fetch?db=${this.db}&type=all&query=${encodeURI(`SELECT * FROM ${type}`)}`, ({ret}) => {
            console.log({ret})

            let html = ret.map(({id, title, icon, meta}) => {
                return `
                    <a class="btn btn-pill p-0 mb-1 ps-1 pe-1 h-fit w-full" data-action="${type}" data-value="${id}">
                        ${meta.icon ? `
                            <span class="avatar" style="background-image: url(${meta.icon})"></span>
                            ${title}
                        ` : `
                            <i class="ti ti-${icon} me-1"></i>
                            <span class="text-nowrap">${title}</span>
                        `}
                    </a>
                `
            }).join('')
            $(`#${type}_list`).html(html)
        })
    },

    search(opts){
        let {db, args = {}, where = {}} = opts
        db ??= this.db
        let path = nodejs.path.dirname(db);
        ['folders', 'tags'].forEach(type => {
            let ids = toArr(opts[type])
            if(ids.length){
                let table = type + '_meta'
                args[type] = `JOIN ${table} ON files.id = ${table}.fid`
                where[type] =  `${table}.ids like '%${g_data.arr_join(ids)}%'`
            }
        })
        let sqlite = new SQL_builder({
            method: 'select',
            search: 'id,md5,title,link',
            table: 'files',
            args, where
        })
        this.request(`db_fetch?db=${db}&type=all&query=${encodeURI(sqlite.toString())}`, ({ret}) => {
            ret.forEach(item => {
                let {md5, title} = item
                let item_path = `${path}/files/${md5.substr(0, 2)}/${md5.substr(2, 2)}/${md5}/`
                item.file = item.link || `${item_path}${title}`
                item.cover = `${item_path}cover.jpg`
            })
            this.showList(ret)
        })
    },

    showList(data){
        const self = this
        if(this.container) this.container.destory()

        const runViewMethod = (inst, method, args, type) => {
            return g_container.runViewMethod({
                type: type ?? inst.opts.type,
                method, args, inst
            })
        }
        const onPageChanged = ({to_page, max}) => {
            to_page = to_page + 1
            insertEl({ tag: 'div', text: '', props: { id: 'container_page', class: 'mx-auto'} }, { target: $('#datalist_toolbar'), method: 'prependTo' }).html(
                g_tabler.build_pageination({
                    page: to_page,
                    maxPage: max,
                    maxShow: 10,
                    action: 'datalist_toPage',
                    prevAction: 'datalist_prevPage',
                    nextAction: 'datalist_nextPage',
                    moreAction: 'datalist_listPages',
                })
            )
        }
        this.container = g_container.build('datalist', {
            type: 'default',
            hideFooter: true,
            hideHeader: true,
            page_info: { pagePre: 100},
            onPageChanged,
            itemClass: 'datalist-item',
            // itemClass: 'fade-in',
            style: 'height: calc(100vh - 60px)',
            target: '.ui[data-name="datalist"]',
            containerHTML: `
                <div class="{class} datalist-items" style="{style}" {props}>{html}</div>
                <div id="datalist_toolbar" class="d-flex">
                
                </div>
            `,
            onInsertedItems: data => g_plugin.callEvent('datalist_insertedItems', data),
            async initItemData(item, index){},
            onSetWidth(val, div) {},
            async onInitItems(){},
            onClearItems: () => $('#container_page').remove(),
            getPage({ start, end }) {
                let items = []
                return new Promise(async reslove => {
                    for (let i = start; i < end; i++) {
                        items.push(this.getItem(i))
                    }
                    reslove(items)
                })
            },
            async parseItem({ item, type, newWidth, newHeight }, index) {
                type ??= this.opts.type
                let props = `class="${type == 'table' ? 'container-sizer' : ''}" data-mousedown="item_click" data-dbclick="item_dbclick" {md5} {dargable}`
                return self.initElementHTML(runViewMethod(this, 'parseItem', {item, props, desc: '', index, r: [true], newWidth, newHeight}), item)
            },
            items: []
        })

        this.container.setItems([...data], true)
        g_ui.show('datalist')
    },


    
    // 替换html的一些变量
    initElementHTML(html, {file, md5, id, cover}){
        return html
            .replace('{dargable}', !isEmpty(file) && !file.startsWith('http') ? ` data-file="${file}" draggable="true"` : '').
            replace('{preview}', 'data-hover="item_preview" data-out="item_unpreview" data-hoverTime="300"').
            replace('{md5}', `data-md5="${md5}" data-fid="${id}"`).
            replace('{cover}', cover).
            replace('{file}', file)
    },

    request(url, success){
        return ajax_request({url: 'http://127.0.0.1:41597/'+url, success, timeout: 3000})
    },

    initDB(){
        let path = this.path = getConfig('last_db')
        if(!path){
            this.listDB()
        }else{
            this.db = path + '/items.db'
            getEle('dbs').find('span').html(getPathName(path))
        }
        // this.db = 'I:/software/library/影视/items.db'
    },

    initFolders(){
        let html = `
        
        <div>
            <span class="badge bg-primary-lt d-flex" data-action="dbs">
                <i class="ti ti-box me-1 fs-4"></i>
                <span>选择素材库</span>
            </span>
        </div>
        <div class="d-flex p-1 scroll-x hideScroll me-auto" id="folders_list">
            ${(() => new Array(10).fill().map((_,i) => `
                <a class="btn btn-pill p-2">
                    <span class="avatar" style="background-image: url(downloads/29532.png)"></span> spy
                </a>
            `))().join('')}
        </div>`
        $(html).prependTo('header')
    },

    initTags(){
        g_sidebar.register('left', {
            html: `
                <div class="d-flex flex-wrap align-content-start h-full ps-2 pe-2 border-end overflow-y hideScroll"  id="tags_list">
                    ${(() => new Array(10).fill().map((_,i) => `
                        <a class="btn btn-pill p-0 mb-1 ps-1 pe-1 h-fit">
                            <i class="ti ti-tag me-1"></i>
                            <span>tag${i}</span>
                        </a>
                    `))().join('')}
                </div>
            `,
            onShow: e => setCssVar('--offset-left', (g_sizeable.data?.sidebarLeft?.width || 100) + 'px'),
            onHide: e => setCssVar('--offset-left', '0px')
        })
    },
}

g_emoji.init()

