// ==UserScript==
// @name        表情包
// @namespace   12cb857a-ec08-40bb-9a43-8bda90e40397
// @version     0.0.1
// @author      hunmer
// @description 注释说明
// @updateURL               
// @primary     1
// ==/UserScript==

({
    path: g_plugin.getSciptPath() + '表情包/',
    init(){
        g_hotkey.register({
            'ctrl+keym': {
                title: '呼出小窗',
                content: "doAction('test_toggle')",
                type: 1,
            },
        })

        $(`
            <div data-action="sticker_download">
                <i class="ti ti-download fs-2"></i>
            </div>
        `).prependTo('#traffic .traffic_icons')

        g_action.registerAction({
            test_toggle: () => this.toggleShow(),
            sticker_download: () => prompt('', {title: '输入贴图地址'}).then(url => {
                if(!isEmpty(url)) this.sticker_api({type: 'download', url})
            })
        })
        
        // this.createWindow()
        // this.sticker_api({type: 'download', url: 'https://store.line.me/stickershop/product/1312/en'})
    },
    isShowing(){

    },
    toggleShow(show){
        show ??= !this.isShowing()
        if(show && !this.win) return this.createWindow()

    },
    createWindow(){
        if(this.win && !this.win.isDestroyed()) this.win.destroy()
        const path = this.path
        const win = this.win = new nodejs.remote.BrowserWindow({
            width: 700,
            height: 700,
            frame: false,
            alwaysOnTop: false,
            skipTaskbar: false,
            webPreferences: {
                nodeIntegration: true,
                contextIsolation: true,
                preload: path + 'preload.js',
            }
        })
        win.loadFile(path + 'index.html')
        const contents = win.webContents
        nodejs.require("@electron/remote/main").enable(contents)
        contents.on('dom-ready', e => {
            // contents.openDevTools()
            Object.entries(this.msglist).forEach(([k, v]) => this.sendMsg(k, v))
            this.msglist = {}
        })
        contents.on('ipc-message', (e, channel, ...args) => {
            switch (channel) {
                case 'exit':
                    return win.close()
            }
        });
    },
    msglist: {}, // 待发送的消息队列
    async sendMsg(k, v){
        if(!this.win || this.win.isDestroyed() || !(await this.isAlive())){
            this.msglist[k] = v
            return this.createWindow()
        }
        this.win.webContents.send(k, v)
    },

    sites: {
        line: {
            match: url => new RegExp('https://store.line.me/stickershop/product/*[^\s]*').test(url),
            search: str => {
                // 'https://store.line.me/api/search/sticker?query=' . urlencode(getParam('s')) . '&offset=0&limit=36&type=ALL&includeFacets=true';
            },
            download: url => {
                let fid = cutString(url + '/', '/product/', '/')
                return new Promise(async reslove => {
                    toast('正在解析...')
                    downloadFile({
                        url: `https://sdl-stickershop.line.naver.jp/products/0/0/1/${fid}/android/productInfo.meta`,
                        proxy: await nodejs.files.getProxy(),
                        complete: data => {
                            try {
                                let {title, author, stickers, hasAnimation, hasSound} = JSON.parse(data)
                                reslove({folder: title, items: stickers.map(({id}) => {
                                    return {
                                        url: `http://dl.stickershop.line.naver.jp/products/0/0/1/${fid}/android/stickers/${id}.png`,
                                        animation: hasAnimation ? `http://dl.stickershop.line.naver.jp/products/0/0/1/${fid}/android/animation/${id}.png` : undefined,
                                        sound: hasSound ? `http://dl.stickershop.line.naver.jp/products/0/0/1/${fid}/android/sound/${id}.m4a` : undefined,
                                        title: id,
                                    }
                                }), icon: `https://sdl-stickershop.line.naver.jp/products/0/0/1/${fid}/android/main.png`})
                            } catch(err){
                                toast('解析数据错误', 'danger')
                            }
                        }
                    })
                })
            }
        }
    },

    sticker_api({type, url}){
        let [site, methods] = Object.entries(this.sites).find(([site, {match}]) => match(url)) || []
        if(!site) return

        let data
        switch(type){
            case 'search':
                 data = methods.search(keyword)
                console.log(data)
                return

            case 'download':
                return methods.download(url).then(async ({folder, items}) => {
                    let proxy = await nodejs.files.getProxy()
                    const startDownload = () => {
                        arrayQueue(items, ({url, title, animation}) => {
                            return new Promise(reslove => {
                                toast('剩余图片...'+items.length)
                                let saveTo = nodejs.dir + '/cache/sticker_download/' + title + '.' + ( animation ? 'gif' : 'png')
                                downloadFile({
                                    url: animation || url, saveTo, proxy,
                                    complete: () => reslove({file: saveTo, importType: 'move', meta: {folders: folder}}),
                                })
                            })
                        }, list => g_data.file_revice(list), undefined, 3)
                    }

                    if(typeof(folder) == 'object'){
                        g_form.confirm1({
                            title: '选择保存的文件夹名称',
                            id: 'sticker_setFolder',
                            elements: {
                                select: {
                                    type: 'select',
                                    list: Object.values(folder),
                                    props: `onchange="g_form.getInput('sticker_setFolder', 'folder').val(this.value)"`,
                                },
                                folder: {
                                    title: '文件夹',
                                    required: true,
                                }
                            },
                            callback: ({vals}) => {
                                folder = vals.folder
                                startDownload()
                            }
                        })
                    }else{
                        startDownload()
                    }
                })

        }
    }
}).init()