// ==UserScript==
// @name        简易图片标注
// @namespace   3b5f39c8-b4c4-40d0-876b-ed2e193f79f8
// @version     0.0.1
// @author      hunmer
// @description 给图片添加多边形/文字标注
// @updateURL               
// @primary     1
// ==/UserScript==

// 创建矩形时，按住鼠标左键拖动完成创建。
// 创建多边形时，鼠标左键单击添加点，双击闭合完成创建，Escape退出创建，Backspace退一步删除选择点。
// 创建折线时，鼠标左键单击添加点，双击完成创建，Escape退出创建，Backspace退一步删除选择点。
// 按住鼠标右键拖动画布。
// 鼠标滚轮缩放画布。
// 选中形状，Backspace删除。

({
    init() {

        g_preload.register('canvas-select', {
            list: ['https://unpkg.com/canvas-select@^2/lib/canvas-select.min.js'],
            // list: [g_plugin.getSciptPath() + '简易图片标注/canvas-select.min.js'],
            check: () => typeof (tinyMCE) != 'undefined'
        })

        g_plugin.registerEvent('item_fullPreviewed', ({ data }) => {
            if (getFileType(data.file) != 'image') return

            $(`
                <a class="btn" data-action="cs,show" title="切换图片标注">
                    <i class="ti ti-pencil"></i>
                </a>
            
            `).prependTo('#fullPreview_header > .ms-auto')
            if(getConfig('cs_autoEnable') && this.getData(g_preview.previewing.data.md5).data){
                setTimeout(() => doAction('cs,show'), 1000)
            }
        })

        Object.assign(g_setting.tabs.sample.elements, {
            cs_autoEnable: {
                title: '预览图片自动进入标注模式',
                type: 'switch',
                value: () => getConfig('cs_autoEnable')
            },
        })

        g_action.registerAction('cs', (dom, action, ev) => {
            let instance = this.instance
            switch (action[1]) {
                case '-1':
                case '1':
                case '2':
                case '3':
                case '4':
                case '5':
                    $('#cs_btnList .btn.active').removeClass('active')
                    getEle('cs,' + action[1]).addClass('active')
                    return instance.createType = parseInt(action[1]);
                case 'zoomIn':
                    return instance.setScale(true)
                case 'zoomOut':
                    return instance.setScale(false)
                case 'full':
                    return instance.fitZoom()
                case 'label':
                    return prompt(this.selected.label, { title: '编辑注释' }).then(text => {
                        // TODO 属性编辑面板
                        this.selected.label = text
                        instance.update()
                    })
                case 'delete':
                    return instance.deleteByIndex(this.selected.index) & this.onSelected()
                case 'toggle':
                    return instance.setFocusMode(!instance.focusMode);
                case 'show':
                    let { file, md5 } = g_preview.previewing.data
                    return this.load({ file, md5, remove: $('#canvas-select').length })
            }
        })
    },

    toggleViewer(hide) {
        let modal = g_modal.getModal('fullPreview')
        modal.find('.viewer-container').toggleClass('hide', hide)
        return modal
    },

    getSaveTo(md5) {
        return g_db.getSaveTo(md5) + '_shapes_.json'
    },

    getData(md5){
        let data
        let saveTo = this.getSaveTo(md5)
        if(nodejs.files.exists(saveTo)) data = nodejs.fs.readJSONSync(saveTo)
        return {saveTo, data}
    },

    onSelected(item) {
        $(getEle('cs,label'), getEle('cs,delete')).toggleClass('hide', item == undefined)
        this.selected = item
    },

    load({ file, md5, remove = false }) {
        g_preload.check('canvas-select', () => {
            let modal = this.toggleViewer(!remove)
            let div = insertEl({
                tag: 'div', text: `
                <canvas class="w-full" id="canvas-select" style="height: calc(100% - 50px);"></canvas>
                <div class="d-flex w-full me-2" style="height: 50px;">
                    <div class="ms-auto" id="cs_btnList">
                        ${[['hand-stop', '查看', -1], ['rectangle', '四边形', 1], ['lasso-polygon', '自由选区', 2], ['circle-dot', '圆形', 3], ['line', '线', 4], ['circle', '圆形', 5], ['text-size', '注释', 'label'], ['zoom-in', '放大', 'zoomIn'], ['zoom-out', '缩小', 'zoomOut'], ['arrow-autofit-width', '填满屏幕', 'full'], ['eye', '切换标注', 'toggle'], ['trash', '删除', 'delete', 'text-danger']].map(([icon, title, action, classes = '']) => `
                            <button class="btn ${classes}" title="${title}" data-action="cs,${action}">
                                <i class="ti ti-${icon}"></i>
                            </button>
                        `).join('')}
                    </div>
                </div>
            `, props: { id: 'cs_div', class: 'w-full' }
            }, { target: modal.find('.modal-body'), method: 'prependTo', remove })

            if (remove) {
                return this.instance && this.instance.destroy()
            }
            let {saveTo, data} =  this.getData(md5)
            const instance = this.instance = new CanvasSelect($('#canvas-select')[0], file)
            
            instance.on("select", info => this.onSelected(info))
            instance.on("load", src => instance.fitZoom() & (data && instance.setData(data)))
            // instance.on("add", info => {});
            // instance.on("delete", info => {});
            instance.on("updated", result => {
                let active = result.find(({active}) => active)
                let str = JSON.stringify(result)
                nodejs.files[str == '[]' ? 'remove' : 'write'](saveTo, str)
                if(!active) this.onSelected() // 取消选中事件
            });
            this.onSelected()
        })
    }


}).init()