// ==UserScript==
// @name        新标签页预览图片
// @namespace   7523fd18-7ece-4672-b7d4-c5bf7febfe06
// @version     0.0.1
// @author      hunmer
// @description 替换全屏预览图片选项
// @updateURL               
// @primary     1
// ==/UserScript==

({
    init(){
        // 初始化tab
        g_container.reigsterPreset('item_preview', {html: opts => {
            this.preview(opts.name)
            return ''
        }})

        // tab切换
        g_plugin.registerEvent('datalist.tabChanged', ({ tab }) => this.preview(tab))

        // 全屏预览后
        g_plugin.registerEvent('item_fullPreviewed', ({ modal, data }) => {
            let content = g_datalist.tab_getContent('itemPreview_'+data.md5)
            content.length && modal.appendTo(content).css({position: 'sticky'})

            // 更新侧边信息
            g_detail.showList([data.md5], {
                sqlite: g_datalist.getTabData(({data}) => data.type == 'all')[0]?.data?.sqlite || new SQL_builder(g_rule.list.all.sqlite)
            })
        })

        // 全屏预览前
        g_plugin.registerEvent('item_fullPreview', ret => {
            if(!ret.opts.asTab){ // 非通过插件开启，创建新标签页并取消事件
                g_datalist.tab_new({
                    id: 'itemPreview_'+ret.md5, icon: 'eye', title: ret.data.title,
                    sqlite: undefined,
                    data: { view: 'item_preview', ...ret.data },
                })
                ret.html = ''
                return false
            }
        })

        // 取消预览一同关闭标签页
        g_plugin.registerEvent('item_unFullPreview', ({md5}) => g_datalist.tab_remove('itemPreview_'+md5))
    },

    preview(tab){
        g_pp.setTimeout('preview', () => {
            let tabData = g_datalist.tabs.getData(tab)
            if(tabData && tabData.data.view == 'item_preview'){
                let {md5} = tabData.data || {}
                md5 && g_preview.fullPreview({ md5, opts: {asTab: true} })
            }
        }, 200)
    },
}).init()