const express = require('../../server/node_modules/express')
const request = require('../../node_modules/request')
const bodyParser = require('../../server/node_modules/body-parser');

function echoJson(res, data) {
    res.setHeader("Access-Control-Allow-Origin", "*")
    res.setHeader("Access-Control-Allow-Headers", "Origin, X-Requested-With, Content-Type, Accept")
    res.writeHead(200, { 'Content-Type': 'application/json' })
    if(typeof(data) == 'object') data = JSON.stringify(data)
    res.end(data)
}

function createHTTPServer(port, data) {
    let app = express()
    app.listen(port)
    app.use(bodyParser.json({ limit: '50mb' }));
    app.use(bodyParser.urlencoded({ limit: '50mb', extended: true }));
    data.forEach(([url, type, callback]) => app[type](url, callback))
}

function httpRequest(opts, data) {
    return new Promise(reslove => {
        if (typeof (opts) == 'string') opts = { url: opts }
        if (typeof (data) == 'object') data = JSON.stringify(data)
        opts = Object.assign({ headers: {} }, opts)
        if (data) {
            opts.headers['Content-Type'] = 'application/json'
            opts.method = 'POST'
            opts.body = data
        }
        request(opts, (error, response, body) => reslove(body))
    })
}

const getInfomation = () => {
    return {
        "version": "3.0.0",
        "prereleaseVersion": null,
        "buildVersion": "20231101",
        "showCollectModal": false,
        "platform": "win32",
        "preferences": {
            "general": {
                "zoom": "100",
                "language": "zh_CN",
                "showMenuItem": "true",
                "showSidebarBadge": "true",
                "autoSelect": "true",
                "showCollectModal": "false",
                "showCaptureCollectModal": "false",
                "IPTC": "false",
                "enableGPU": "true"
            },
            "habits": {
                "dblclickSidebarItem": "collapse",
                "scrollBehavior": "scroll",
                "videoScrollBehavior": "progress",
                "hoverZoom": "on",
                "scrollBehaviorTour": false,
                "renderBehavior": "non-pixelated",
                "defaultMode": "preview",
                "rememberLastZoom": "on",
                "defaultRatio": "auto",
                "transparency": "hide",
                "keyspace": "preview",
                "middleBtn": "openNewWindow",
                "doubleclick": "internal",
                "gifViewer": "off",
                "alwaysPlayGIF": "off"
            },
            "shortcuts": {
                "keybinds": {
                    "show.eagle": "",
                    "show.search": "",
                    "zoom.in": "Ctrl + =",
                    "zoom.out": "Ctrl + -",
                    "zoom.actual": "Ctrl + 0",
                    "zoom.fit": "Ctrl + 9",
                    "capture.area": "Ctrl + Alt + E",
                    "capture.window": "",
                    "capture.full": "",
                    "quicksearch": "Ctrl + J",
                    "add.to": "Ctrl + Shift + J",
                    "create.folder": "Ctrl + Shift + N",
                    "create.smartFolder": "Ctrl + Shift + Alt + N",
                    "import.pinterest": "Ctrl + Shift + Alt + P",
                    "import.huaban": "Ctrl + Shift + Alt + H",
                    "import.artstation": "Ctrl + Shift + Alt + S",
                    "open.link": "Ctrl + Shift + O",
                    "toggle.filter": "Ctrl+Shift+F",
                    "open.tagfilter": "Ctrl+Shift+T",
                    "switch.library": "Ctrl+L"
                }
            },
            "theme": {
                "name": "BLUE",
                "color": "#303342",
                "css": "blue",
                "$$hashKey": "object:23"
            },
            "download": {
                "queueLength": 5
            },
            "notification": {
                "soundEffect": {
                    "enable": "true",
                    "when": {
                        "deleteImage": "true",
                        "deleteFolder": "true",
                        "screencapture": "true",
                        "extension": "true"
                    }
                },
                "notification": {
                    "when": {
                        "screencapture": "true",
                        "extension": "true",
                        "repeatImage": "true",
                        "autoImport": "true"
                    }
                }
            },
            "sidebar": {
                "untagged": "true",
                "unfiled": "true",
                "recent": "true",
                "random": "true",
                "community2": "true",
                "quickAccess": "true",
                "smartFolder": "true",
                "folder": "true"
            },
            "screencapture": {
                "autoTagging": {
                    "enable": "true"
                },
                "autoWriteClipboard": "false",
                "useRetina": "true",
                "shortcutsEnable": "true",
                "format": "png",
                "quality": "90"
            },
            "video": {
                "hoverPlay": "true",
                "zoomFill": "false",
                "autoPlay": "true",
                "rememberPosition": "true",
                "loopShortVideo": "true"
            },
            "font": {
                "autoTag": "true"
            },
            "proxy": {
                "enable": "false",
                "ip": "127.0.0.1",
                "port": 1087
            },
            "privacy": {
                "enable": "false",
                "password": "",
                "passwordTips": ""
            },
            "autoImport": {
                "enable": "false",
                "path": ""
            },
            "developer": {
                "apiToken": "3f0b58a7-a8a6-4652-8e12-5a6ad45bc77d"
            }
        }
    }
}

createHTTPServer(41595, [
    ['/', 'get', (req, res) => echoJson(res, getInfomation())],
    ['/api/folder/create', 'post', (req, res) => {
        httpRequest('http://127.0.0.1:41597/api/folder/create', req.body).then(data => {
            echoJson(res, data || { code: 'error' })
        })
    }],
    ['/api/item/addFromURLs', 'post', (req, res) => {
        let {folderId, items} = req.body
        httpRequest('http://127.0.0.1:41597/api/item/addFromPaths', {items: items.map(({name, url, website, modificationTime}) => {
            return {file: url, title: name, meta: {url: website, folders: [folderId], date: modificationTime}}
        })}).then(data => {
            echoJson(res, data ||{ code: 'error' })
        })
    }],
    ['/api/folder/listRecent', 'get', (req, res) => {
        httpRequest('http://127.0.0.1:41597/api/folder/listRecent').then(data => {
            echoJson(res, data ||{ code: 'error' })
        })
    }]
])

createHTTPServer(41593, [
    ['/', 'get', (req, res) => echoJson(res, getInfomation())],
    ['/exit', 'get', () => process.exit()],
    ['/', 'post', (req, res) => {
        if (req.body && ['image', 'screen capture', 'save-url'].includes(req.body.type)) {
            let { metaTags, metaDescription, metaPicture, src, url, title, folderID, version, base64 } = req.body

            let folders = []
            if (folderID) folders.push(folderID)
            httpRequest('http://127.0.0.1:41597/api/item/addFromPaths', {
                file: base64 || src,
                title: Date.now().toString(),
                meta: {
                    url, tags: metaTags, folders, desc: metaDescription,
                }
            }).then(console.log)
        }
        echoJson(res, getInfomation())
    }],
])

console.log('eagle后台服务成功开启!')