// ==UserScript==
// @name        eagle插件支持
// @namespace   2e372d1a-cfdf-4476-8036-2f4bf12d2b60
// @version     0.0.1
// @author      hunmer
// @description 支持加载eagleplugin
// @updateURL               
// @primary     1
// ==/UserScript==
const _path = g_plugin.getSciptPath() + 'eagle/'

const addToLibrary = (file, data) => {
    let { name, website, tags, folders, annotation, importType } = data
    return new Promise(reslove => {
        g_data.file_revice([{
            file,
            importType,
            title: name,
            meta: {
                url: website,
                tags,
                folders,
                desc: annotation
            }
        }]).then(({ added }) => added.length && reslove(added[0].md5))
    })
}

const eagle = {
    folder: {
        // 建立文件夾
        async create({ name, description, parent }) {
            parent ??= '' // TODO 支持undefined
            let id = g_folders.folder_add({ title: name, desc: description, parent })
            return g_folders.get(id)
        },
        // 建立子文件夾
        async createSubfolder(parent, { name, description }) {
            return await this.create({ name, description, parent })
        },
        // 获取指定条件的文件夹。
        async get(args) {
            return g_folders.list.filter(item => {
                return Object.entries(args).every(([k, v]) => {
                    let ok
                    let id = String(item.id)
                    switch (k) {
                        case 'id':
                            ok = id == v
                            break
                        case 'ids':
                            ok = v.includes(id)
                            break
                        // TODO
                        case 'isSelected':
                        case 'isRent':
                            break
                    }
                    return ok
                })
            })
        },
        // 获取所有文件夹。
        async getAll() {
            return g_folders.list
        },
        // 获取对应 folderId 的文件夹。
        async getById(folderId) {
            let data = g_folders.get(folderId)
            if (data) return data
            return await this.create({ name: 'New Folder', description: `Folder's description.` })
        },
        // 获取对应 folderIds 的文件夹数组。
        async getByIds(folderIds) {
            let ret = []
            folderIds.forEach(id => {
                let data = g_folders.get(id)
                if (data != undefined) ret.push(data)
            })
            return ret
        },
        // 获取当前应用选中的文件夹
        async getSelected() {
            // TODO
            return []
        },
        // 获取最近使用的的文件夹
        async getRecents() {
            // TODO 排序
            return this.getAll()
        },
        // 打开对应 folderId文件夹。
        async open(folderId) {
            g_folders.showFolder(folderId)
        },
        async save({id, name, description}){
            g_folders.set(id, {title: name, desc: description})
            return g_folders.get(id)
        }
    },
    item: {
        // 获取指定条件的文件
        async get(args) {
            let keys = Object.keys(args)
            if(!keys.length) return []
            let selected = g_detail.getSelectedKeys()
            let ret = []
            await Promise.all((await g_data.all(`SELECT * FROM files`)).map(async item => {
                const get = async (k, defV) => {
                    if (!item.meta) item.meta = await g_detail.getDetail(await g_data.data_get(md5))
                    return getObjVal(item.meta, k, defV)
                }
                for (let k of keys) {
                    let v = args[k]
                    let ok
                    switch (k) {
                        case 'id':
                            ok = item.md5 == v
                            break
                        case 'ids':
                            ok = v.includes(item.md5)
                            break
                        case 'isSelected':
                            ok = selected.includes(item.md5)
                            break
                        case 'isUntagged':
                            ok = await get('tags').length == 0
                            break
                        case 'isUnfiled':
                            ok = await get('folders').length == 0
                            break
                        case 'keywords':
                            ok = v.some(str => item.title.includes(str))
                            break
                        case 'tags':
                        case 'folders':
                            ok = arr_include(v, await get(k))
                            break
                        case 'ext':
                            ok = getExtName(item.title) == v
                            break
                        case 'annotation':
                            ok = await get('desc') == v
                            break
                        case 'rating':
                            ok = await get('score') == v
                            break
                        case 'url':
                            ok = await get(k) == v
                            break
                        case 'shape':
                            let list = { square: 1, portrait: 3 / 4, 'panoramic-portrait': 1 / 3, landscape: 4 / 3, 'panoramic-landscape': 3 / 1 }
                            ok = list[k] == await get('media.width') / await get('media.height')
                            break
                    }
                    if (!ok) return
                }
                ret.push(item)
            }))
            return ret

        },
        // 返回所有文件
        async getAll() {
            return await Promise.all(await g_data.all(`SELECT * FROM files`))
        },
        // 返回指定 ID 之文件
        async getById(itemId) {
            let data = await g_data.data_get(itemId)
            if (data) {
                return data
            }
        },
        // 返回指定 IDs 之文件
        getByIds(itemIds) {
            return new Promise(reslove => {
                arrayQueue(itemIds, itemId => this.getById(itemId), reslove)
            })
        },
        // 返回应用当前选中的文件
        async getSelected() {
            // return Promise.all(['c7d8fdfa92427dbb1920a15903fecbd3'].map(md5 => g_data.data_get(md5)))
            return Promise.all(await g_detail.getSelectedItems())
        },
        // 将图片链接添加
        addFromURL(...args){
            return addToLibrary.apply(this, args)
        },
        // 添加 base64 图像
        addFromBase64(...args){
            return addToLibrary.apply(this, args)
        },
        // 从本地文件路径添加文件
        addFromPath(...args){
            return addToLibrary.apply(this, args)
        },
        // 添加书签链接
        addBookmark(url, options) {
            let file = nodejs.dir + '/cache/bookmark/' + options.name + '.url'
            nodejs.files.write(file, `[InternetShortcut]\r\nURL=${url}`)
            return this.addFromPath(file, { ...options, importType: 'move' })
        },
        // 在全部列表显示 itemId 对应的文件
        open(itemId) {
            // TODO 
        },
        async save({id, name, annotation, url, height, width, tags, folders, star, ext}){
            let fid = await g_data.data_getID(id)
            console.log({id, fid})
            if(fid){
                g_detail.inst.desc.set(fid, annotation)
                g_detail.inst.url.set(fid, url)
                g_detail.inst.score.set(fid, star)
                g_detail.inst.media.set(fid, {width, height})
                g_tags.setItemFolder(fid, tags)
                g_tags.setItemFolder(fid, folders)
                await g_data.data_set(id, {title: name + '.' + ext})
            }
            return {id}
        }
    }
}

var g_eagle = {
    init() {
        this.data = local_readJson('eagle_plugins', {})
        $(`
            <div data-target-dropdown="dropdown_eagle">
                <i class="ti ti-plug-connected fs-2"></i>
            </div>
       `).prependTo('#traffic .traffic_icons')

        // this.checkPlugin('I:/eagle_plugins/test', true)
        // setTimeout(() => this.checkPlugin('C:/Users/31540/AppData/Roaming/Eagle/eagle-temp/图片裁切大师.eagleplugin', true), 1000)

        Object.entries(process.env).forEach(([k, v]) => {
            if (k.startsWith('eagle_')) {
                let id = k.substring(6)
                v = parseInt(v)
                if(isNaN(v)) return
                let _win = nodejs.remote.BrowserWindow.fromId(v)
                if (!_win || win.isDestroyed()) {
                    return delete process.env[k]
                }
                this.windows[id] = _win
            }
        })
        console.log(this.windows)

        g_action.registerAction({
            eagleplugin: (dom, action) => {
                let path = getParentData(dom, 'path')
                switch (action[1]) {
                    case 'open':
                        // this.callEvent({ type: 'onPluginRun' })
                        return this.checkPlugin(path, true)
                }
            },
            eagleplugin_import: async () => {
                let isFile =  await confirm('导入eagleplugin插件还是未打包的插件?', {btn_ok: 'eagleplugin插件', btn_cancel: '未打包的插件'})
                openFileDiaglog({
                    title: '选择',
                    properties: [isFile ? 'openFile' : 'openDirectory'],
                    filters: [
                        isFile ? { name: 'eagle插件', extensions: ['eagleplugin'] } : {},
                    ],
                }, path => {
                    console.log(path[0])
                })
            },
            eagleplugin_refresh: async () => {
              let list = await nodejs.files.dirFiles(nodejs.remote.app.getPath('appData') + '/Eagle/eagle-temp/', ['eagleplugin'])
              arrayQueue(list, path => this.addPlugin(path), ret => toast('成功添加了'+ ret.length+'个插件!', 'success'))
            },
        })

        g_dropdown.register('dropdown_eagle', {
            position: 'end-top',
            offsetLeft: 5,
            autoClose: 'true',
            list: () => {
                let list = {}
                Object.entries(this.data).forEach(([path, {title, version}]) => {
                    let src = path.endsWith('.eagleplugin') ? path.replace('.eagleplugin', '') : path
                    list[path] = {
                        html: `
                            <div class="row p-2 m-0" data-path="${path}">
                                <div class="col-auto">
                                    <a href="#">
                                        <span class="avatar" style="background-image: url(${formatBackgroundURL(src+'/logo.png')})"></span>
                                    </a>
                                </div>
                                <div class="col text-truncate">
                                    <a href="#" class="text-body d-block" data-action="eagleplugin,open">${title}</a>
                                    <div class="text-secondary text-truncate mt-n1">${version}</div>
                                </div>
                            </div>
                        
                        `,
                    }
                })
      
                return Object.assign({
                    import: {
                        title: '导入插件',
                        action: 'eagleplugin_import',
                    },
                    refresh: {
                        title: '刷新插件',
                        action: 'eagleplugin_refresh',
                    },
                    drive: {
                        type: 'divider'
                    },
                }, list)
            },
        })
    },

    async addPlugin(path){
        let md5 = nodejs.files.isFile(path) ? nodejs.files.getFileMd5(path) : undefined
        let src = await this.checkPlugin(path, false, md5)
        if(src !== false){
            console.log(src)
            try {
                let {id, version, main} = nodejs.fs.readJSONSync(src + '/manifest.json')

                nodejs.files.write(src+'/md5.txt', md5) // 最后同步eagleplugin md5
                let index = src+'/'+main.url
                nodejs.files.write(index, nodejs.files.read(index).replace('<head>', `<head><script type="text/javascript" src="${_path+'api.js'}"></script>`))

                let title = getFileName(path, false)
                this.data[path] = {title, md5, version}
                this.save()
                return id
            } catch(err){
                console.error(err)
            }
        }
        return false
    },

    checkPlugin(path, load, md5){
        return new Promise(reslove => {
            const done = path => {
                load && this.loadPlugin({ path })
                reslove(path)
            }

            let isDir = nodejs.files.isDir(path)
            if (isDir) return done(path)

            let {  dir, ext, name } = nodejs.path.parse(path)
            if (ext == '.eagleplugin') {
                let tempDir = dir + '/' + name + '/'
                if(nodejs.files.isDir(tempDir)){
                    if(md5 && nodejs.files.read(tempDir + 'md5.txt') !== md5){
                        console.log('需要更新!')
                    }else{
                        return done(tempDir)
                    }
                }
                unZip({
                    input: path, output: tempDir,
                    check: entry => entry.type == 'File' && entry.path == 'manifest.json'
                }, () => done(tempDir), err => toast(err, 'danger') & console.error(err) & reslove(false))
            }else{
                reslove(false)
            }
        })
    },

    save(){
        local_saveJson('eagle_plugins', this.data)
    },

    windows: {},
    async loadPlugin({ path }) {
        let manifest = nodejs.fs.readJSONSync(path + '/manifest.json')
        if (!manifest) return

        let { id, main } = manifest
        const callEvent = (type, data) => this.callEvent(id, type, data)
        const win = new nodejs.remote.BrowserWindow({
            ...{
                width: 700,
                height: 700,
                frame: false,
                title: nodejs.path.basename(path),
                icon: path + '/logo.png',
                alwaysOnTop: false,
                skipTaskbar: false,
                webPreferences: {
                    preload: _path + 'preload.js',
                    nodeIntegration: true,
                    contextIsolation: false,
                    additionalArguments: [
                        'manifest', JSON.stringify(manifest),
                        'path', path,
                        'scriptPath', _path,
                        'library', g_db.opts.path
                    ]
                }
                , ...main
            }
        })
        this.windows[id] = win
        const contents = win.webContents
        process.env['eagle_'+id] = win.id
        nodejs.require("@electron/remote/main").enable(contents)

        win.loadFile(path + '/index.html')
        win.on('show', () => callEvent('onPluginShow'))
        win.on('hide', () => callEvent('onPluginHide'))
        contents.on('dom-ready', e => {
            manifest.devTools && 
            contents.openDevTools()
        })

        contents.on('ipc-message', (e, channel, args) => {
            switch (channel) {
                case 'getItemDetail':
                    return g_data.data_get(args).then(async data => {
                        callEvent('getItemDetail', await g_detail.getDetail(data))
                    })
                case 'folder.create':
                case 'folder.createSubfolder':
                case 'folder.get':
                case 'folder.getAll':
                case 'folder.getById':
                case 'folder.getByIds':
                case 'folder.getSelected':
                case 'folder.getRecents':
                case 'folder.open':
                case 'folder.get':
                case 'item.get':
                case 'item.getAll':
                case 'item.getById':
                case 'item.getByIds':
                case 'item.getSelected':
                case 'item.addFromURL':
                case 'item.addFromBase64':
                case 'item.addFromPath':
                case 'item.addBookmark':
                case 'item.open':

                case 'item.save':
                case 'folder.save':
                    let [type, method] = channel.split('.')
                    return eagle[type][method].apply(eagle, args).then(ret => callEvent(channel, ret))
                case 'library':
                    let { path, title } = g_db.opts
                    return callEvent('library', {
                        "applicationVersion": "3.0.0",
                        "folders": [],
                        "smartFolders": [],
                        "quickAccess": [],
                        "tagsGroups": [],
                        "modificationTime": new Date().getTime(),
                        path, name: title
                    })
                case 'exit':
                    return this.close(id)
            }
        })


    },

    close(id) {
        let _win = this.windows[id]
        if (_win) {
            _win.destory()
            delete this.windows[id]
        }
    },

    callEvent(id, eventName, data) {
        let _win = this.windows[id]
        if (_win && !_win.isDestroyed()) {
            _win.webContents.send(eventName, data)
        }
    },

    modal(){
        dialog({
            id: 'eagle_modal',
            html: `
                
            
            
            
            
            `,
            buttons: [{
                text: '获取ealge本地列表',
                class: 'btn-primary',
                default: true,
                id: 'ok',
                onClick: e => {


                }
            }]



        })

    }

}

g_eagle.init()
