
const os = require('os')
const url = require('url')
const fs = require('fs')
const path = require('path')
const remote = require('@electron/remote')
const { getCurrentWindow, getCurrentWebContents } = remote;
const { ipcRenderer, shell, clipboard, dialog, screen } = require('electron')
const _win = getCurrentWindow();
const _webContent = getCurrentWebContents();

const getLaunchParam = (key) => {
    let args = process.argv
    let index = args.indexOf(key)
    if (index != -1 && index < args.length - 1) {
        return args[index + 1]
    }
}

const manifest = JSON.parse(getLaunchParam('manifest'))
const _path = getLaunchParam('path')
const scriptPath = getLaunchParam('scriptPath')
const modules_path = scriptPath + 'node_modules/'

window.onbeforeunload = e => callEvent('onPluginBeforeExit', e)

const plugin_events = {}
const bindEvent = (eventName, callback) => {
    plugin_events[eventName] = callback
}

const callEvent = (eventName, args) => {
    let callback = plugin_events[eventName]
    if (callback) {
        callback.call(window.eagle, args)
    }
}

const getData = (name, args) => {
    return new Promise(reslove => {
        ipcRenderer.send(name, args)
        ipcRenderer.once(name, async (event, ret) => {
            reslove(ret)
        })
    })
};

['onPluginCreate', 'onPluginRun', 'onPluginBeforeExit', 'onPluginShow', 'onPluginHide', 'onLibraryChanged', 'onThemeChanged'].forEach(eventName => {
    ipcRenderer.on(eventName, (event, args) => callEvent(eventName, args))
})

window.addEventListener('DOMContentLoaded', () => {
    callEvent('onPluginCreate', { manifest, path })
    if(!process.env['inited']){
        process.env['inited'] = true
        callEvent('onPluginRun')
    }
})

let { arch, platform, env, execPath, pid, resourcesPath } = process

window.electron = {
    clipboard, dialog, shell, screen, os, remote, scriptPath,
    library_path: getLaunchParam('library'),
    path, url,
    window: _win,
    drag: { startDrag: _webContent.startDrag },
    isDev: true, // TODO
    toast: {},
    guid: length => {
        const characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
        return Array.from({ length }, () => characters[Math.floor(Math.random() * characters.length)]).join('');
    },
    manifest: {},
    notification: {
        async show({ title, description, icon, mute, duration }) {
            // TODO duration
            new Notification(title, {
                text: description,
                icon, slient: mute,
            });
        }
    },
    // 插件窗口建立时
    onPluginCreate(callback) {
        bindEvent('onPluginCreate', callback)
    },
    // 点击插件面板
    onPluginRun(callback) {
        bindEvent('onPluginRun', callback)
    },
    // 插件窗口关闭前
    onPluginBeforeExit(callback) {
        bindEvent('onPluginBeforeExit', callback)
    },
    // 插件窗口显示时
    onPluginShow(callback) {
        bindEvent('onPluginShow', callback)
    },
    // 插件窗口隐藏时
    onPluginHide(callback) {
        bindEvent('onPluginHide', callback)
    },
    // 当用户切换资源库时
    onLibraryChanged(callback) {
        bindEvent('onLibraryChanged', callback)
    },
    // 主题配色改变时
    onThemeChanged(callback) {
        bindEvent('onThemeChanged', callback)
    },
    log: {
        debug: console.debug,
        error: console.error,
        info: console.info,
        warn: console.warn,
    },
    plugin: {
        manifest, path: _path,
        webContentsID: _webContent.id,
        windowID: _win.id,
    },
    app: {
        version: "3.0.0",
        build: 45,
        isDarkColors: () => false, // TODO
        runningUnderARM64Translation: platform == 'arm64',
        locale: "zh_CN",
        arch, platform, env: { ...env }, execPath, pid, resourcesPath,
        isWindows: platform == 'win32',
        isMac: platform == 'drawin',
        theme: undefined
    },
    getData,
}

window.i18next = require(scriptPath + 'i18next.min.js')
let lang_file = _path + '_locales/' + (electron.app.locale || manifest.fallbackLanguage)   + '.json'
if (fs.existsSync(lang_file)) {
    try {
        window.i18next.init({
            resources: {
                'dev': { translation: JSON.parse(fs.readFileSync(lang_file)) },
            },
            fallbackLng: 'dev',
            ns: ['translation'],
            defaultNS: 'translation',
        }).then(t => {
            electron.plugin.manifest.name = t('manifest.app.name')
        })
    } catch (err) { }
}
