
class Folder {
    #id
    #name
    #description
    #icon
    #iconColor
    #createdAt
    #children
    #dirty

    constructor(obj) {
        if (!obj) { throw new Error("Error processing argument at index 0"); }
        this.#id = obj?.id;
        this.#name = obj?.name;
        this.#children = [];
        this.#description = obj?.description;
        this.#iconColor = obj?.iconColor;
        this.#icon = obj?.icon;
        this.#createdAt = obj?.modificationTime;
        // this.#tags = obj?.tags;
        this.#dirty = false;
        if (obj.children && obj.children.length > 0) {
            this.#children = Folder.convert(obj.children);
        }
    }

    // 保存修改
    async save() {
        return new Promise(async (resolve, reject) => {
            return
            let result = await ipcRenderer.r2r(parentID, 'folder.save', {
                id: this.id,
                name: this.name,
                description: this.description,
            });
            // TODO: 要有日誌
            if (result && result.id) {
                this.#dirty = false;
                return resolve(new Folder(result));
            }
            else {
                return reject(result);
            }
        });
    }

    // 🚧
    // 設定封面
    async setCover(item) {
        // TODO: 要有日誌
    }

    async open() {
        return

        await Folder.open(this.id);
    }

    get id() { return this.#id; }

    get name() { return this.#name; }
    set name(newName) {
        if (typeof newName === 'string' && newName.length > 0) {
            this.#name = newName;
            this.#dirty = true;
        }
        else {
            throw new Error("value must be a string.");
        }
    }

    get description() { return this.#description; }
    set description(newDescription) {
        if (typeof newDescription === 'string') {
            this.#description = newDescription;
            this.#dirty = true;
        }
        else {
            throw new Error("value must be a string.");
        }
    }

    get icon() { return this.#icon; }

    get iconColor() { return this.#iconColor; }

    get createdAt() { return this.#createdAt; }

    get children() { return this.#children; }

    // get tags() { return this.#tags; }

    static async create (options) {
        return new Promise(async (resolve, reject) => {
            return 
            // TODO: 要有日誌
            let result = await ipcRenderer.r2r(parentID, 'folder.create', options);
            if (result) {
                return resolve(new Folder(result));
            }
            return resolve(result);
        });
    }

    static async createSubfolder (parentId, options) {
        return
        options.parent = parentId;
        return (await eagle.folder.create(options) )
    }

    static async get (options) {
        return
        return new Promise(async (resolve, reject) => {
            let result = await ipcRenderer.r2r(parentID, 'folder.get', options);
            return resolve(Folder.convert(result));
        });
    }

    static async getAll () { return (await eagle.folder.get()); }

    static async getById (id) { return (await eagle.folder.get({id: id}))[0];  }
    
    static async getByIds (ids) { return (await eagle.folder.get({ids: ids})); }

    static async getSelected () { return (await eagle.folder.get({ isSelected: true })); }

    static async getRecents () { return (await eagle.folder.get({ isRecent: true })); }
    
    static async open (folderId) {
        return
        return new Promise(async (resolve, reject) => {
            let result = await ipcRenderer.r2r(parentID, 'folder.open', { folderId: folderId });
            return resolve(result);
        });
    }

    static convert(objs) {
        try {
            let folders = [];
            objs.forEach(obj => {
                folders.push(new Folder(obj));
            });
            return folders;
        } catch (err) {
            return [];
        }
    }
}

module.exports = Folder;