var isWeb
if(typeof(require) == 'undefined'){
    isWeb = true
    const buildProxy = handle => new Proxy(() => {}, handle)
    window.require = require = buildProxy( {
        apply(target, thisArg, args) {
            // loadRes(args, cb => console.log('ok', cb))
            return;
        },
    })
    // window.module = {}
    window.nodejs = buildProxy( {
        get(target, key) {
            // console.log(`Getting ${key}`);
            // TODO 转发给服务器处理
            switch(key){
                case 'files':
                    return {
                        exists: () => true,
                        dirFiles: () => {}
                    }
                case 'fs':
                    return {
                        readJSONSync: file => {
                            if(file.endsWith('formats.json')){
                                return {"category":{"audio":["wve","mp3","wv","wma","wav","w64","voc","tta","sph","snd","sln","ra","pvf","paf","opus","ogg","oga","nist","mp2","maud","m4r","m4a","ircam","hcom","flac","fap","dts","caf","avr","au","amb","aiff","ac3","aac","8svx"],"video":["mp4","ts","vob","rm","ogv","mxf","mts","mpg","mpeg","mjpeg","m4v","m2v","m2ts","hevc","f4v","wtv","asf","3gp","flv","avi","mkv","mov","wmv","webm"],"image":["jpg","png","jpeg","xpm","xcf","xbm","x3f","wpg","wbmp","tiff","tga","raf","svg","sgi","rw2","ras","psd","ppm","pnm","webp","pict","picon","pgm","pfm","pef","pes","pcx","pcd","pbm","pam","orf","nrw","nef","mng","jps","jpe","jp2","jfif","ico","heif","heic","hdr","gif","exr","cr2","dng","dds","cur","bmp"],"font":["woff","ttf","sfd","ps","pfb","otf","dfont"],"document":["txt","pdf","doc"],"archive":["zip","rar","7z","tar","gz"],"ingone":["gitignore","lrc"],"programe":["exe"]},"nativeThumbs":[]}
                            }
                        },
                    }

                case 'path':
                    return {
                        parse: path => {
                            const url = new URL(`file://${path}`);
                            const name = url.pathname.split('/').pop();
                            const ext = name.includes('.') ? `.${name.split('.').pop()}` : '';
                            const dir = url.pathname.replace(name, '').slice(1, -1);
                            return {
                              root: '/',
                              dir, ext,
                              base: name,
                              name: name.replace(ext, ''),
                            };
                        }
                    }
            }
            return () => {};
        },
    })
}
nodejs.globalShortcut.unregisterAll()
const win = nodejs.win

if (win && win.isWin7) { // 修复win7无法拖动文件
    let isDragging = false
    let mouseOffset = { x: 0, y: 0 }
    window.addEventListener('mousedown', (event) => {
        if (event.target.classList.contains('app-region-darg')) {
            let [x, y] = win.getPosition()
            isDragging = true
            mouseOffset.x = event.screenX - x
            mouseOffset.y = event.screenY - y
        }
    })
    window.addEventListener('mousemove', (event) => {
        isDragging && win.setPosition(event.screenX - mouseOffset.x, event.screenY - mouseOffset.y)
    })
    window.addEventListener('mouseup', () => isDragging = false)
}

registerIPC({
    exit: () => fetch('http://127.0.0.1:41597/exit'),
})