g_setting.setDefault({
    switchShow: 'CommandOrControl+Alt+X',
    darkMode: false,
    mac_traffic: true,
})
g_setting.setDefault('', false)
g_hotkey.register('f7',  {
    title: '设置',
    content: "doAction('settings,general')",
    type: 2,
})

let elements = 
g_setting.tabs.general = {
    title: '常规',
    icon: 'home',
    elements: Object.assign({
        switchShow: {
            title: '切换前后台显示',
            value: () => getConfig('switchShow'),
        }
    },
    nodejs.platform == 'darwin' ? {
        mac_traffic: {
            title: '红绿灯靠左',
            value: () => getConfig('mac_traffic'),
            type: 'switch',
        }
    } : {})
}

g_setting.tabs.plugins = {
    title: '插件',
    icon: 'plug',
    elements: {
       
    }
}

g_setting.onSetConfig({
    switchShow(val){
        let empty = isEmpty(val)
        nodejs.globalShortcut[empty ? 'unregister' : 'register'](val, () => {
            ipc_send('toggleShow')
        })
    },
    mac_traffic: () => toast('重启生效'),
})

$(function () {
    g_setting.apply(['darkMode', 'switchShow'])
});