
g_border.init({
	init(){
		let traffic = `
			<div class="light" data-action="min"></div>
			<div class="light" data-action="max"></div>
			<div class="light" data-action="close"></div>
		`
		let isMac = nodejs.platform == 'darwin' && getConfig('mac_traffic')
		this.bar.html(`
		<div class="flex-grow-1 ms-2 p-0">
			<div class="traffic_icons d-flex align-items-center m-0" style="top: 2px;">
				${isMac ? traffic : ''}
				<div data-action="sidebar_toggle,left">
					<i class="ti ti-layout-sidebar fs-2"></i>
				</div>
				<div id="title" data-action="db_menu"></div>
				<div class="flex-fill app-region-darg border-start border-1 ps-2" style="height: 20px;"></div>
			</div>
		</div>
		
		<div id="traffic">
			<div class="traffic_icons d-flex align-items-center m-0" style="font-size: 1.2rem;top: 2px;">
				<div data-action="search_show">
					<i class="ti ti-search fs-2"></i>
				</div>
				<input tabindex="-1" data-input="range_view" type="range" class="form-range pe-2 me-2 border-end" value="0"
					min="100" max="300" step="20" style="max-width: 125px;">
				<div data-action="sidebar_toggle,right">
					<i class="ti ti-layout-sidebar-right fs-2"></i>
				</div>
				<div data-action="pin"><i class="ti ti-pin fs-2"></i></div>
				${!isMac ? traffic : ''}
			</div>
			
		</div>
		`)
	},

	setTitle(title){
		$('#title').html(`<span class="badge bg-primary-lt d-flex">${title}</span>`)
	},

})
