// setInterval(() => {
//     if(g_datalist.view_getCurrentView() == 'waterfall'){
//         g_datalist.tab_getContent().resize()
//     }
// }, 2000)

const _setWaterfallWidth = (container, width) => {
    let instance = container.waterfall
    if(instance){
        if(width > 220) width = 220 // 图片尺寸最多220
        instance.call(container, 'option', {colWidth: width}, () => setTimeout(() => instance.call(container, 'reLayout'), 200))
        container.find('.datalist-item').css('width', width+'px')
    }
}

g_datalist.view_register('waterfall', {
    init(){
        // let view = '.datalist[data-view="waterfall"]'
        // let item = '.datalist-item'
        // g_style.addStyle('view_waterfall', `
       
        // `)
    },
    noMore: `
    <div class="text-center p-2 nomore" >
        <i class="ti ti-mood-empty fs-2"></i>
        <p>没有更多了...</p>
    </div>`,
    onShow(opts){
       g_datalist.tab_getContent(opts.id).resize() // BUG,切换tab后排序乱了
    },
    onHide(opts){
        g_datalist.tab_getContent(opts.id)
    },
    onClose(){

    },
    onInit(opts){
        let colWidth = parseInt(getConfig('itemWidth', 200))
        let container = g_datalist.tab_getContent(opts.id)
        container.waterfall({
            colWidth, 
            itemCls: 'waterfall-item', 
            prefix: 'waterfall',
            fitWidth: false, 
            gutterWidth: 20,
            gutterHeight: 20,
            align: 'center',
            maxPage: -1, 
            bufferPixel: 0, 
            containerStyle: {
                position: 'relative'
            },
            resizable: true, 
            isFadeIn: false,
            isAnimated: false,
            animationOptions: { },
            isAutoPrefill: false,
            checkImagesLoaded: false,
            path(page){
                return ''
            },
        })
        _setWaterfallWidth(container, colWidth)
    },
    
    onsetWidth(width){
        g_datalist.getDataByViewType('waterfall').forEach(({id}) => {
            _setWaterfallWidth(g_datalist.tab_getContent(id), width)
        })
    },
    onLoadItems(tab, content){
        content.imagesLoaded(() => { // 图片全部加载完成后触发
            g_datalist.tab_getContent(tab).resize().find('.waterfall-item.opacity-0').removeClass('opacity-0')
        });
    },
    container(v, k){
        return `
        <div class="datalist overflow-y-auto" onmousewheel="g_action.do(this, 'setItemWidth', event)"  data-view="waterfall" style="height: calc(100vh - 100px);" onScroll="g_datalist.onScroll(this)" >
            <div class="datalist-items w-full" ></div>
        </div>`
    },
    async item(d) {
        let r = Object.values(getConfig(replaceArr(['%name', '%duration', '%ext'], 'detail,'), true))
        let duration = r[2] ? (await g_detail.getDetail(d, 'media'))?.media?.duration : 0
        // let desc = r[1] ? (await g_detail.getDetail(d, 'desc'))?.desc : ''
        //  style="background-image: url(${fileToUrl(d.cover)}); backdrop-filter: blur(20px);"
        // <img src="${d.cover}" style="-webkit-filter: blur(10px);-webkit-transform: scale(1.2);opacity: .8;width: 100%;>
        return `
        <div class="waterfall-item datalist-item opacity-0 bg-auto" data-mousedown="item_click" data-dbclick="item_dbclick" {md5} {dargable}">
            <div class="position-relative card-preview text-center">
                ${OR(r[2], `<span class="badge bg-secondary position-absolute start-5 top-5">${getExtName(d.title)}</span>`)}
                <img src="${d.cover}" class="thumb rounded" {preview}>
                ${OR(r[1] && duration > 0, ` <span class="badge badge-secondary position-absolute end-5 bottom-5">${getTime(duration)}</span>`)}
            </div>
            ${OR(r[0], `<p class="text-muted p-2 text-nowrap">${d.title}</p>`)}
        </div>
        `
    }
})

