g_datalist.view_register('default', {
    init(){
        let view = '.datalist[data-view="default"]'
        let item = '.datalist-item'
        g_style.addStyle('view_default', `
            ${view} ${item} {
                margin: 5px !important;
                padding: 5px;
            }

            ${view} ${item} img {
            }
        `)
    },
    // object-fit: contain;
    // 
    noMore: `
    <div class="text-center w-full p-2 nomore" >
        <i class="ti ti-mood-empty fs-2"></i>
        <p>没有更多了...</p>
    </div>`,
    container: `
        <div class="datalist" onmousewheel="g_action.do(this, 'setItemWidth', event)" data-view="default">
            <div onScroll="g_datalist.onScroll(this)" class="d-flex flex-wrap align-content-start overflow-y-auto datalist-items justify-content-evenly" style="height: calc(100vh - 100px);"></div>
        </div>
    `,
    onsetWidth(width){
        g_datalist.getDataByViewType('default').forEach(({id}) => {
            g_datalist.tab_getContent(id).find('.datalist-item').each((i, el) => {
                let newWidth = width * el.dataset.width / el.dataset.height;
                $(el).css('width', newWidth+'px').find('img').css({width: newWidth+'px', height: width+'px' })
            })
        })
    },
    async item(d) {
        let r = Object.values(getConfig(replaceArr(['%name', '%desc', '%duration', '%ext'], 'detail,'), true))
        let {width, height, duration} = (await g_detail.getDetail(d, 'media')).media || {width: 200, height: 200, duration: 0}
        let maxHeight = getConfig('itemWidth', 200) * 1
        let newWidth = maxHeight * width / height;
        // let duration = r[2] ? (await g_detail.getDetail(d, 'media'))?.media?.duration : 0
        let desc = r[1] ? (await g_detail.getDetail(d, 'desc'))?.desc : ''
        return `
             <div class="datalist-item p-0 m-0 top-0" data-mousedown="item_click" data-dbclick="item_dbclick" data-width="${width}" data-height="${height}" style="width:${newWidth}px" {md5} {dargable}>
                <div class="card border-0 h-full position-relative justify-content-center" >
                  ${OR(r[3], `<span class="badge top-5 start-5 position-absolute w-fit" style="z-index: 2">${getExtName(d.file)}</span>`)}
                  
                  <a class="position-relative card-preview">
                    <img style="width:${newWidth}px;height:${maxHeight}px;" src="./res/loading.gif" data-src="${d.cover}" class="thumb card-img-top lazyload" {preview}>
                    ${OR(r[2] && duration > 0, ` <span class="badge badge-primary position-absolute end-0 bottom-0">${getTime(duration)}</span>`)}
                  </a>
                 
                  ${r[0] || r[1] ? `
                     <div class="card-body bg-auto p-2 text-center" style="height: 50px;">
                            ${OR(r[0], `<span class="text-wrap-2">${d.title}</span>`)}
                            ${OR(r[1], `<small class="text-wrap-2">${desc || ''}</small>`)}
                      </div>
                      ` : ''}
                </div>
            </div>
        `
    }
})

