var g_speicalFolder = new basedata({
    name: 'specailFolder',
    defaultList: [],
    primarykey: 'id',
    // list: local_readJson('specailFolder', []),
    list: [],
    saveData: data => local_saveJson('specailFolder', data),
    refresh() {
        let list = {}
        this.list.map(({type, title, icon, id}) => {
            let prefix = _l('sf_'+type)
            if(!isEmpty(prefix)) title = `<span class="badge badge-danger me-1">${prefix}</span>` + title
            list[id] =  {type, title, icon}
        })
        g_category.set('specailFolder', {
            action: 'category_specailFolder',
            list,
        })
    },
    init(){
        g_category.registerAction('specailFolder', (dom, action) => {
            // _inst.menu_key = action[2]
             let {dropdown_id} = this.getInst(action[2])
            g_dropdown.show(dropdown_id, dom)
        })
        g_action.registerAction({
            category_specailFolder: dom => this.callInst(dom.dataset.name, 'showFolder'),
            specailFolder_add: () => {
                // TODO 展示类型
                // this.callInst(dom.dataset.name, 'modal_edit', -1)
                // this.modal_edit(-1)
            },
            specailFolder_clear: () => confirm('确定清空吗？', {type: 'danger'}).then(() => this.reset())
        })

        g_menu.registerMenu({
            name: 'specailFolder_item',
            selector: `[data-collapse="specailFolder"]`,
            dataKey: 'data-name',
            items: [{
                icon: 'plus',
                text: '添加目录',
                action: 'specailFolder_add'
            }, {
                icon: 'trash',
                text: '清空',
                class: 'text-danger',
                action: 'specailFolder_clear'
            }]
        })

        g_lang.adds({
            specailFolder: {
                zh: '特殊目录',
                en: '',
            }
        })
    },
    insts: {},
    registerInst(name, opts){
        this.insts[name] = opts
    },
    getInst(id){
        let {type} = this.get(id)
        return this.insts[type]
    },
    callInst(id, method, ...args){
        let inst = this.getInst(id)
        inst[method].call(inst, id, ...args)
    }
});

