g_sidebar.register('bottom', {
    html: ``,
    defaultSize: { height: 150 },
    // onShow: e => setCssVar('--offset-bottom', (g_sizeable.data?.sidebarBottom?.height || 150) + 'px'),
    onHide: e => setCssVar('--offset-bottom', '0px')
})

g_plugin.registerEvent('onPluginsLoaded', () => {
    g_ui.register('datalistToolbars', {
        group: 'datalist_status',
        target: '#datalist_statusBar',
        html: `
            <div id="datalist_toolbar" class="d-flex flex-nowrap w-full m-0 ps-2 pe-2">
                <div class="me-auto d-flex">
                   
                </div>
                <div class="flex-fill text-end pe-2">
                </div>
                <div class="ms-auto border-start ps-2">
                   <div class="d-flex align-items-center" style="gap: 3px">
                        <button class="btn btn-rounded " data-action="datalist_tab_selectAll" title="全选">
                            <i class="ti ti-select-all"></i>
                        </button>
                        <button class="btn btn-rounded " data-action="datalist_tab_unsetAll" title="取消选择">
                            <i class="ti ti-deselect"></i>
                        </button>
                        <button class="btn btn-rounded " data-action="datalist_tab_selectReverse" title="反选">
                            <i class="ti ti-resize"></i>
                        </button>
                        <button class="btn btn-rounded " data-action="datalist_tab_refresh" title="刷新">
                            <i class="ti ti-reload"></i>
                        </button>
                        <span id="badge_datalist_selected" class="badge bg-azure hide">
                            选中<b></b>
                        </span>
                   </div>
                </div>
            </div>
        `
    })
})

g_sizeable.register('sidebarBottom', {
    selector: '#sidebar_bottom',
    memory: true,
    allow: ['top'],
    height_min: 50,
    height_max: 500,
    style: {backgroundColor: 'unset'},
    change: (t, i) => {
        let ret = { resize: false }
        if (t == 'height') {
            let { name, max } = g_ui.getGroupShown('sidebar_bottom').data() || {}
            if (!isEmpty(name)) {
                if (max == -1 || i > max) return ret
                g_sizeable.set(name, i)
            }
            setCssVar('--offset-bottom', i + 'px')
            return ret
        }
    }
})