var g_search = {
    defaultTab: 'file',

    // 格式话html
    replaceHTML(html) {
        return html.replace('%search_bar%', `
            <div class="input-icon mb-1 p-2">
                <input type="text" value="" class="form-control" placeholder="搜索..." data-input="input_search" data-keydown="input_search_keydown">
                <span class="input-icon-addon">
                <i class="ti ti-search fs-2"></i>
                </span>
            </div>
        `)
    },

    init() {
        const self = this
        g_hotkey.register({
            'ctrl+keyj': {
                title: "搜索界面",
                content: "doAction('search_show')",
                type: 2
            },
            'ctrl+tab': {
                title: "搜索界面-下一个",
                content: `g_modal.isShowing('modal_search') && g_search.tabs.next()`,
                type: 2
            }
        })

        g_action.registerAction({
            search_show: () => self.show(),
            input_search: dom => self.tab_search(self.tabs.getActive(), dom.value),
            input_search_keydown(dom, a, e) {
                if (e.keyCode == 13) {
                    let items = self.tab_getItems()
                    items.length && items[0].click()
                }
            },
        })

        self.modal = g_modal.modal_build({
            show: false,
            width: '80%',
            title: '搜索',
            scrollable: true,
            id: 'modal_search',
            bodyClass: 'overflow-x-hidden p-0',
            html: `<div id='search_div'></div>`,
            onShow() {
                if (self.changed) {
                    self.changed = 0
                    self.refresh()
                    self.tabs.setActive(self.defaultTab)
                    return
                }
                let current = self.tabs.getActive()
                current && self.input_focus(current, 100)
            },
        })

        self.tabs = new TabList({
            name: 'search',
            container: '#search_div',
            cardTabs: 'sticky-top',
            dbclick: '',
            moreItems: [],
            items: copyObj(this.tabItems),
            parseContent: () => content,
            event_shown({ tab }) {
                self.input_focus(tab, 200)
                self.onTabEvent(tab, 'onShow')
            }
        })

        // 在预览时改变视图
        g_plugin.registerEvent('item_preview', ({ dom }) => {
            dom = $(dom)
            if (dom.parents('.search_result').length) {
                dom.parents('.col-auto').addClass('col-12')
            }
        })
        g_plugin.registerEvent('item_unpreview', ({ dom }) => {
            dom = $(dom)
            if (dom.parents('.search_result').length) {
                dom.find('.col-12').removeClass('col-12')
            }
        })
    },

    tabItems: {},
    onTabEvent(tab, method, args){
        let inst = this.list[tab]
        if(inst && inst[method]){
            return inst[method].apply(inst, args)
        }
    },
    async tab_search(name, val) {
        let inst = this.list[name]
        inst.value = val
        let ret = inst.results = await inst.onSearch(val)

        let h = ''
        if (ret && ret.length) {
            h = (await Promise.all(ret.map(item => inst.onParse(item)))).join('')
        }
        this.getContent(name).html(h).find('.lazyload').lazyload()
        // todo 搜索框边框颜色
    },

    getContent(name) {
        name ??= this.tabs.getActive()
        return this.tabs.getContent(name).find('.search_result')
    },

    getInput(name){
        return this.tabs.getContent(name).find('[data-input="input_search"]')
    },

    tab_getItems(name) {
        return this.getContent(name).find('.result_item')
    },

    list: {},
    changed: 0,
    tabs_register(name, opts) {
        opts.tab.id = name
        this.list[name] = opts
        this.changed++
    },

    refresh() {
        this.tabs.setItems(Object.entries(this.list).map(([k, v]) => v.tab))
    },

    show(tab) {
        this.modal.method('show')
        if(!isEmpty(tab)){
            this.tabs.setActive(tab)
            this.input_focus(tab)
        }
    },

    input_focus(tab, timeout = 25) {
        setTimeout(() => this.getInput(tab).val('').focus(), timeout) // 自动聚焦
    }

}

g_search.init()
g_search.tabs_register('file', {
    tab: {
        icon: 'file',
        title: '文件',
        getTabIndex: () => 3,
        html: g_search.replaceHTML(`%search_bar%<div class="search_result list-group list-group-flush p-2"></div>`)
    },
    async onSearch(s) {
        return isEmpty(s) ? [] : await g_data.all(`SELECT * FROM files WHERE title LIKE '%${s}%' LIMIT 30;`)
    },
    async onParse(d) {
        Object.assign(d, await g_item.item_getVal(['file', 'cover'], d))
        let { tags, desc, media } = await g_detail.getDetail(d, ['desc', 'media', 'tags'])
        let duration = media ? media.duration : 0
        return g_datalist.initElementHTML(`
             <div class="list-group-item" data-mousedown="item_click" data-dbclick="item_dbclick" {md5} {dargable}>
              <div class="row">
                <div class="col-auto">
                  <a tabindex="-1" class="card-preview">    
                    <img class="avatar thumb" src="${d.cover}" {preview}>
                  </a>
                </div>
                <div class="col text-truncate">
                  <a data-action="files_load" class="text-body d-block">
                    ${g_tabler.build_badges(tags.map(tid => g_tags.folder_getValue(tid, 'title')))}
                    ${d.title}
                  </a>
                  <div class="text-muted text-truncate mt-n1">${desc || ''} ${duration ? getTime(duration) : ''}</div>
                </div>
              </div>
            </div>
        `, d)
    }
})


