assignInstance(g_preview, {
    init(){
        const _getPreviewList = async (opts) => {
            let {current, index, page_start} = opts

            let list = {}
            let pagePre = 15
            let items = g_datalist.tab_getData('sqlite').items
            index ??= items.findIndex(item => item.md5 == current)
            page_start ??= parseInt(index / pagePre)

            await Promise.all(items.slice(page_start * pagePre, (page_start + 1) * pagePre)
            .map(async ({md5, id}) => {
                let item = await g_data.data_get(md5)
                list[md5] = {
                    title: `<img width="20" src="${await g_item.item_getVal('cover', item)}" class="me-2">${item.title}`,
                    class: md5 == current ? 'active' : '',
                    action: 'preview_list_item',
                }
            }))

            let h1 = ''
            let offset = 0
            for(let i=page_start-5;i<page_start+5;i++){
                let page = i <= 0 ? ++offset : i + offset
                h1 += `<button data-action="preview_list_page" class="btn ${page == page_start + 1 ? 'btn-primary' : ''}">${page}</button>`
            }
            return Object.assign(list, {
                drive: {type: 'divider'},
                pages: {title: `<div class="btn-list">${h1}</div>`},
            })

        }

        g_hotkey.register('ctrl+p',  {
            title: '播放列表',
            content: "g_dropdown.quickShow('preview_list')",
            type: 2,
        })

        g_plugin.registerEvent('item_fullPreview', ({md5}) => {
            getEle('preview_list_item', '.active').removeClass('active')
            getEle({action: 'preview_list_item', name: md5}).addClass('active')
        })

        g_action.registerAction({
            preview_list_item: (dom) => { // 单击跳转播放
                let md5 = dom.dataset.name
                this.fullPreview(g_item.item_get(md5), md5)
            },
            preview_list_page: dom => { // 页面跳转
                _getPreviewList({
                    page_start: parseInt(dom.outerText) - 1,
                    current: g_preview.previewing.data.md5,
                }).then(items => g_dropdown.update('preview_list', {items}))
            }
        })

        g_dropdown.register('preview_list', {
            position: 'end-top',
            offsetLeft: 5,
            list() {
                return _getPreviewList({
                    current: g_preview.previewing.data.md5,
                })
            },
        })

        
    },



})