
assignInstance(g_preview, {
    tabs_inst: {},
    init() {
        g_style.addStyle('dplayer', `
            .dplayer-subtitle {}
            .dplayer-controller {margin-bottom: 15px}`)

        g_hotkey.register1([
            ['c', '视频加速', `doAction('video_speed,0.1')`, 1],
            ['x', '视频减速', `doAction('video_speed,-0.1')`, 1],
            ['z', '视频原速', `doAction('video_speed')`, 1],
        ])

        g_action.registerAction({
            video_speed: (dom, action) => {
                let video = g_preview.video
                let speed = video.playbackRate = Math.min(15, Math.max(0.1, isEmpty(action[1]) ? 1 : video.playbackRate + action[1] * 1)).toFixed(1)
                g_preview.dplayer.notice(speed+'倍速')
                setConfig('video_playback', speed)
            }
        })

        const preview_onMouseWheel = function (e) {
            let hotkeys = {
                'alt': 1,
                'ctrl': 5,
                'shift': 'duration * 0.01',
                'alt+shift': 'duration * 0.05',
                'ctrl+shift': 'duration * 0.1',
            }
            if (!$('input:focus').length) {
                e = e.originalEvent
                let key = getInputCode(e, 'key')
                if (key == '') return;

                let video = e.currentTarget
                let duration = video.duration
                if (!isNaN(duration)) {
                    let add = eval(hotkeys[key]) || 1
                    if (add < 1) add = 1;
                    video.currentTime += e.deltaY > 0 ? 0 - add : add;
                    clearEventBubble(e);
                }
            }
        }

        g_preview.register([...g_format.getCategory('video'), ...g_format.getCategory('audio')], {
            async onPreview(ev) {
                let { file, format, data, dom, opts } = ev
                let isVideo = g_format.getFileType(file) == 'video'
                ev.html = async () => `
                    <div id="item_preview" class="position-relative p-0 m-0" style="height: ${dom.height}px">
                        <video src="${fileToUrl(file)}" poster="${await g_item.item_getVal('cover', data)}" class="w-full" autoplay loop onclick="toggleVideoPlay(this)" data-out="item_unpreview" data-outfor="item_preview" style="height: 100%;object-fit: cover;"></video>

                        <div class="progress position-absolute bottom-0 w-full p-0 m-0 pe-none" style="border-radius: 0px;height: 3px;bottom: 3px;">
                        <div class="progress-bar progress-bar-striped progress-bar-animated" style="width: 0%;height: 3px;"></div>
                        </div>
                        ${isVideo ? `<a data-action="preview_mute" class="position-absolute top-5 end-5 rounded-circle btn p-1" data-hover="preview_mute_hover,off" data-out="preview_mute_hover,on"><i class="ti ti-volume"></i></a>` : ''}
                        <span class="badge position-absolute end-5 bottom-10 pe-none">
                            00:00:00
                        </span>
                    </div>
                `

                ev.cb = div => {
                    let video = div.find('video')
                    video[0].addEventListener('timeupdate', function (e) {
                        div.find('.badge').html(getTime(this.currentTime))
                        div.find('.progress-bar').css('width', (this.currentTime / this.duration * 100).toFixed(1) + '%')
                    })
                    setTimeout(() => {
                        let last = 0
                        video.
                            on('mousemove', function (e) {
                                if (!opts.isLive) {
                                    let pos = e.originalEvent.offsetX / $(this).width();
                                    if (Math.abs(last - pos) >= 0.005) {
                                        video[0].currentTime = video[0].duration * pos
                                    }
                                    last = pos
                                }
                            }).
                            on('mouseleave', e => {
                                if (getParentAttr(e.relatedTarget, 'data-md5') != data.md5) { // 忽略内元素
                                    g_preview.unpreview()
                                    video[0].src = ''
                                    video[0].load() // 停止视频加载
                                }
                            }).
                            on('mousewheel', preview_onMouseWheel)
                    }, 750) // 延迟绑定
                    isVideo && g_setting.apply('preview_mute')
                }
            },
            onFullPreview(ev) {
                let opts = ev.opts
                ev.html = `
                    <div class="row w-full h-full m-0">
                        <dplayer class="col h-full p-0" data-md5="${ev.data.md5}"></dplayer>
                        <div class="col col-xl-4 col-md-5 overflow-y-auto m-0 p-0" style="height: calc(100% - 0px);" id="preview_tabs">
                        </div>
                    </div>
                `
                ev.cb = modal => {
                    g_preload.check('dplayer', async () => {
                        let div = modal.find('dplayer')
                        let config = {
                            hotkey: false,
                            autoplay: true,
                            volume: 1,
                            container: div[0],
                            screenshot: true,
                            video: {
                                url: fileToUrl(ev.file),
                                pic: await g_item.item_getVal('cover', ev.data)
                            },
                            pluginOptions: {
                                flv: {
                                    mediaDataSource: {},
                                    config: {
                                        lazyLoad: false,
                                    },
                                },
                            },
                            contextmenu: [{
                                text: '打开文件位置',
                                click() {
                                    ipc_send('openFolder', ev.file)
                                },
                            }, {
                                text: '上一个',
                                click: () => g_preview.item_next(-1),
                            }, {
                                text: '下一个',
                                click: () => g_preview.item_next(1),
                            }, {
                                text: '删除',
                                click: () => doAction('item_trash'),
                            }]
                        }
                        g_plugin.callEvent('beforePlayerInit', { div, config, ev }).then(({ config }) => {
                            let player = g_preview.dplayer = new DPlayer(config)
                            let video = g_preview.video = player.video
                            $(video).on('mousewheel', preview_onMouseWheel)
                            player.on('loadeddata', e => {
                                if (opts.start > 0 && opts.start <= video.duration) {
                                    video.currentTime = opts.start
                                }
                                video.playbackRate = getConfig('video_playback', 1)
                            })
                            player.on('error', e => toast('加载文件失败', 'danger'))
                        })
                    })

                }
            }
        })


    }
})
