g_style.addStyle(`viewer`, `
    .viewer-button.viewer-fullscreen {display: none}
    .viewer-footer{margin-bottom: 10px}
    .viewer-container{height: 100% !important}
`)

// nodejs.remote.session.defaultSession.protocol.uninterceptProtocol('img')
// nodejs.remote.session.defaultSession.protocol.interceptBufferProtocol('img', (request, callback) => {
//     let target = atob(request.url.slice('img://'.length))
//     // 本地文件转blob,防止url解码错误
//     callback(nodejs.files.readFile(target))
// })

g_item.item_hidePreview = () => $('.icon_image_preview').remove()
g_item.item_showPreview = async function(md5, show = true) {
    let data = await g_data.data_getData(md5)
    let file = await g_item.item_getVal('preview', data)
    let dom = g_item.item_get(data.md5).find('.card-preview')

    let {width, height} = await g_item.getCoverSize(data, {maxHeight: 300})
    let {right, bottom} = dom[0].getBoundingClientRect()
    $(`<div id="image_preview" class="position-fixed icon_image_preview" style="z-index: 99999">
        <img src="res/loading.gif" data-src="${fileToUrl(file)}" style="width: ${width}px;height: ${height}px;" class="w-full lazyload">
     </div>`)
    .appendTo('body')
    .css(getAvailbleRect({
        width, height,
        left: right,
        top: bottom,
    }, document.body.getBoundingClientRect()))
    .on('mouseout', e => g_item.item_hidePreview())
    .lazyload()
}

// g_plugin.registerEvent('item_unpreview', () => g_item.item_hidePreview())

g_preview.register(g_format.getCategory('image'), {
    onPreview(ev) {
        let { data, dom } = ev
        g_item.item_hidePreview()

        let classes = 'position-absolute bottom-0 end-0 icon_image_preview'
        $(`
            <i class="ti ti-zoom-in text-light ${classes}"></i>
            <a id="btn_image_preview" class="${classes}" style="width: 0;height: 0;line-height: 0;font-size: 0;border: 14px solid transparent;border-right-color: rgba(0, 0, 0, .2);border-bottom-color: rgba(0, 0, 0, .2);"></a>
        `)
            .insertAfter(dom)
            .on('mouseenter', e => g_item.item_showPreview(data.md5, true))
            .on('mouseleave', e => {
                // 弹出的图片可能会覆盖入口图标
                if(!$(e.relatedTarget).parents('#image_preview').length){
                    g_item.item_hidePreview()
                }
            })
    },
    async onFullPreview(ev) {
        let { format, data, dom, opts } = ev
        let file = await g_item.item_getVal('preview', data)
        let imgs = toArr(data.gallery || file)

        ev.html = `
        <ul id="_images" class="d-none">
            ${imgs.map(src => {
                // if(!src.startsWith('http')) src = 'img://'+btoa(src)
                return `<li><img src="${src}" class="h-full" hidden></li>`
            }).join('')}
        </ul>
        `
        ev.cb = modal => {
            g_preload.check('viewer', () => {
                let div = modal.find('#_images')
                // TODO 侧边展示图片列表
                div.viewer({
                    inline: true,
                    navbar: imgs.length > 1,
                    transition: false,
                    title: ({alt, naturalWidth, naturalHeight}) =>  `(${naturalWidth} x ${naturalHeight}) ${data.title}`,
                    // viewed: function() {},
                    toolbar: {
                        zoomIn: 4,
                        zoomOut: 4,
                        oneToOne: 4,
                        reset: 4,
                        prev: {
                            click: () => g_preview.item_next(-1)
                        },
                        play: {
                          show: 4,
                          size: 'large',
                        },
                        next: {
                            click: () => g_preview.item_next(1)
                        },
                        rotateLeft: 4,
                        rotateRight: 4,
                        flipHorizontal: 4,
                        flipVertical: 4,
                    },
                })
            })
        }
    }
})

