var g_preview = {
    init() {
        const self = this
        g_preload.register('dplayer', {
            list: ['DPlayer.min.js', 'dash.all.min.js', 'flv.min.js', 'hls.min.js'].map(k => '../public/js/' + k),
            check: () => typeof(DPlayer) != 'undefined'
        })
        g_preload.register('viewer', {
            list: ['../public/js/viewer.min.js', '../public/js/jquery-viewer.min.js', '../public/css/viewer.min.css'],
            check: () => typeof($().viewer) != 'undefined'
        })

        g_action.registerAction({
            preview_mute_hover: (adm, action) => {
                if(getConfig('preview_mute')) g_setting.apply({preview_mute: action[1] == 'on'})
            },
            preview_mute: (adm) => g_setting.toggleValue('preview_mute'),
            item_unpreview: (dom, action, e) => self.unpreview(e),
            preview_unFullPreview: () => g_modal.remove('fullPreview'),
            preview_toggleTabs: () => toggleConfig('hidePreviewTabs'),
            preview_toggleFullPreview: () => g_modal.toggle('fullPreview'),
            preview_min: () => g_modal.hide('fullPreview'),
        })

        g_setting.onSetConfig({
            preview_mute: b => {
                getEle('preview_mute').find('i').replaceClass('ti-', 'ti-volume' + (b ? '-off' : ''))
                self.getElement(' video')[0].muted = b
            },
            hidePreviewTabs: b => $('#preview_tabs').toggleClass('hide', b),
        })

        g_hotkey.register({
            'ctrl+arrowleft': {
                title: '全屏查看上一首',
                content: `
                (() => {
                    g_preview.isPreviewing() && g_preview.item_next(-1)
                    return false
                })()
                `,
                type: 2,
            },
            'ctrl+arrowright':{
                title: '全屏查看下一首',
                content: `
                (() => {
                    g_preview.isPreviewing() && g_preview.item_next(1)
                    return false
                })()
                `,
                type: 2,
            },
            'space': {
                title: '播放/暂停',
                content: "g_preview.isPreviewing() && g_preview.togglePlay()",
                type: 1,
            }
        })

        g_style.addStyle(`preview`, `
            .item_previewing {
                z-index: 2;
            }
            .item_previewing video {
                z-index: 2;
                width: 100%;
                height: 100%;
                object-fit: cover;
            }
            .item_previewing .thumb {
                display: none !important;
            }
            .item_previewing .card-preview > :not(#item_preview) {
               display: none !important;
            }
        `)
        
        g_plugin.registerEvent('item_fullPreview', ev => this.on('onFullPreview', ev), 99)
        g_plugin.registerEvent('item_preview',  ev => this.on('onPreview', ev), 99)
        g_plugin.registerEvent('afterDraggedFile', () => setTimeout(() => this.unpreview(), 200))

        const unpreview = () => self.unpreview() & doAction('item_unpreviewVideo')
        $(document).on('mouseleave', '.datalist', unpreview)
        $(window).on('blur', unpreview)
    },
    tryPlay(){
        let video = this.video
        if(video && video.isPaused){
            video.play()
            delete video.isPaused
        }
    },
    tryPause(){
        let video = this.video
        if(video && !video.paused){
            video.isPaused = true
            video.pause()
        }
    },
    togglePlay(play){
        let audio = g_preview.video
        if(play == undefined) play = !audio.paused
        audio[play ? 'play' : 'pause']()
    },

    isPreviewing(){
        return this.previewing != undefined && g_modal.isShowing('fullPreview')
    },

    item_next(offset, md5){
        md5 ??= this.previewing?.data?.md5
        let ret = g_datalist.findItemIndex({md5, offset})
        if(ret.md5){
            this.fullPreview({md5: ret.md5})
        }
    },

    setCurrentTime(time){
        let video = this.video
        if(video){
            video.currentTime = time
            video.play()
        }
    },

    getElement(s = '') {
        return $('#item_preview' + s)
    },

    unpreview(ev) {
        // 在视频上打开菜单
        if (g_menu.target && g_menu.target.hasClass('datalist-item')) return;
        if (ev && ev.relatedTarget) {
            // 还在范围内
            if ($(ev.relatedTarget).parents('.card-preview').length) return
        }

        let dom = $('.item_previewing').removeClass('item_previewing')
        let el = dom.find('#item_preview')
        el.find('video,audio').each((i, media) => {
            media.src = ''
            media.load() // 停止加载,触发abort
        })
        el.remove()
        g_plugin.callEvent('item_unpreview', { ev, dom })
    },

    async fullPreview({dom, md5, opts = {}}) {
        let html, cb
        // dom.data('json') || 
         dom ??= g_item.item_get(md5)
        let data = await g_data.data_getFullData(md5)
        g_plugin.callEvent('item_fullPreview', { dom, md5, opts, data, html, cb }).then(async ret => {
            let { dom, md5, opts, data, html, cb } = ret
            this.unpreview()

            html = await toVal(html)
            if(html === '') return // 被插件取消
            if(html == undefined) return ipc_send('openFile', data.file) // 默认双击打开
            
            let modal = this.modal = g_modal.modal_build({
                html,
                id: 'fullPreview',
                header: `
                <div class="d-flex w-full bg-auto align-items-center" id="fullPreview_header">
                    <div class="ps-2">
                        <b>${data.title}</b>
                    </div>
                    <div class="ms-auto">
                        <a class="btn btn-ghost-secondary" data-action="preview_toggleTabs"><i class="ti ti-layout-sidebar-right"></i></a>
                        <a class="btn btn-ghost-info" data-action="preview_min"><i class="ti ti-minus"></i></a>
                        <a class="btn btn-ghost-danger" data-bs-dismiss="modal"><i class="ti ti-x"></i></a>
                    </div>
                </div>
               `,
                bodyClass: 'd-flex p-0 overflow-hidden',
                type: 'fullscreen',
                once: true,
                show: true,
                // show: !g_modal.exists('fullPreview'), // TODO 设置项，双击总是打开
                hotkey: true,
                width: '100%',
                onShow: () => {
                    // 侧边栏tab信息
                    let list = Object.entries(g_preview.tabs_inst).map(([name, opts]) => opts.tab)
                    let tabs = g_preview.tabs = new TabList({
                        list,
                        dbclick: '',
                        name: 'preview_tabs',
                        container: '#preview_tabs',
                        moreItems: [],
                        cardBody: 'p-0',
                        event_shown: ({tab, ev}) => setTimeout(() => g_preview.tabs_inst[tab].onShow(ev), 500),
                        event_hide: ({tab, ev}) => g_preview.tabs_inst[tab].onHide(ev),
                        onCntChanged(cnt){
                            this.inst.getContainer().toggleClass('hide', cnt == 0)
                        },
                    })
                    tabs.refresh()
                    tabs.setActiveIndex(0)
                    g_setting.apply(['hidePreviewTabs'])
                },
                onClose: () => {
                    let data = 
                    g_plugin.callEvent('item_unFullPreview', g_preview.previewing.data).then(() => {
                        delete g_preview.player
                        delete g_preview.modal
                        delete g_preview.previewing
                    })
                }
            })
            typeof(cb) == 'function' && cb(modal)
            g_plugin.callEvent('item_fullPreviewed', {modal, ...ret})
        })
    },
    async preview(dom, md5, opts = {}) {
        let html, cb
        let data = await g_data.data_getFullData(md5)
        if(g_selection.isShowing()) return
        g_plugin.callEvent('item_preview', { dom, md5, opts, data, html, cb }).then(async ({ dom, md5, opts, data, html, cb }) => {
            this.unpreview()
            html = await toVal(html)
            if (isEmpty(html)) return

            getParent(dom, 'data-md5').addClass('item_previewing')
            let div = $(html).insertBefore(dom)
            cb && cb(div)
        })
    },
    list: {},
    register(formats, opts) {
        toArr(formats).forEach(format => {
            this.list[format] = Object.assign(this.list[format] || {}, opts)
        })
        return this
    },

    async on(method, ev) {
        if(!nodejs.win.isFocused()) return

        let file = ev.data.link || await g_item.item_getVal('file', ev.data)
        ev.format = getExtName(file).toLowerCase()
        ev.file = file
        
        this.previewing = {method, data: ev}
        // TODO 全屏preview退出事件
        let cb =  this.list?.[ev.format]?.[method]
        cb && await cb(ev)
    },


}

g_preview.init()
