(() => {
    g_plugin.registerEvent('onBeforeShowingDetail', ({ items, columns, type }) => {
        if (items.length == 1 && type == 'sqlite') {
            columns.title = {
                multi: false,
                html([d]){
                    return `
                    <div class="input-group input-group-sm mb-2">
                      <span class="input-group-text" id="inputGroup-sizing-sm">名称</span>
                      <input data-input="detailChanged,title" data-change="detailChanged,title" type="text" class="form-control form-control-flush border-hover" placeholder="..." value="${getFileName(d.title, false) || ''}">
                    </div>
                `
                }
            }
        }
    })
    
    g_plugin.registerEvent('item.detail.changed.title', ({ list, val }) => {
        list.forEach(async md5 => {
            let file = await g_item.item_getVal('file', md5)
            if (!nodejs.files.exists(file) || isEmpty(val)) return
            
            let { dir, name, ext } = nodejs.path.parse(file)
            let newFile = dir + '/' + val + ext
            nodejs.fs.renameSync(file, newFile)
            await g_data.date_setVal(md5, 'title', val + ext)
            g_item.item_update(md5)
        })
    })

})()