(() => {

    g_plugin.registerEvent('onBeforeShowingDetail', ({ columns, type }) => {
        // if (type != 'sqlite') return
        columns.status = {
            multi: true,
            classes: 'border-top',
            list: {
                files: {
                    check: i => i > 1,
                    title: '文件数量',
                    class: 'bg-indigo-lt',
                    getVal(items) {
                        let cnt = items.length
                        if (cnt > 1) return cnt
                    }
                },
                size: {
                    title: '大小',
                    class: 'bg-indigo-lt',
                    getVal: items => renderSize(items.reduce((total, item) => total + item.size, 0))
                },
                ext: {
                    check: (i, d) => i == 1 && !nodejs.files.isDir(d[0].link),
                    title: '扩展名',
                    class: 'bg-lime-lt',
                    getVal: ([d]) => getExtName(d.title)
                },
                link: {
                    check: i => i == 1,
                    title: '链接文件',
                    class: 'bg-lime-lt',
                    getVal: ([d]) => {
                        let isDir = nodejs.files.isDir(d.link)
                        return `<a href='#' data-action="${isDir ? 'openFolder' : 'openFile'}" data-file="${d.link}" title='${d.link}'>${isDir ? '目录' : '文件'}</a>`
                    }
                },
                date: {
                    check: i => i == 1,
                    title: '改动',
                    class: 'bg-red-lt',
                    primary: -10,
                    getVal: ([d]) => getFormatedTime(5, d.date)
                },
                bir: {
                    check: i => i == 1,
                    title: '创建',
                    class: 'bg-red-lt',
                    primary: -11,
                    getVal: ([d]) => getFormatedTime(5, d.birthtime)
                },
                // files: {
                //     check: i => i == 1,
                //     title: '关联',
                //     class: 'bg-blue-lt',
                //     primary: -12,
                //     getVal: () => `
                //         <div class="d-flex flex-wrap justify-content-end">
                //             <div><span class="badge badge-outline text-blue">srt字幕</span></div>
                //             <div><span class="badge badge-outline text-azure">片段1</span></div>
                //             <div><span class="badge badge-outline text-indigo">视频MV</span></div>
                //             <div><span class="badge badge-outline text-orange">笔记信息</span></div>
                //         </div>
                //     `
                // }
            },
            async html(items) {
                let h = ''
                if(this.list){
                    let cnt = items.length
                    for (const [k, v] of Object.entries(this.list).sort((a, b) => {
                        let a1 = a[1].primary || 0
                        let b1 = b[1].primary || 0
                        return b1 - a1
                    })) {
                        if (v.check && v.check(cnt, items) === false) continue
                        let val = await v.getVal(items)
                        if (isEmpty(val) || val === false) continue
                        h += `
                            <div class="d-flex p-1" ${v.props || ''}>
                                <span class="badge ${v.class}" style="height: fit-content;min-width: 45px;">${v.title}</span>
                                <div class="flex-fill text-end">${val}</div>
                            </div>
                        `
                    }
                }
                return `
                    <div class="rows align-items-center mt-2 w-full align-self-end">
                        ${h}
                    </div>`
            }

        }
    }, 99)
})()