(() => {

    g_data.table_indexs.score_meta = ['fid', 'score']
     g_plugin.registerEvent('db_connected', ({db}) => {
        db.exec(`
        CREATE TABLE IF NOT EXISTS score_meta(
            fid  INTEGER PRIMARY KEY,
            score TINYINT
        );`)
        
        // 排序
        g_datalist.sort.register('score', {
            title: '评分',
            async callback(items){
                for(let k in items){
                    let v = items[k]
                    v.score = await getScore(v)
                }
                return items.sort((a, b) => b.score - a.score)
            }
        })
    })


    const removeScore = (fid) => g_data.data_remove2({table: 'score_meta', key: 'fid', value: fid})
    const setScore = (fid, score) => g_data.data_set2({ table: 'score_meta', key: 'fid', value: fid, data: { fid, score } })
    const getScore = async d => obj_From_key(await g_data.getMetaInfo(d, 'score'), 'score').score || 0
    g_detail.inst.score = {set: setScore, get: getScore, remove: removeScore}

    g_plugin.registerEvent('onBeforeShowingDetail', ({ items, columns, type }) => {
        if(!columns.status || type != 'sqlite') return
            columns.status.list.score = {
                title: '评分',
                class: 'bg-blue-lt',
                primary: 99,
                async getVal(d) {
                    let h1 = ''
                    let score = d.length == 1 ? await getScore(d[0]) : 0
                    for (let i = 0; i < 5; i++) h1 += `<option value="${i}" ${i == score ? 'selected' : ''}></option>`
                    return `
                    <div class="rating float-end">
                        <div data-star="detail_score" data-value="${score}"></div>
                    </div>`
                }
            }
    })

    g_plugin.registerEvent('onShowedDetail', () => {
        new Star('detail_score',  {
            max: 5,
            onSelected(val){
                g_detail.selected_keys.forEach(async md5 => {
                    setScore(await g_data.data_getID(md5), val)
                })
            }
        }).refresh()
    })

    g_plugin.registerEvent('db_afterInsert', ({ opts, ret, method }) => {
        let fid = ret.lastInsertRowid
        if (fid > 0 && method == 'insert' && opts.table == 'files') {
            let score = opts.data.meta.score
            score > 0 && setScore(fid, score)
        }
    })

})()