(() => {

    // 获取导入的视频信息并储存到独立db
     g_plugin.registerEvent('db_connected', ({db}) => {
        db.exec(`
        CREATE TABLE IF NOT EXISTS media_meta(
            fid      INTEGER PRIMARY KEY,
            duration INT,
            width    INT,
            height   INT,
            frame    TINYINT,
            bit_rate INT,
            sample_rate INT
        );`)
        
        g_datalist.sort.register('duration', {
            title: '时长',
            async callback(items){
                for(let k in items){
                    let v = items[k]
                    let meta = await getMeta(v)
                    v.duration = meta?.duration || 0
                }
                return items.sort((a, b) => b.duration - a.duration)
            }
        })

        g_datalist.sort.register('px', {
            title: '分辨率',
            async callback(items){
                for(let k in items){
                    let v = items[k]
                    let meta = await getMeta(v)
                    v.px = (meta?.width || 0) + (meta?.height || 0)
                }
                return items.sort((a, b) => b.px - a.px)
            }
        })
    })
    g_data.table_indexs.media_meta = ['fid', 'duration', 'width', 'height', 'frame', 'bit_rate', 'sample_rate']

    const removeMeta = (fid) => g_data.data_remove2({table: 'media_meta', key: 'fid', value: fid})
    const setMeta = (fid, data) => {
        if(data){
            data = Object.assign({
                fid,
                duration: 0,
                width: 0,
                height: 0,
                frame: 0,
                bit_rate: 0,
                sample_rate: 0,
            }, data)
            return g_data.data_set2({ table: 'media_meta', key: 'fid', value: fid, data})
        }
    }
    const getMeta = async d => g_data.getMetaInfo(d, 'media')
    const loadMeta = (data, fid) => {
        return new Promise(async reslove => {
            let type = g_format.getFileType(data.title)
            if (!['video', 'audio', 'image'].includes(type)) return reslove()

            let json = data.json || {}
            let file = await g_item.getInputFile(data)
            let streams = (await g_ffmpeg.video_meta(file)).streams
            if(!streams) return reslove()

            const getStream = name => streams.find(({ codec_type }) => codec_type == name)
            let audio = getStream('audio')
            let video = getStream('video')
            if (audio) {
                let picture = getStream('video')
                let { bit_rate, sample_rate, duration } = audio
                Object.assign(json, { bit_rate, sample_rate, duration })
            }

            if (video) {
                json.width = video.width
                json.height = video.height
                let { width, height, avg_frame_rate: frame, duration } = video
                
                if(type != 'image'){
                    json.frame = video.frame
                    json.duration = video.duration
                }else
                if(audio && video.codec_name == 'mjpeg'){ // 音频有封面图
                    
                }
            }
            // if (json.width != undefined && json.height != undefined) {
                if (fid == undefined) fid = data.id
                g_plugin.callEvent('loadMetadata', {id: fid, json, data}).then(({json}) => {
                    setMeta(fid, json)
                    reslove(json)
                })
            // }
        })
    }
    g_detail.inst.media = { set: setMeta, get: getMeta, load: loadMeta, remove: removeMeta }
    
    g_plugin.registerEvent('onBeforeShowingDetail', async ({ items, columns, type }) => {
        let len = items.length
        if(len == 0 || type != 'sqlite') return
        if (len == 1) {
            let update 
            let d = items[0]
            let meta = await getMeta(d)
            if(!meta){
                meta = await loadMeta(d)
                if(!meta) return
                update = true
            }
            let type = g_format.getFileType(d.title)
            if (['video', 'image'].includes(type)) {
                Object.assign(columns.status.list, {
                    px: {
                        title: '分辨率',
                        class: 'bg-orange-lt',
                        getVal: () => meta.width + 'x' + meta.height
                    },
                    // frame: {
                    //     title: '帧数',
                    //     class: 'bg-orange-lt',
                    //     getVal: () => meta.frame
                    // }
                })
                if(type == 'video'){
                    Object.assign(columns.status.list, {
                        duration: {
                            title: '时长',
                            class: 'bg-orange-lt',
                            getVal: () => getTime(meta.duration)
                        }
                    })
                }
            } else
            if (type == 'audio') {
                Object.assign(columns.status.list, {
                    rate: {
                        title: '采样率',
                        class: 'bg-orange-lt',
                        getVal: () => meta.sample_rate
                    },
                    bit_rate: {
                        title: '比特率',
                        class: 'bg-orange-lt',
                        getVal: () => meta.bit_rate
                    },
                })
            }
            update && g_detail.updateColumns('status')
        }else{
            let total = (await Promise.all(items.map(async item =>  (await getMeta(item))?.duration || 0))).reduce((a, b) => a + b)
            Object.assign(columns.status.list, {
                duration: {
                    title: '时长',
                    class: 'bg-orange-lt',
                    getVal: () => getTime(total)
                }
            })
        }
    })

    g_plugin.registerEvent('db_afterInsert', async ({ opts, ret, method }) => {
        let { table, data } = opts
        if (table == 'files' && method == 'insert'){
            let fid = ret.lastInsertRowid
            if(fid > 0  && ['video', 'audio', 'image'].includes(g_format.getFileType(data.title))){
                let {duration, width, height} = opts.data.meta
                if(duration || width || height){
                    // 导入时附带的参数
                    setMeta(fid, {
                        duration: duration || 0,
                        width: width || 0,
                        height: height || 0,
                    })
                }else{
                    loadMeta(data, ret.lastInsertRowid)
                }
            }
        }
    })

})()