(() => {
     g_plugin.registerEvent('db_connected', ({db}) => {
        db.exec(`
        CREATE TABLE IF NOT EXISTS url_meta(
            fid  INTEGER PRIMARY KEY,
            url TEXT
        );`)
    })
    g_data.table_indexs.url_meta = ['fid', 'url']
    const removeURL = (fid) => g_data.data_remove2({table: 'url_meta', key: 'fid', value: fid})
    const setURL = (fid, url) => g_data.data_set2({ table: 'url_meta', key: 'fid', value: fid, data: { fid, url } })
    const getURL = async d => obj_From_key(await g_data.getMetaInfo(d, 'url'), 'url').url

    g_detail.inst.url = {set: setURL, get: getURL, remove: removeURL}

    g_plugin.registerEvent('onBeforeShowingDetail', ({ columns, type }) => {
        if(type != 'sqlite') return
        columns.url = {
            multi: true,
            async html(items) {
                let url = items.length == 1 ? await getURL(items[0]) : ''
                return `
                <div class="input-group input-group-sm mb-2">
                    <span class="input-group-text" id="inputGroup-sizing-sm" data-action="detail_url">
                        链接
                    </span>
                    <input type="text" data-input="detailChanged,url" data-change="detailChanged,url" placeholder="https://" class="form-control form-control-flush border-hover"  value="${url || ''}">
                    ${!isEmpty(url) ? `<span class="input-group-text" onclick="ipc_send('url', this.previousElementSibling.value)">GO</span>` : ''}
                </div>`
            },
        }
    })

    g_plugin.registerEvent('item.detail.changed.url', ({ list, val }) => {
        list.forEach(async md5 => {
            let fid = await g_data.data_getID(md5)
            setURL(fid, val)
        })
    })

    g_plugin.registerEvent('db_afterInsert', ({ opts, ret, method }) => {
        let fid = ret.lastInsertRowid
        if (fid > 0 && method == 'insert' && opts.table == 'files') {
            let url = opts.data.meta.url
            !isEmpty(url) && url.toLowerCase().startsWith('http') && setURL(fid, url)
        }
    })

})()