(() => {

    g_data.table_indexs.desc_meta = ['fid', 'desc']
    g_plugin.registerEvent('db_connected', ({ db }) => {
        db.exec(`
        CREATE TABLE IF NOT EXISTS desc_meta(
            fid  INTEGER PRIMARY KEY,
            desc TEXT
        );`)
    })

    const removeDesc = (fid) => g_data.data_remove2({ table: 'desc_meta', key: 'fid', value: fid })
    const setDesc = (fid, desc) => g_data.data_set2({ table: 'desc_meta', key: 'fid', value: fid, data: { fid, desc } })
    const getDesc = async d => obj_From_key(await g_data.getMetaInfo(d, 'desc'), 'desc').desc
    g_detail.inst.desc = { set: setDesc, get: getDesc, remove: removeDesc }

    g_plugin.registerEvent('onBeforeShowingDetail', ({ columns, type }) => {
        if(type != 'sqlite') return
        columns.desc = {
            multi: true,
            async html(items) {
                let desc = items.length == 1 ? await getDesc(items[0]) : ''
                return `
                <div class="input-group input-group-sm mb-2">
                    <span class="input-group-text" id="inputGroup-sizing-sm">注释</span>
                    <textarea data-input="detailChanged,desc" data-change="detailChanged,desc" class="form-control border-hover" placeholder="..." rows="3" >${desc || ''}</textarea>
                </div>`
            },
        }
    })

    g_plugin.registerEvent('item.detail.changed.desc', ({ list, val }) => {
        list.forEach(async md5 => {
            let fid = await g_data.data_getID(md5)
            setDesc(fid, val)
        })
    })

    g_plugin.registerEvent('db_afterInsert', ({ opts, ret, method }) => {
        let fid = ret.lastInsertRowid
        if (fid > 0 && method == 'insert' && opts.table == 'files') {
            let desc = opts.data.meta.desc
            if(!isEmpty(desc)){
                setDesc(fid, desc)
            }
        }
    })

    g_search.tabs_register('desc', {
        tab: {
            icon: 'message',
            title: '注释',
            getTabIndex: () => 4,
            html: g_search.replaceHTML(`%search_bar%<div class="search_result list-group list-group-flush p-2"></div>`)
        },
        async onSearch(s) {
            return await g_data.all(`SELECT * FROM desc_meta ${isEmpty(s) ? '' : `WHERE desc LIKE '%${s.replaceAll("'", "''")}%'`} LIMIT 30;`)
        },
        async onParse(d) {
            d = await g_data.data_getDataByID(d.fid)
            Object.assign(d, await g_item.item_getVal(['file', 'cover'], d))
            let { tags, desc, media } = await g_detail.getDetail(d, ['desc', 'media', 'tags'])
            let duration = media ? media.duration : 0
            return g_datalist.initElementHTML(`
                 <div class="list-group-item" data-mousedown="item_click" data-dbclick="item_dbclick" {md5} {dargable}>
                  <div class="row">
                    <div class="col-auto">
                      <a tabindex="-1" class="card-preview">    
                        <img class="avatar thumb" src="${d.cover}" {preview}>
                      </a>
                    </div>
                    <div class="col text-truncate">
                      <a data-action="files_load" class="text-body d-block">
                        ${g_tabler.build_badges(tags.map(tid => g_tags.folder_getValue(tid, 'title')))}
                        ${d.title}
                      </a>
                      <div class="text-muted text-truncate mt-n1">${desc || ''} ${duration ? getTime(duration) : ''}</div>
                    </div>
                  </div>
                </div>
            `, d)
        }
    })

})()