(() => {
    g_plugin.registerEvent('onBeforeShowingDetail', ({ columns, items }) => {
        if (items.length != 0) return
        
        let { title, icon, data } = g_datalist.tabs.getData()
        columns.datalist = {
            multi: 0,
            html() {
                return `
                    <div class="text-center w-full row m-0 mb-2">
                        <i class="ti ti-${icon || 'inbox'} col-12 mb-3 fs-lg"></i>
                        <span class="col-12">${title}</span>
                    </div>
                `
            }
        }

        columns.datalist_status = {
            multi: 0,
            classes: 'border-top mh-50',
            list: {
                results: {
                    title: '结果数',
                    class: 'bg-indigo-lt',
                    getVal: () => data?.items?.length || 0
                },
            },
            async html(items) {
                let h = ''
                let cnt = items.length
                for (const [k, v] of Object.entries(this.list).sort((a, b) => {
                    let a1 = a[1].primary || 0
                    let b1 = b[1].primary || 0
                    return b1 - a1
                })) {
                    if (v.check && v.check(cnt) === false) continue
                    let val = await v.getVal(items)
                    if (isEmpty(val) || val === false) continue
                    h += `
                            <div class="d-flex p-1" ${v.props || ''}>
                                <span class="badge ${v.class}">${v.title}</span>
                                <div class="flex-fill text-end">${val}</div>
                            </div>
                        `
                }
                return `
                    <div class="rows align-items-center mt-2 w-full align-self-end">
                        ${h}
                    </div>`
            }
        }
    }, 99)
})()