

var g_format = {
	init(){
		this.data = Object.assign(nodejs.fs.readJSONSync(nodejs.dir+'/formats.json'), nodejs.files.readJson(nodejs.dir+'/formats_user.json'))
		this.initIcons()
	},
	isThumbSupport(ext){
		return !isEmpty(ext) && this.data.thumbSupports.includes(ext.toLowerCase())	
	},
	isNativeThumbAllow(ext){
		return this.data.nativeThumbs.includes(ext.toLowerCase())
	},
	initIcons(){
		let icons = {}
		nodejs.files.dirFiles(nodejs.dir+'/res/formats/', ['svg', 'jpg', 'png', 'ico'], files => {
			files.forEach(file => icons[getFileName(file, false)] = file)
			this.icons = icons
		})
	},
	addToCategory(name, exts){
		return toArr(exts).filter(ext => {
			let list = this.data.category[name] ??= []
			return list.includes(ext) ? false : list.push(ext)
		})
	},
	getCategory(name){
		return (this.data.category[name] || []).map(k => k.toLowerCase())
	},

	getFormats(){
		return flattenArray(Object.entries(this.data.category).map(([k, v]) => k != 'ingone' ? v : [])).map(k => k.toLowerCase())
	},

	getFileType(ext){
		if(isEmpty(ext)) return
		if(ext.endsWith('/') || ext.endsWith('/')) return 'folder'
		ext = getExtName(ext).toLowerCase()
		for(let [type, list] of Object.entries(this.data.category)){
			if(list.includes(ext)) return type
		}
	},

	getFormatIcon(ext){
		let type = this.getFileType(ext) ?? getExtName(ext).toLowerCase()
		return this.icons[type] ?? './res/file.png'
	}
}

g_format.init()


function getFileType(file) {
    return g_format.getFileType(file)
}