
g_form.registerPreset('tab_selector', {
    setVal(dom, val, opts) {
        let h = ''
        toArr(val).forEach(id => {
            if (id != ''){
                h += `<span class="badge bg-primary me-2" data-action="folder_selector_remove" data-id="${id}">${g_tabs.list[opts.tab].getValue(id, 'title')}<i class="ti ti-x ms-2"></i></span>`
            }
        })
        $(dom).find('.badge-list').html(h)
    },
    getVal: dom => getElementsValues($(dom).find('.badge'), el => el.dataset.id),
    getPreset: `
        <label class="form-label">{title}</label>
        <div class="card shadow-none bg-transparent w-full form_input" id="{id}" style="min-height: 38px;">
            <div class="card-body p-2 cursor-text position-relative">
                <div class="badge-list"></div>
                <i class="ti ti-folder ms-2 fs-3 position-absolute end-10 top-10" data-action="tab_list" title="标签列表"></i>
            </div>
        </div>
    `
})

g_action.registerAction({
    tab_list: dom => {
        let {id, name, item} = g_form.getFormByDom(dom)
        let list = {}
        g_tabs.list[item.tab].data.entries((k, v) => list[v.id] = v.title)
        confirm(
        g_tabler.build_checkbox_list({
            list,
            id: 'tab_selector_list',
        }, {title: '选择标签页'})).then(() => {
            let selected = getElementsValues($('#tab_selector_list input[type="checkbox"]:checked'))
            g_form.setElementVal(id, name, selected)
        })
    }
})


// setTimeout(() => {
//     g_form.confirm('tab_selector', {
//         elements: {
//             tab: {
//                 type: 'tab_selector',
//                 title: '目标标签页',
//                 tab: 'tablist',
//                 value: []
//             },
//         },
//     }, {
//         id: 'tab_selector',
//         title: '测试标签页',
//         onBtnClick: (btn, modal) => {
//             if (btn.id == 'btn_ok') {
//                 console.log(g_form.getVals('tab_selector'))
//             }
//         }
//     })
// }, 2000)