var g_detail = {
    selected_keys: [],
    inst: {},
    columns: {},
    // TODO 信息栏菜单

    // 调用接口
    async getDetail(data, keys){
        let r = {}
        if(keys == undefined){
            keys = Object.keys(this.inst)
        }else
        if(!Array.isArray(keys)) keys = [keys]
        await Promise.all(keys.map(async n => {
            let inst = this.inst[n]
            if(inst) r[n] = await inst.get(data)
        }))
        return r
    },
    tabs_inst: {
        detail: {
            tab: {
                icon: 'file-info',
                alt: '信息',
                html: `<div id="detail" class="p-2 d-flex flex-wrap align-content-start"></div>`,
            },
            onShow: () => g_sizeable.restore('sidebarRight'),
        },
        // a: {
        //     tab: {
        //         icon: 'script',
        //         alt: '脚本',
        //         html: `TODO`
        //     }
        // },
        // b: {
        //     tab: {
        //         icon: 'wand',
        //         alt: '处理',
        //         html: `TODO`
        //     }
        // },
        // c: {
        //     tab: {
        //         icon: 'world-search',
        //         alt: '找图',
        //         html: `TODO`
        //     }
        // }
    },
    // 触发tabs事件
    triggerTabEvent(method, tab, args = {}){
        let inst = g_detail.tabs_inst[tab]
        inst[method] && inst[method].call(inst, {...args, ...{items: this.selected_items, keys: this.selected_keys}})
    },
    init() {
        const self = this
        g_plugin.registerEvent('onPluginsLoaded', () => {
            g_sidebar.register('right', {
                html: `
                    <div class="position-relative h-full">
                        <div id="detail_tabs" class="w-full h-full"></div>
                    </div>
                `,
                onShow: e => {
                    setCssVar('--offset-right', (g_sizeable.data?.sidebarRight?.width || 200) + 'px')
                },
                onInit: () => {
                    if(self.tabs) return

                    let list = Object.entries(self.tabs_inst).map(([name, opts]) => Object.assign({id: name}, opts.tab))
                    let tabs = self.tabs = g_preview.tabs = new TabList({
                        list,
                        name: 'detail_tabs',
                        dbclick: '',
                        hideOneTab: true,
                        container: '#detail_tabs',
                        moreItems: [],
                        class: 'show-icons',
                        cardBody: 'p-0',
                        event_shown({tab}){
                            self.triggerTabEvent('onShow', tab)
                        },
                        event_hide({tab}){
                            self.triggerTabEvent('onHide', tab)
                        },
                        // onCntChanged(cnt){
                        //     this.inst.getContainer().toggleClass('hide', cnt == 0)
                        // },
                    })
                    tabs.refresh()
                    tabs.setActiveIndex(0)
                },
                onHide: e => setCssVar('--offset-right', '0px')
            })
    
            g_sizeable.register('sidebarRight', {
                selector: '#sidebar_right',
                memory: true,
                allow: ['left'],
                width_min: 150,
                width_max: 400,
                style: {backgroundColor: 'unset'},
                change: (t, i) => {
                    if (t == 'width') {
                        setCssVar('--offset-right', (getConfig('sidebar_right') ? i : 0) + 'px')
                        return { resize: false }
                    }
                }
            })
            $('#sidebar_right').addClass('border-start')
        })

        g_action.registerAction({
            detailChanged(dom, args, ev){
                let key = 'item.detail.changed.'+args[1]
                let cb = () => {
                    let list = self.selected_keys
                    let val = dom.value
                    g_plugin.callEvent(key, {dom, args, ev, list, val})
                }
                g_pp.setTimeout(key, cb, 500)
            },
            hide_columns(){

            }
        })
    },

    // 返回信息元素
    getColumnContent(name) {
        return $('#detail_columns_' + name)
    },

    last_columns: {},
    // 更新指定信息
    async updateColumns(list) {
        let items = await Promise.all(this.selected_keys.map(md5 => g_data.data_get(md5)))
        toArr(list).forEach(async name => {
            let col = this.last_columns[name]
            if(col.html){
                this.last_columns[name]
                let html = await col.html(items)
                this.getColumnContent(name).replaceWith(this.getColumnPreset(name, html))
            }
        })
    },

    // 获取预设
    getColumnPreset(name, html) {
        let item = this.last_columns[name] || {}
        return `<div id="detail_columns_${name}" class="w-full ${item.classes || ''}">${html}</div>`
    },

    // 获取选中的属性
    getSelected(cb){
        if(typeof(cb) !== 'function'){
            let key = cb
            cb = item => key == undefined ? item : item[key]
        }
        return this.selected_items.map(cb)
    },

    // 展示列表
    async showList(list, opts = {}) {
        let cnt = list.length
        let  {sqlite, preset} = opts
        if(!(sqlite ??= g_datalist.tab_getData('sqlite'))) return

        preset ??= sqlite.getPreset()
        let items = await Promise.all(list.map(key => preset.parseItem.call(sqlite, key)))
        let detail = copyFn(await applyFunArray([[preset, 'columns'], [this, 'columns']], items))
        g_plugin.callEvent('onBeforeShowingDetail', { items, ...detail }).then(async ({ items, columns, sort }) => {
            this.last_columns = columns
            this.selected_items = items
            this.selected_keys = Object.values(items).map(item => item.md5)
            
            columns = Object.entries(columns).filter(([k, v]) => {
                if(cnt == 0) return v.multi === 0 // 补选中标识
                return !(!v.multi && cnt > 1) // 过滤掉不支持复数选择的
            }).sort((a, b) => {
                let a1 = sort.indexOf(a[0])
                let b1 = sort.indexOf(b[0])
                return a1 - b1
            })

            let html = (await Promise.all(columns.map(async ([name, column]) => {
                return this.getColumnPreset(name, await column.html(items))
            }))).join('')
            $('#detail').html(html).find('.lazyload').lazyload()
            g_plugin.callEvent('onShowedDetail', {columns})

            let tab = this.tabs.getActive()
            if(tab != undefined){
                this.triggerTabEvent('onShow', tab)
            }else{
                this.tabs.setActive('detail')
            }
        })
    },

    // 选中当前鼠标所在的元素
    selectedByMouse(){
        let {target} = g_cache.mouse
        if(!target) return
        let md5 = getParentData(target, 'md5')
        if(md5 != undefined){
            this.showList([md5])
        }
        return md5
    },

    // 获取当前选择的MD5列表
    getSelectedKeys(){
        let list = this.selected_keys
        if(!list.length && g_menu.key != undefined) list = [g_menu.key]
        return list
    },

    // 获取当前选择的详细Item列表
    async getDetailItem(md5){
        let data = g_datalist.item_getData(md5)
        return Object.assign(data,  g_item.item_getVal(['file', 'cover'], data))
    },

    // 获取当前选择的Item列表
    async getSelectedItems(){
        let list = this.selected_items
        if(!list.length && g_menu.key != undefined){
            list = [await this.getDetailItem(g_menu.key)]
        }
        return list
    },

    // 返回右键菜单选择目标
    async getSelectedTarget(){
        let keys = this.selected_keys
        if(keys.includes(g_menu.key)){ // 选中内的右键
            list = this.selected_items
        }else{
            list = [await this.getDetailItem(g_menu.key)]
        }
        return list
    },

    update() {
        this.showList(this.selected_keys)
    },

    clear(){
        this.showList([])
    }
}

g_detail.init()
